/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.text_to_speech.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.text_to_speech.v1.model.Word;
import com.ibm.watson.text_to_speech.v1.model.Words;
import java.util.ArrayList;
import java.util.List;

public class AddWordsOptions
extends GenericModel {
    protected String customizationId;
    protected List<Word> words;

    protected AddWordsOptions(Builder builder) {
        Validator.notEmpty((String)builder.customizationId, (String)"customizationId cannot be empty");
        Validator.notNull((Object)builder.words, (String)"words cannot be null");
        this.customizationId = builder.customizationId;
        this.words = builder.words;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String customizationId() {
        return this.customizationId;
    }

    public List<Word> words() {
        return this.words;
    }

    public static class Builder {
        private String customizationId;
        private List<Word> words;

        private Builder(AddWordsOptions addWordsOptions) {
            this.customizationId = addWordsOptions.customizationId;
            this.words = addWordsOptions.words;
        }

        public Builder() {
        }

        public Builder(String customizationId, List<Word> words) {
            this.customizationId = customizationId;
            this.words = words;
        }

        public AddWordsOptions build() {
            return new AddWordsOptions(this);
        }

        public Builder addWord(Word word) {
            Validator.notNull((Object)((Object)word), (String)"word cannot be null");
            if (this.words == null) {
                this.words = new ArrayList<Word>();
            }
            this.words.add(word);
            return this;
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }

        public Builder words(List<Word> words) {
            this.words = words;
            return this;
        }

        public Builder words(Words words) {
            this.words = words.words();
            return this;
        }
    }
}

