/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.text_to_speech.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class CreateSpeakerModelOptions
extends GenericModel {
    protected String speakerName;
    protected InputStream audio;

    protected CreateSpeakerModelOptions(Builder builder) {
        Validator.notNull((Object)builder.speakerName, (String)"speakerName cannot be null");
        Validator.notNull((Object)builder.audio, (String)"audio cannot be null");
        this.speakerName = builder.speakerName;
        this.audio = builder.audio;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String speakerName() {
        return this.speakerName;
    }

    public InputStream audio() {
        return this.audio;
    }

    public static class Builder {
        private String speakerName;
        private InputStream audio;

        private Builder(CreateSpeakerModelOptions createSpeakerModelOptions) {
            this.speakerName = createSpeakerModelOptions.speakerName;
            this.audio = createSpeakerModelOptions.audio;
        }

        public Builder() {
        }

        public Builder(String speakerName, InputStream audio) {
            this.speakerName = speakerName;
            this.audio = audio;
        }

        public CreateSpeakerModelOptions build() {
            return new CreateSpeakerModelOptions(this);
        }

        public Builder speakerName(String speakerName) {
            this.speakerName = speakerName;
            return this;
        }

        public Builder audio(InputStream audio) {
            this.audio = audio;
            return this;
        }

        public Builder audio(File audio) throws FileNotFoundException {
            this.audio = new FileInputStream(audio);
            return this;
        }
    }
}

