/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.text_to_speech.v1.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class WaveUtils {
    private static final int WAVE_HEADER_SIZE = 8;
    private static final int WAVE_METADATA_POS = 74;
    private static final int WAVE_SIZE_POS = 4;

    private WaveUtils() {
    }

    private static void writeInt(int value, byte[] array, int offset) {
        for (int i = 0; i < 4; ++i) {
            array[offset + i] = (byte)(value >>> 8 * i);
        }
    }

    public static InputStream reWriteWaveHeader(InputStream is) throws IOException {
        byte[] audioBytes = WaveUtils.toByteArray(is);
        int filesize = audioBytes.length - 8;
        WaveUtils.writeInt(filesize, audioBytes, 4);
        WaveUtils.writeInt(filesize - 8, audioBytes, 74);
        return new ByteArrayInputStream(audioBytes);
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }
}

