/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.tone_analyzer.v3;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.tone_analyzer.v3.model.ToneAnalysis;
import com.ibm.watson.tone_analyzer.v3.model.ToneChatOptions;
import com.ibm.watson.tone_analyzer.v3.model.ToneOptions;
import com.ibm.watson.tone_analyzer.v3.model.UtteranceAnalyses;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.HttpUrl;

public class ToneAnalyzer
extends BaseService {
    private static final String SERVICE_NAME = "tone_analyzer";
    private static final String SERVICE_URL = "https://gateway.watsonplatform.net/tone-analyzer/api";
    private String versionDate;

    public ToneAnalyzer(String versionDate) {
        this(versionDate, ConfigBasedAuthenticatorFactory.getAuthenticator((String)SERVICE_NAME));
    }

    public ToneAnalyzer(String versionDate, Authenticator authenticator) {
        super(SERVICE_NAME, authenticator);
        if (this.getServiceUrl() == null || this.getServiceUrl().isEmpty()) {
            this.setServiceUrl(SERVICE_URL);
        }
        Validator.isTrue((versionDate != null && !versionDate.isEmpty() ? 1 : 0) != 0, (String)"version cannot be null.");
        this.versionDate = versionDate;
    }

    public ServiceCall<ToneAnalysis> tone(ToneOptions toneOptions) {
        Validator.notNull((Object)((Object)toneOptions), (String)"toneOptions cannot be null");
        String[] pathSegments = new String[]{"v3/tone"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v3", (String)"tone");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (toneOptions.contentType() != null) {
            builder.header(new Object[]{"Content-Type", toneOptions.contentType()});
        }
        if (toneOptions.contentLanguage() != null) {
            builder.header(new Object[]{"Content-Language", toneOptions.contentLanguage()});
        }
        if (toneOptions.acceptLanguage() != null) {
            builder.header(new Object[]{"Accept-Language", toneOptions.acceptLanguage()});
        }
        if (toneOptions.sentences() != null) {
            builder.query(new Object[]{"sentences", String.valueOf(toneOptions.sentences())});
        }
        if (toneOptions.tones() != null) {
            builder.query(new Object[]{"tones", RequestUtils.join(toneOptions.tones(), (String)",")});
        }
        builder.bodyContent(toneOptions.contentType(), (Object)toneOptions.toneInput(), null, toneOptions.body());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ToneAnalysis>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<UtteranceAnalyses> toneChat(ToneChatOptions toneChatOptions) {
        Validator.notNull((Object)((Object)toneChatOptions), (String)"toneChatOptions cannot be null");
        String[] pathSegments = new String[]{"v3/tone_chat"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v3", (String)"toneChat");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (toneChatOptions.contentLanguage() != null) {
            builder.header(new Object[]{"Content-Language", toneChatOptions.contentLanguage()});
        }
        if (toneChatOptions.acceptLanguage() != null) {
            builder.header(new Object[]{"Accept-Language", toneChatOptions.acceptLanguage()});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.add("utterances", GsonSingleton.getGson().toJsonTree(toneChatOptions.utterances()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<UtteranceAnalyses>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

