/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.tone_analyzer.v3.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.tone_analyzer.v3.model.Utterance;
import java.util.ArrayList;
import java.util.List;

public class ToneChatOptions
extends GenericModel {
    private List<Utterance> utterances;
    private String contentLanguage;
    private String acceptLanguage;

    private ToneChatOptions(Builder builder) {
        Validator.notNull((Object)builder.utterances, (String)"utterances cannot be null");
        this.utterances = builder.utterances;
        this.contentLanguage = builder.contentLanguage;
        this.acceptLanguage = builder.acceptLanguage;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<Utterance> utterances() {
        return this.utterances;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public static class Builder {
        private List<Utterance> utterances;
        private String contentLanguage;
        private String acceptLanguage;

        private Builder(ToneChatOptions toneChatOptions) {
            this.utterances = toneChatOptions.utterances;
            this.contentLanguage = toneChatOptions.contentLanguage;
            this.acceptLanguage = toneChatOptions.acceptLanguage;
        }

        public Builder() {
        }

        public Builder(List<Utterance> utterances) {
            this.utterances = utterances;
        }

        public ToneChatOptions build() {
            return new ToneChatOptions(this);
        }

        public Builder addUtterances(Utterance utterances) {
            Validator.notNull((Object)((Object)utterances), (String)"utterances cannot be null");
            if (this.utterances == null) {
                this.utterances = new ArrayList<Utterance>();
            }
            this.utterances.add(utterances);
            return this;
        }

        public Builder utterances(List<Utterance> utterances) {
            this.utterances = utterances;
            return this;
        }

        public Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }
    }

    public static interface AcceptLanguage {
        public static final String AR = "ar";
        public static final String DE = "de";
        public static final String EN = "en";
        public static final String ES = "es";
        public static final String FR = "fr";
        public static final String IT = "it";
        public static final String JA = "ja";
        public static final String KO = "ko";
        public static final String PT_BR = "pt-br";
        public static final String ZH_CN = "zh-cn";
        public static final String ZH_TW = "zh-tw";
    }

    public static interface ContentLanguage {
        public static final String EN = "en";
        public static final String FR = "fr";
    }
}

