/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.tone_analyzer.v3;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.tone_analyzer.v3.model.ToneAnalysis;
import com.ibm.watson.tone_analyzer.v3.model.ToneChatOptions;
import com.ibm.watson.tone_analyzer.v3.model.ToneOptions;
import com.ibm.watson.tone_analyzer.v3.model.UtteranceAnalyses;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.HttpUrl;

public class ToneAnalyzer
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "tone_analyzer";
    public static final String DEFAULT_SERVICE_URL = "https://api.us-south.tone-analyzer.watson.cloud.ibm.com";
    private String version;

    public ToneAnalyzer(String version) {
        this(version, DEFAULT_SERVICE_NAME, ConfigBasedAuthenticatorFactory.getAuthenticator((String)DEFAULT_SERVICE_NAME));
    }

    public ToneAnalyzer(String version, Authenticator authenticator) {
        this(version, DEFAULT_SERVICE_NAME, authenticator);
    }

    public ToneAnalyzer(String version, String serviceName) {
        this(version, serviceName, ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName));
    }

    public ToneAnalyzer(String version, String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        this.setVersion(version);
        this.configureService(serviceName);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        Validator.notEmpty((String)version, (String)"version cannot be empty.");
        this.version = version;
    }

    public ServiceCall<ToneAnalysis> tone(ToneOptions toneOptions) {
        Validator.notNull((Object)((Object)toneOptions), (String)"toneOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v3/tone"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v3", (String)"tone");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (toneOptions.contentType() != null) {
            builder.header(new Object[]{"Content-Type", toneOptions.contentType()});
        }
        if (toneOptions.contentLanguage() != null) {
            builder.header(new Object[]{"Content-Language", toneOptions.contentLanguage()});
        }
        if (toneOptions.acceptLanguage() != null) {
            builder.header(new Object[]{"Accept-Language", toneOptions.acceptLanguage()});
        }
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (toneOptions.sentences() != null) {
            builder.query(new Object[]{"sentences", String.valueOf(toneOptions.sentences())});
        }
        if (toneOptions.tones() != null) {
            builder.query(new Object[]{"tones", RequestUtils.join(toneOptions.tones(), (String)",")});
        }
        builder.bodyContent(toneOptions.contentType(), (Object)toneOptions.toneInput(), null, toneOptions.body());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ToneAnalysis>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<UtteranceAnalyses> toneChat(ToneChatOptions toneChatOptions) {
        Validator.notNull((Object)((Object)toneChatOptions), (String)"toneChatOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v3/tone_chat"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v3", (String)"toneChat");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (toneChatOptions.contentLanguage() != null) {
            builder.header(new Object[]{"Content-Language", toneChatOptions.contentLanguage()});
        }
        if (toneChatOptions.acceptLanguage() != null) {
            builder.header(new Object[]{"Accept-Language", toneChatOptions.acceptLanguage()});
        }
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        contentJson.add("utterances", GsonSingleton.getGson().toJsonTree(toneChatOptions.utterances()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<UtteranceAnalyses>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

