/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.tone_analyzer.v3.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.tone_analyzer.v3.model.ToneInput;
import java.util.ArrayList;
import java.util.List;

public class ToneOptions
extends GenericModel {
    protected ToneInput toneInput;
    protected String body;
    protected String contentType;
    protected Boolean sentences;
    protected List<String> tones;
    protected String contentLanguage;
    protected String acceptLanguage;

    protected ToneOptions(Builder builder) {
        this.toneInput = builder.toneInput;
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.sentences = builder.sentences;
        this.tones = builder.tones;
        this.contentLanguage = builder.contentLanguage;
        this.acceptLanguage = builder.acceptLanguage;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public ToneInput toneInput() {
        return this.toneInput;
    }

    public String body() {
        return this.body;
    }

    public String contentType() {
        return this.contentType;
    }

    public Boolean sentences() {
        return this.sentences;
    }

    public List<String> tones() {
        return this.tones;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public static class Builder {
        private ToneInput toneInput;
        private String body;
        private String contentType;
        private Boolean sentences;
        private List<String> tones;
        private String contentLanguage;
        private String acceptLanguage;

        private Builder(ToneOptions toneOptions) {
            this.toneInput = toneOptions.toneInput;
            this.body = toneOptions.body;
            this.contentType = toneOptions.contentType;
            this.sentences = toneOptions.sentences;
            this.tones = toneOptions.tones;
            this.contentLanguage = toneOptions.contentLanguage;
            this.acceptLanguage = toneOptions.acceptLanguage;
        }

        public Builder() {
        }

        public ToneOptions build() {
            return new ToneOptions(this);
        }

        public Builder addTone(String tone) {
            Validator.notNull((Object)tone, (String)"tone cannot be null");
            if (this.tones == null) {
                this.tones = new ArrayList<String>();
            }
            this.tones.add(tone);
            return this;
        }

        public Builder sentences(Boolean sentences) {
            this.sentences = sentences;
            return this;
        }

        public Builder tones(List<String> tones) {
            this.tones = tones;
            return this;
        }

        public Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public Builder toneInput(ToneInput toneInput) {
            this.toneInput = toneInput;
            this.contentType = "application/json";
            return this;
        }

        public Builder text(String text) {
            this.body = text;
            this.contentType = "text/plain";
            return this;
        }

        public Builder html(String html) {
            this.body = html;
            this.contentType = "text/html";
            return this;
        }
    }

    public static interface AcceptLanguage {
        public static final String AR = "ar";
        public static final String DE = "de";
        public static final String EN = "en";
        public static final String ES = "es";
        public static final String FR = "fr";
        public static final String IT = "it";
        public static final String JA = "ja";
        public static final String KO = "ko";
        public static final String PT_BR = "pt-br";
        public static final String ZH_CN = "zh-cn";
        public static final String ZH_TW = "zh-tw";
    }

    public static interface ContentLanguage {
        public static final String EN = "en";
        public static final String FR = "fr";
    }

    public static interface Tone {
        public static final String EMOTION = "emotion";
        public static final String LANGUAGE = "language";
        public static final String SOCIAL = "social";
    }
}

