/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.visual_recognition.v4.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.visual_recognition.v4.model.TrainingDataObject;
import java.util.ArrayList;
import java.util.List;

public class AddImageTrainingDataOptions
extends GenericModel {
    private String collectionId;
    private String imageId;
    private List<TrainingDataObject> objects;

    private AddImageTrainingDataOptions(Builder builder) {
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        Validator.notEmpty((String)builder.imageId, (String)"imageId cannot be empty");
        this.collectionId = builder.collectionId;
        this.imageId = builder.imageId;
        this.objects = builder.objects;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String imageId() {
        return this.imageId;
    }

    public List<TrainingDataObject> objects() {
        return this.objects;
    }

    public static class Builder {
        private String collectionId;
        private String imageId;
        private List<TrainingDataObject> objects;

        private Builder(AddImageTrainingDataOptions addImageTrainingDataOptions) {
            this.collectionId = addImageTrainingDataOptions.collectionId;
            this.imageId = addImageTrainingDataOptions.imageId;
            this.objects = addImageTrainingDataOptions.objects;
        }

        public Builder() {
        }

        public Builder(String collectionId, String imageId) {
            this.collectionId = collectionId;
            this.imageId = imageId;
        }

        public AddImageTrainingDataOptions build() {
            return new AddImageTrainingDataOptions(this);
        }

        public Builder addObjects(TrainingDataObject objects) {
            Validator.notNull((Object)((Object)objects), (String)"objects cannot be null");
            if (this.objects == null) {
                this.objects = new ArrayList<TrainingDataObject>();
            }
            this.objects.add(objects);
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public Builder objects(List<TrainingDataObject> objects) {
            this.objects = objects;
            return this;
        }
    }
}

