/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.visual_recognition.v4.model;

import com.ibm.cloud.sdk.core.service.model.FileWithMetadata;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class AddImagesOptions
extends GenericModel {
    private String collectionId;
    private List<FileWithMetadata> imagesFile;
    private List<String> imageUrl;
    private String trainingData;

    private AddImagesOptions(Builder builder) {
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        this.collectionId = builder.collectionId;
        this.imagesFile = builder.imagesFile;
        this.imageUrl = builder.imageUrl;
        this.trainingData = builder.trainingData;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String collectionId() {
        return this.collectionId;
    }

    public List<FileWithMetadata> imagesFile() {
        return this.imagesFile;
    }

    public List<String> imageUrl() {
        return this.imageUrl;
    }

    public String trainingData() {
        return this.trainingData;
    }

    public static class Builder {
        private String collectionId;
        private List<FileWithMetadata> imagesFile;
        private List<String> imageUrl;
        private String trainingData;

        private Builder(AddImagesOptions addImagesOptions) {
            this.collectionId = addImagesOptions.collectionId;
            this.imagesFile = addImagesOptions.imagesFile;
            this.imageUrl = addImagesOptions.imageUrl;
            this.trainingData = addImagesOptions.trainingData;
        }

        public Builder() {
        }

        public Builder(String collectionId) {
            this.collectionId = collectionId;
        }

        public AddImagesOptions build() {
            return new AddImagesOptions(this);
        }

        public Builder addImagesFile(FileWithMetadata imagesFile) {
            Validator.notNull((Object)imagesFile, (String)"imagesFile cannot be null");
            if (this.imagesFile == null) {
                this.imagesFile = new ArrayList<FileWithMetadata>();
            }
            this.imagesFile.add(imagesFile);
            return this;
        }

        public Builder addImageUrl(String imageUrl) {
            Validator.notNull((Object)imageUrl, (String)"imageUrl cannot be null");
            if (this.imageUrl == null) {
                this.imageUrl = new ArrayList<String>();
            }
            this.imageUrl.add(imageUrl);
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder imagesFile(List<FileWithMetadata> imagesFile) {
            this.imagesFile = imagesFile;
            return this;
        }

        public Builder imageUrl(List<String> imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder trainingData(String trainingData) {
            this.trainingData = trainingData;
            return this;
        }
    }
}

