/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.visual_recognition.v4;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.service.model.FileWithMetadata;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.visual_recognition.v4.model.AddImageTrainingDataOptions;
import com.ibm.watson.visual_recognition.v4.model.AddImagesOptions;
import com.ibm.watson.visual_recognition.v4.model.AnalyzeOptions;
import com.ibm.watson.visual_recognition.v4.model.AnalyzeResponse;
import com.ibm.watson.visual_recognition.v4.model.Collection;
import com.ibm.watson.visual_recognition.v4.model.CollectionsList;
import com.ibm.watson.visual_recognition.v4.model.CreateCollectionOptions;
import com.ibm.watson.visual_recognition.v4.model.DeleteCollectionOptions;
import com.ibm.watson.visual_recognition.v4.model.DeleteImageOptions;
import com.ibm.watson.visual_recognition.v4.model.DeleteObjectOptions;
import com.ibm.watson.visual_recognition.v4.model.DeleteUserDataOptions;
import com.ibm.watson.visual_recognition.v4.model.GetCollectionOptions;
import com.ibm.watson.visual_recognition.v4.model.GetImageDetailsOptions;
import com.ibm.watson.visual_recognition.v4.model.GetJpegImageOptions;
import com.ibm.watson.visual_recognition.v4.model.GetObjectMetadataOptions;
import com.ibm.watson.visual_recognition.v4.model.GetTrainingUsageOptions;
import com.ibm.watson.visual_recognition.v4.model.ImageDetails;
import com.ibm.watson.visual_recognition.v4.model.ImageDetailsList;
import com.ibm.watson.visual_recognition.v4.model.ImageSummaryList;
import com.ibm.watson.visual_recognition.v4.model.ListCollectionsOptions;
import com.ibm.watson.visual_recognition.v4.model.ListImagesOptions;
import com.ibm.watson.visual_recognition.v4.model.ListObjectMetadataOptions;
import com.ibm.watson.visual_recognition.v4.model.ObjectMetadata;
import com.ibm.watson.visual_recognition.v4.model.ObjectMetadataList;
import com.ibm.watson.visual_recognition.v4.model.TrainOptions;
import com.ibm.watson.visual_recognition.v4.model.TrainingDataObjects;
import com.ibm.watson.visual_recognition.v4.model.TrainingEvents;
import com.ibm.watson.visual_recognition.v4.model.UpdateCollectionOptions;
import com.ibm.watson.visual_recognition.v4.model.UpdateObjectMetadata;
import com.ibm.watson.visual_recognition.v4.model.UpdateObjectMetadataOptions;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class VisualRecognition
extends BaseService {
    private static final String DEFAULT_SERVICE_NAME = "visual_recognition";
    private static final String DEFAULT_SERVICE_URL = "https://gateway.watsonplatform.net/visual-recognition/api";
    private String versionDate;

    public VisualRecognition(String versionDate) {
        this(versionDate, DEFAULT_SERVICE_NAME, ConfigBasedAuthenticatorFactory.getAuthenticator((String)DEFAULT_SERVICE_NAME));
    }

    public VisualRecognition(String versionDate, Authenticator authenticator) {
        this(versionDate, DEFAULT_SERVICE_NAME, authenticator);
    }

    public VisualRecognition(String versionDate, String serviceName) {
        this(versionDate, serviceName, ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName));
    }

    public VisualRecognition(String versionDate, String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        Validator.isTrue((versionDate != null && !versionDate.isEmpty() ? 1 : 0) != 0, (String)"version cannot be null.");
        this.versionDate = versionDate;
        this.configureService(serviceName);
    }

    public ServiceCall<AnalyzeResponse> analyze(AnalyzeOptions analyzeOptions) {
        Validator.notNull((Object)((Object)analyzeOptions), (String)"analyzeOptions cannot be null");
        String[] pathSegments = new String[]{"v4/analyze"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"analyze");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        multipartBuilder.addFormDataPart("collection_ids", RequestUtils.join(analyzeOptions.collectionIds(), (String)","));
        multipartBuilder.addFormDataPart("features", RequestUtils.join(analyzeOptions.features(), (String)","));
        if (analyzeOptions.imagesFile() != null) {
            for (FileWithMetadata fileWithMetadata : analyzeOptions.imagesFile()) {
                RequestBody itemBody = RequestUtils.inputStreamBody((InputStream)fileWithMetadata.data(), (String)fileWithMetadata.contentType());
                multipartBuilder.addFormDataPart("images_file", fileWithMetadata.filename(), itemBody);
            }
        }
        if (analyzeOptions.imageUrl() != null) {
            for (String string : analyzeOptions.imageUrl()) {
                multipartBuilder.addFormDataPart("image_url", string);
            }
        }
        if (analyzeOptions.threshold() != null) {
            multipartBuilder.addFormDataPart("threshold", String.valueOf(analyzeOptions.threshold()));
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AnalyzeResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Collection> createCollection(CreateCollectionOptions createCollectionOptions) {
        Validator.notNull((Object)((Object)createCollectionOptions), (String)"createCollectionOptions cannot be null");
        String[] pathSegments = new String[]{"v4/collections"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"createCollection");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (createCollectionOptions != null) {
            if (createCollectionOptions.name() != null) {
                contentJson.addProperty("name", createCollectionOptions.name());
            }
            if (createCollectionOptions.description() != null) {
                contentJson.addProperty("description", createCollectionOptions.description());
            }
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Collection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Collection> createCollection() {
        return this.createCollection(null);
    }

    public ServiceCall<CollectionsList> listCollections(ListCollectionsOptions listCollectionsOptions) {
        String[] pathSegments = new String[]{"v4/collections"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"listCollections");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listCollectionsOptions != null) {
            // empty if block
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CollectionsList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CollectionsList> listCollections() {
        return this.listCollections(null);
    }

    public ServiceCall<Collection> getCollection(GetCollectionOptions getCollectionOptions) {
        Validator.notNull((Object)((Object)getCollectionOptions), (String)"getCollectionOptions cannot be null");
        String[] pathSegments = new String[]{"v4/collections"};
        String[] pathParameters = new String[]{getCollectionOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"getCollection");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Collection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Collection> updateCollection(UpdateCollectionOptions updateCollectionOptions) {
        Validator.notNull((Object)((Object)updateCollectionOptions), (String)"updateCollectionOptions cannot be null");
        String[] pathSegments = new String[]{"v4/collections"};
        String[] pathParameters = new String[]{updateCollectionOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"updateCollection");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (updateCollectionOptions.name() != null) {
            contentJson.addProperty("name", updateCollectionOptions.name());
        }
        if (updateCollectionOptions.description() != null) {
            contentJson.addProperty("description", updateCollectionOptions.description());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Collection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteCollection(DeleteCollectionOptions deleteCollectionOptions) {
        Validator.notNull((Object)((Object)deleteCollectionOptions), (String)"deleteCollectionOptions cannot be null");
        String[] pathSegments = new String[]{"v4/collections"};
        String[] pathParameters = new String[]{deleteCollectionOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"deleteCollection");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ImageDetailsList> addImages(AddImagesOptions addImagesOptions) {
        Validator.notNull((Object)((Object)addImagesOptions), (String)"addImagesOptions cannot be null");
        Validator.isTrue((addImagesOptions.imagesFile() != null || addImagesOptions.imageUrl() != null || addImagesOptions.trainingData() != null ? 1 : 0) != 0, (String)"At least one of imagesFile, imageUrl, or trainingData must be supplied.");
        String[] pathSegments = new String[]{"v4/collections", "images"};
        String[] pathParameters = new String[]{addImagesOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"addImages");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (addImagesOptions.imagesFile() != null) {
            for (FileWithMetadata fileWithMetadata : addImagesOptions.imagesFile()) {
                RequestBody itemBody = RequestUtils.inputStreamBody((InputStream)fileWithMetadata.data(), (String)fileWithMetadata.contentType());
                multipartBuilder.addFormDataPart("images_file", fileWithMetadata.filename(), itemBody);
            }
        }
        if (addImagesOptions.imageUrl() != null) {
            for (String string : addImagesOptions.imageUrl()) {
                multipartBuilder.addFormDataPart("image_url", string);
            }
        }
        if (addImagesOptions.trainingData() != null) {
            multipartBuilder.addFormDataPart("training_data", addImagesOptions.trainingData());
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ImageDetailsList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ImageSummaryList> listImages(ListImagesOptions listImagesOptions) {
        Validator.notNull((Object)((Object)listImagesOptions), (String)"listImagesOptions cannot be null");
        String[] pathSegments = new String[]{"v4/collections", "images"};
        String[] pathParameters = new String[]{listImagesOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"listImages");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ImageSummaryList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ImageDetails> getImageDetails(GetImageDetailsOptions getImageDetailsOptions) {
        Validator.notNull((Object)((Object)getImageDetailsOptions), (String)"getImageDetailsOptions cannot be null");
        String[] pathSegments = new String[]{"v4/collections", "images"};
        String[] pathParameters = new String[]{getImageDetailsOptions.collectionId(), getImageDetailsOptions.imageId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"getImageDetails");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ImageDetails>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteImage(DeleteImageOptions deleteImageOptions) {
        Validator.notNull((Object)((Object)deleteImageOptions), (String)"deleteImageOptions cannot be null");
        String[] pathSegments = new String[]{"v4/collections", "images"};
        String[] pathParameters = new String[]{deleteImageOptions.collectionId(), deleteImageOptions.imageId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"deleteImage");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> getJpegImage(GetJpegImageOptions getJpegImageOptions) {
        Validator.notNull((Object)((Object)getJpegImageOptions), (String)"getJpegImageOptions cannot be null");
        String[] pathSegments = new String[]{"v4/collections", "images", "jpeg"};
        String[] pathParameters = new String[]{getJpegImageOptions.collectionId(), getJpegImageOptions.imageId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"getJpegImage");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "image/jpeg"});
        if (getJpegImageOptions.size() != null) {
            builder.query(new Object[]{"size", getJpegImageOptions.size()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ObjectMetadataList> listObjectMetadata(ListObjectMetadataOptions listObjectMetadataOptions) {
        Validator.notNull((Object)((Object)listObjectMetadataOptions), (String)"listObjectMetadataOptions cannot be null");
        String[] pathSegments = new String[]{"v4/collections", "objects"};
        String[] pathParameters = new String[]{listObjectMetadataOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"listObjectMetadata");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ObjectMetadataList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<UpdateObjectMetadata> updateObjectMetadata(UpdateObjectMetadataOptions updateObjectMetadataOptions) {
        Validator.notNull((Object)((Object)updateObjectMetadataOptions), (String)"updateObjectMetadataOptions cannot be null");
        String[] pathSegments = new String[]{"v4/collections", "objects"};
        String[] pathParameters = new String[]{updateObjectMetadataOptions.collectionId(), updateObjectMetadataOptions.object()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"updateObjectMetadata");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("object", updateObjectMetadataOptions.newObject());
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<UpdateObjectMetadata>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ObjectMetadata> getObjectMetadata(GetObjectMetadataOptions getObjectMetadataOptions) {
        Validator.notNull((Object)((Object)getObjectMetadataOptions), (String)"getObjectMetadataOptions cannot be null");
        String[] pathSegments = new String[]{"v4/collections", "objects"};
        String[] pathParameters = new String[]{getObjectMetadataOptions.collectionId(), getObjectMetadataOptions.object()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"getObjectMetadata");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ObjectMetadata>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteObject(DeleteObjectOptions deleteObjectOptions) {
        Validator.notNull((Object)((Object)deleteObjectOptions), (String)"deleteObjectOptions cannot be null");
        String[] pathSegments = new String[]{"v4/collections", "objects"};
        String[] pathParameters = new String[]{deleteObjectOptions.collectionId(), deleteObjectOptions.object()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"deleteObject");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Collection> train(TrainOptions trainOptions) {
        Validator.notNull((Object)((Object)trainOptions), (String)"trainOptions cannot be null");
        String[] pathSegments = new String[]{"v4/collections", "train"};
        String[] pathParameters = new String[]{trainOptions.collectionId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"train");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Collection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TrainingDataObjects> addImageTrainingData(AddImageTrainingDataOptions addImageTrainingDataOptions) {
        Validator.notNull((Object)((Object)addImageTrainingDataOptions), (String)"addImageTrainingDataOptions cannot be null");
        String[] pathSegments = new String[]{"v4/collections", "images", "training_data"};
        String[] pathParameters = new String[]{addImageTrainingDataOptions.collectionId(), addImageTrainingDataOptions.imageId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"addImageTrainingData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (addImageTrainingDataOptions.objects() != null) {
            contentJson.add("objects", GsonSingleton.getGson().toJsonTree(addImageTrainingDataOptions.objects()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TrainingDataObjects>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TrainingEvents> getTrainingUsage(GetTrainingUsageOptions getTrainingUsageOptions) {
        String[] pathSegments = new String[]{"v4/training_usage"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"getTrainingUsage");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getTrainingUsageOptions != null) {
            if (getTrainingUsageOptions.startTime() != null) {
                builder.query(new Object[]{"start_time", getTrainingUsageOptions.startTime()});
            }
            if (getTrainingUsageOptions.endTime() != null) {
                builder.query(new Object[]{"end_time", getTrainingUsageOptions.endTime()});
            }
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TrainingEvents>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TrainingEvents> getTrainingUsage() {
        return this.getTrainingUsage(null);
    }

    public ServiceCall<Void> deleteUserData(DeleteUserDataOptions deleteUserDataOptions) {
        Validator.notNull((Object)((Object)deleteUserDataOptions), (String)"deleteUserDataOptions cannot be null");
        String[] pathSegments = new String[]{"v4/user_data"};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v4", (String)"deleteUserData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"customer_id", deleteUserDataOptions.customerId()});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

