/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.visual_recognition.v3;

import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.visual_recognition.v3.model.ClassifiedImages;
import com.ibm.watson.visual_recognition.v3.model.Classifier;
import com.ibm.watson.visual_recognition.v3.model.Classifiers;
import com.ibm.watson.visual_recognition.v3.model.ClassifyOptions;
import com.ibm.watson.visual_recognition.v3.model.CreateClassifierOptions;
import com.ibm.watson.visual_recognition.v3.model.DeleteClassifierOptions;
import com.ibm.watson.visual_recognition.v3.model.DeleteUserDataOptions;
import com.ibm.watson.visual_recognition.v3.model.GetClassifierOptions;
import com.ibm.watson.visual_recognition.v3.model.GetCoreMlModelOptions;
import com.ibm.watson.visual_recognition.v3.model.ListClassifiersOptions;
import com.ibm.watson.visual_recognition.v3.model.UpdateClassifierOptions;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

@Deprecated
public class VisualRecognition
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "visual_recognition";
    public static final String DEFAULT_SERVICE_URL = "https://api.us-south.visual-recognition.watson.cloud.ibm.com";
    private String version;

    public VisualRecognition(String version) {
        this(version, DEFAULT_SERVICE_NAME, ConfigBasedAuthenticatorFactory.getAuthenticator((String)DEFAULT_SERVICE_NAME));
    }

    public VisualRecognition(String version, Authenticator authenticator) {
        this(version, DEFAULT_SERVICE_NAME, authenticator);
    }

    public VisualRecognition(String version, String serviceName) {
        this(version, serviceName, ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName));
    }

    public VisualRecognition(String version, String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        this.setVersion(version);
        this.configureService(serviceName);
        System.err.println("On 1 December 2021, Visual Recognition will no longer be available. For more information, see Visual\nRecognition Deprecation (https://github.com/watson-developer-cloud/java-sdk/tree/master#visual-recognition-deprecation).");
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        Validator.notEmpty((String)version, (String)"version cannot be empty.");
        this.version = version;
    }

    public ServiceCall<ClassifiedImages> classify(ClassifyOptions classifyOptions) {
        Validator.notNull((Object)((Object)classifyOptions), (String)"classifyOptions cannot be null");
        Validator.isTrue((classifyOptions.imagesFile() != null || classifyOptions.url() != null || classifyOptions.threshold() != null || classifyOptions.owners() != null || classifyOptions.classifierIds() != null ? 1 : 0) != 0, (String)"At least one of imagesFile, url, threshold, owners, or classifierIds must be supplied.");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v3/classify"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"classify");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (classifyOptions.acceptLanguage() != null) {
            builder.header(new Object[]{"Accept-Language", classifyOptions.acceptLanguage()});
        }
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (classifyOptions.imagesFile() != null) {
            RequestBody imagesFileBody = RequestUtils.inputStreamBody((InputStream)classifyOptions.imagesFile(), (String)classifyOptions.imagesFileContentType());
            multipartBuilder.addFormDataPart("images_file", classifyOptions.imagesFilename(), imagesFileBody);
        }
        if (classifyOptions.url() != null) {
            multipartBuilder.addFormDataPart("url", classifyOptions.url());
        }
        if (classifyOptions.threshold() != null) {
            multipartBuilder.addFormDataPart("threshold", String.valueOf(classifyOptions.threshold()));
        }
        if (classifyOptions.owners() != null) {
            multipartBuilder.addFormDataPart("owners", RequestUtils.join(classifyOptions.owners(), (String)","));
        }
        if (classifyOptions.classifierIds() != null) {
            multipartBuilder.addFormDataPart("classifier_ids", RequestUtils.join(classifyOptions.classifierIds(), (String)","));
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ClassifiedImages>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ClassifiedImages> classify() {
        return this.classify(null);
    }

    /*
     * WARNING - void declaration
     */
    public ServiceCall<Classifier> createClassifier(CreateClassifierOptions createClassifierOptions) {
        Validator.notNull((Object)((Object)createClassifierOptions), (String)"createClassifierOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v3/classifiers"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"createClassifier");
        for (Map.Entry entry : sdkHeaders.entrySet()) {
            builder.header(new Object[]{entry.getKey(), entry.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        multipartBuilder.addFormDataPart("name", createClassifierOptions.name());
        for (Map.Entry<String, InputStream> entry : createClassifierOptions.positiveExamples().entrySet()) {
            String partName = String.format("%s_positive_examples", entry.getKey());
            RequestBody part = RequestUtils.inputStreamBody((InputStream)entry.getValue(), (String)"application/octet-stream");
            multipartBuilder.addFormDataPart(partName, entry.getKey() + ".zip", part);
        }
        if (createClassifierOptions.negativeExamples() != null) {
            void var6_13;
            RequestBody requestBody = RequestUtils.inputStreamBody((InputStream)createClassifierOptions.negativeExamples(), (String)"application/octet-stream");
            String string = createClassifierOptions.negativeExamplesFilename();
            if (!string.contains(".")) {
                String string2 = string + ".zip";
            }
            multipartBuilder.addFormDataPart("negative_examples", (String)var6_13, requestBody);
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Classifier>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Classifiers> listClassifiers(ListClassifiersOptions listClassifiersOptions) {
        if (listClassifiersOptions == null) {
            listClassifiersOptions = new ListClassifiersOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v3/classifiers"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"listClassifiers");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        if (listClassifiersOptions.verbose() != null) {
            builder.query(new Object[]{"verbose", String.valueOf(listClassifiersOptions.verbose())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Classifiers>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Classifiers> listClassifiers() {
        return this.listClassifiers(null);
    }

    public ServiceCall<Classifier> getClassifier(GetClassifierOptions getClassifierOptions) {
        Validator.notNull((Object)((Object)getClassifierOptions), (String)"getClassifierOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("classifier_id", getClassifierOptions.classifierId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v3/classifiers/{classifier_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"getClassifier");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Classifier>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Classifier> updateClassifier(UpdateClassifierOptions updateClassifierOptions) {
        Validator.notNull((Object)((Object)updateClassifierOptions), (String)"updateClassifierOptions cannot be null");
        Validator.isTrue((updateClassifierOptions.positiveExamples() != null || updateClassifierOptions.negativeExamples() != null ? 1 : 0) != 0, (String)"At least one of positiveExamples or negativeExamples must be supplied.");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("classifier_id", updateClassifierOptions.classifierId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v3/classifiers/{classifier_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"updateClassifier");
        for (Map.Entry entry : sdkHeaders.entrySet()) {
            builder.header(new Object[]{entry.getKey(), entry.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (updateClassifierOptions.positiveExamples() != null) {
            for (Map.Entry<String, InputStream> entry : updateClassifierOptions.positiveExamples().entrySet()) {
                String partName = String.format("%s_positive_examples", entry.getKey());
                RequestBody part = RequestUtils.inputStreamBody((InputStream)entry.getValue(), (String)"application/octet-stream");
                multipartBuilder.addFormDataPart(partName, entry.getKey(), part);
            }
        }
        if (updateClassifierOptions.negativeExamples() != null) {
            RequestBody requestBody = RequestUtils.inputStreamBody((InputStream)updateClassifierOptions.negativeExamples(), (String)"application/octet-stream");
            multipartBuilder.addFormDataPart("negative_examples", updateClassifierOptions.negativeExamplesFilename(), requestBody);
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Classifier>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteClassifier(DeleteClassifierOptions deleteClassifierOptions) {
        Validator.notNull((Object)((Object)deleteClassifierOptions), (String)"deleteClassifierOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("classifier_id", deleteClassifierOptions.classifierId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v3/classifiers/{classifier_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"deleteClassifier");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> getCoreMlModel(GetCoreMlModelOptions getCoreMlModelOptions) {
        Validator.notNull((Object)((Object)getCoreMlModelOptions), (String)"getCoreMlModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("classifier_id", getCoreMlModelOptions.classifierId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v3/classifiers/{classifier_id}/core_ml_model", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"getCoreMlModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/octet-stream"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteUserData(DeleteUserDataOptions deleteUserDataOptions) {
        Validator.notNull((Object)((Object)deleteUserDataOptions), (String)"deleteUserDataOptions cannot be null");
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v3/user_data"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"watson_vision_combined", (String)"v3", (String)"deleteUserData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        builder.query(new Object[]{"customer_id", String.valueOf(deleteUserDataOptions.customerId())});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

