/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.visual_recognition.v3.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class UpdateClassifierOptions
extends GenericModel {
    protected String classifierId;
    protected Map<String, InputStream> positiveExamples;
    protected InputStream negativeExamples;
    protected String negativeExamplesFilename;

    protected UpdateClassifierOptions(Builder builder) {
        Validator.notEmpty((String)builder.classifierId, (String)"classifierId cannot be empty");
        Validator.isTrue((builder.negativeExamples == null || builder.negativeExamplesFilename != null ? 1 : 0) != 0, (String)"negativeExamplesFilename cannot be null if negativeExamples is not null.");
        this.classifierId = builder.classifierId;
        this.positiveExamples = builder.positiveExamples;
        this.negativeExamples = builder.negativeExamples;
        this.negativeExamplesFilename = builder.negativeExamplesFilename;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String classifierId() {
        return this.classifierId;
    }

    public Map<String, InputStream> positiveExamples() {
        return this.positiveExamples;
    }

    public InputStream negativeExamples() {
        return this.negativeExamples;
    }

    public String negativeExamplesFilename() {
        return this.negativeExamplesFilename;
    }

    public static class Builder {
        private String classifierId;
        private Map<String, InputStream> positiveExamples;
        private InputStream negativeExamples;
        private String negativeExamplesFilename;

        private Builder(UpdateClassifierOptions updateClassifierOptions) {
            this.classifierId = updateClassifierOptions.classifierId;
            this.positiveExamples = updateClassifierOptions.positiveExamples;
            this.negativeExamples = updateClassifierOptions.negativeExamples;
            this.negativeExamplesFilename = updateClassifierOptions.negativeExamplesFilename;
        }

        public Builder() {
        }

        public Builder(String classifierId) {
            this.classifierId = classifierId;
        }

        public UpdateClassifierOptions build() {
            return new UpdateClassifierOptions(this);
        }

        public Builder addPositiveExamples(String classname, InputStream positiveExamples) {
            Validator.notNull((Object)classname, (String)"classname cannot be null");
            Validator.notNull((Object)positiveExamples, (String)"positiveExamples cannot be null");
            if (this.positiveExamples == null) {
                this.positiveExamples = new HashMap<String, InputStream>();
            }
            this.positiveExamples.put(classname, positiveExamples);
            return this;
        }

        public Builder classifierId(String classifierId) {
            this.classifierId = classifierId;
            return this;
        }

        public Builder positiveExamples(Map<String, InputStream> positiveExamples) {
            this.positiveExamples = positiveExamples;
            return this;
        }

        public Builder negativeExamples(InputStream negativeExamples) {
            this.negativeExamples = negativeExamples;
            return this;
        }

        public Builder negativeExamplesFilename(String negativeExamplesFilename) {
            this.negativeExamplesFilename = negativeExamplesFilename;
            return this;
        }

        public Builder addPositiveExamples(String classname, File positiveExamples) throws FileNotFoundException {
            this.addPositiveExamples(classname, new FileInputStream(positiveExamples));
            return this;
        }

        public Builder negativeExamples(File negativeExamples) throws FileNotFoundException {
            this.negativeExamples = new FileInputStream(negativeExamples);
            this.negativeExamplesFilename = negativeExamples.getName();
            return this;
        }
    }
}

