/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.visual_recognition.v4.model;

import com.ibm.cloud.sdk.core.service.model.FileWithMetadata;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class AnalyzeOptions
extends GenericModel {
    protected List<String> collectionIds;
    protected List<String> features;
    protected List<FileWithMetadata> imagesFile;
    protected List<String> imageUrl;
    protected Float threshold;

    protected AnalyzeOptions(Builder builder) {
        Validator.notNull((Object)builder.collectionIds, (String)"collectionIds cannot be null");
        Validator.notNull((Object)builder.features, (String)"features cannot be null");
        this.collectionIds = builder.collectionIds;
        this.features = builder.features;
        this.imagesFile = builder.imagesFile;
        this.imageUrl = builder.imageUrl;
        this.threshold = builder.threshold;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<String> collectionIds() {
        return this.collectionIds;
    }

    public List<String> features() {
        return this.features;
    }

    public List<FileWithMetadata> imagesFile() {
        return this.imagesFile;
    }

    public List<String> imageUrl() {
        return this.imageUrl;
    }

    public Float threshold() {
        return this.threshold;
    }

    public static class Builder {
        private List<String> collectionIds;
        private List<String> features;
        private List<FileWithMetadata> imagesFile;
        private List<String> imageUrl;
        private Float threshold;

        private Builder(AnalyzeOptions analyzeOptions) {
            this.collectionIds = analyzeOptions.collectionIds;
            this.features = analyzeOptions.features;
            this.imagesFile = analyzeOptions.imagesFile;
            this.imageUrl = analyzeOptions.imageUrl;
            this.threshold = analyzeOptions.threshold;
        }

        public Builder() {
        }

        public Builder(List<String> collectionIds, List<String> features) {
            this.collectionIds = collectionIds;
            this.features = features;
        }

        public AnalyzeOptions build() {
            return new AnalyzeOptions(this);
        }

        public Builder addCollectionIds(String collectionIds) {
            Validator.notNull((Object)collectionIds, (String)"collectionIds cannot be null");
            if (this.collectionIds == null) {
                this.collectionIds = new ArrayList<String>();
            }
            this.collectionIds.add(collectionIds);
            return this;
        }

        public Builder addFeatures(String features) {
            Validator.notNull((Object)features, (String)"features cannot be null");
            if (this.features == null) {
                this.features = new ArrayList<String>();
            }
            this.features.add(features);
            return this;
        }

        public Builder addImagesFile(FileWithMetadata imagesFile) {
            Validator.notNull((Object)imagesFile, (String)"imagesFile cannot be null");
            if (this.imagesFile == null) {
                this.imagesFile = new ArrayList<FileWithMetadata>();
            }
            this.imagesFile.add(imagesFile);
            return this;
        }

        public Builder addImageUrl(String imageUrl) {
            Validator.notNull((Object)imageUrl, (String)"imageUrl cannot be null");
            if (this.imageUrl == null) {
                this.imageUrl = new ArrayList<String>();
            }
            this.imageUrl.add(imageUrl);
            return this;
        }

        public Builder collectionIds(List<String> collectionIds) {
            this.collectionIds = collectionIds;
            return this;
        }

        public Builder features(List<String> features) {
            this.features = features;
            return this;
        }

        public Builder imagesFile(List<FileWithMetadata> imagesFile) {
            this.imagesFile = imagesFile;
            return this;
        }

        public Builder imageUrl(List<String> imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder threshold(Float threshold) {
            this.threshold = threshold;
            return this;
        }
    }

    public static interface Features {
        public static final String OBJECTS = "objects";
    }
}

