/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.visual_recognition.v4.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class Location
extends GenericModel {
    protected Long top;
    protected Long left;
    protected Long width;
    protected Long height;

    protected Location(Builder builder) {
        Validator.notNull((Object)builder.top, (String)"top cannot be null");
        Validator.notNull((Object)builder.left, (String)"left cannot be null");
        Validator.notNull((Object)builder.width, (String)"width cannot be null");
        Validator.notNull((Object)builder.height, (String)"height cannot be null");
        this.top = builder.top;
        this.left = builder.left;
        this.width = builder.width;
        this.height = builder.height;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Long top() {
        return this.top;
    }

    public Long left() {
        return this.left;
    }

    public Long width() {
        return this.width;
    }

    public Long height() {
        return this.height;
    }

    public static class Builder {
        private Long top;
        private Long left;
        private Long width;
        private Long height;

        private Builder(Location location) {
            this.top = location.top;
            this.left = location.left;
            this.width = location.width;
            this.height = location.height;
        }

        public Builder() {
        }

        public Builder(Long top, Long left, Long width, Long height) {
            this.top = top;
            this.left = left;
            this.width = width;
            this.height = height;
        }

        public Location build() {
            return new Location(this);
        }

        public Builder top(long top) {
            this.top = top;
            return this;
        }

        public Builder left(long left) {
            this.left = left;
            return this;
        }

        public Builder width(long width) {
            this.width = width;
            return this;
        }

        public Builder height(long height) {
            this.height = height;
            return this;
        }
    }
}

