/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.visual_recognition.v4.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class GetModelFileOptions
extends GenericModel {
    protected String collectionId;
    protected String feature;
    protected String modelFormat;

    protected GetModelFileOptions(Builder builder) {
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        Validator.notNull((Object)builder.feature, (String)"feature cannot be null");
        Validator.notNull((Object)builder.modelFormat, (String)"modelFormat cannot be null");
        this.collectionId = builder.collectionId;
        this.feature = builder.feature;
        this.modelFormat = builder.modelFormat;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String feature() {
        return this.feature;
    }

    public String modelFormat() {
        return this.modelFormat;
    }

    public static class Builder {
        private String collectionId;
        private String feature;
        private String modelFormat;

        private Builder(GetModelFileOptions getModelFileOptions) {
            this.collectionId = getModelFileOptions.collectionId;
            this.feature = getModelFileOptions.feature;
            this.modelFormat = getModelFileOptions.modelFormat;
        }

        public Builder() {
        }

        public Builder(String collectionId, String feature, String modelFormat) {
            this.collectionId = collectionId;
            this.feature = feature;
            this.modelFormat = modelFormat;
        }

        public GetModelFileOptions build() {
            return new GetModelFileOptions(this);
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        public Builder modelFormat(String modelFormat) {
            this.modelFormat = modelFormat;
            return this;
        }
    }

    public static interface ModelFormat {
        public static final String RSCNN = "rscnn";
    }

    public static interface Feature {
        public static final String OBJECTS = "objects";
    }
}

