/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.chat.ChatHandler;
import com.ibm.watsonx.ai.chat.ChatProvider;
import com.ibm.watsonx.ai.chat.ChatRequest;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.ChatRestClient;
import com.ibm.watsonx.ai.chat.model.AssistantMessage;
import com.ibm.watsonx.ai.chat.model.ChatMessage;
import com.ibm.watsonx.ai.chat.model.ChatParameters;
import com.ibm.watsonx.ai.chat.model.ControlMessage;
import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.TextChatRequest;
import com.ibm.watsonx.ai.chat.model.Thinking;
import com.ibm.watsonx.ai.chat.model.Tool;
import com.ibm.watsonx.ai.chat.model.UserMessage;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChatService
extends WatsonxService.ModelService
implements ChatProvider {
    public static final Logger logger = LoggerFactory.getLogger(ChatService.class);
    private final ChatRestClient client;

    private ChatService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.getAuthenticationProvider(), "authenticationProvider cannot be null");
        this.client = (ChatRestClient)((ChatRestClient.Builder)((ChatRestClient.Builder)((ChatRestClient.Builder)((ChatRestClient.Builder)((ChatRestClient.Builder)((ChatRestClient.Builder)ChatRestClient.builder().baseUrl(this.baseUrl)).version(this.version)).logRequests(this.logRequests)).logResponses(this.logResponses)).timeout(this.timeout)).authenticationProvider(builder.getAuthenticationProvider())).build();
    }

    @Override
    public ChatResponse chat(ChatRequest chatRequest) {
        AssistantMessage assistantMessage;
        Objects.requireNonNull(chatRequest, "chatRequest cannot be null");
        if (Objects.nonNull(chatRequest.getDeploymentId())) {
            logger.info("The deploymentId parameter can not be used with the ChatService. Use the DeploymentService instead");
        }
        List<ChatMessage> messages = chatRequest.getMessages();
        List<Tool> tools = Objects.nonNull(chatRequest.getTools()) && !chatRequest.getTools().isEmpty() ? chatRequest.getTools() : null;
        ChatParameters parameters = Objects.requireNonNullElse(chatRequest.getParameters(), ChatParameters.builder().build());
        if (messages.stream().anyMatch(ControlMessage.class::isInstance) && (Objects.isNull(chatRequest.getThinking()) || Objects.isNull(chatRequest.getThinking().getExtractionTags()))) {
            throw new IllegalArgumentException("Extraction tags are required when using control messages");
        }
        String modelId = Objects.requireNonNullElse(parameters.getModelId(), this.modelId);
        String projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
        String spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
        Long timeout = Objects.requireNonNullElse(parameters.getTimeLimit(), this.timeout.toMillis());
        Boolean includeReasoning = null;
        String thinkingEffort = null;
        ExtractionTags extractionTags = null;
        Map<String, Object> chatTemplateKwargs = null;
        if (Objects.nonNull(chatRequest.getThinking())) {
            Thinking thinking = chatRequest.getThinking();
            chatTemplateKwargs = Map.of("thinking", true);
            extractionTags = thinking.getExtractionTags();
            includeReasoning = thinking.getIncludeReasoning();
            thinkingEffort = Objects.nonNull((Object)thinking.getThinkingEffort()) ? thinking.getThinkingEffort().getValue() : null;
        }
        TextChatRequest textChatRequest = TextChatRequest.builder().modelId(modelId).projectId(projectId).spaceId(spaceId).messages(messages).tools(tools).parameters(parameters).timeLimit(timeout).includeReasoning(includeReasoning).reasoningEffort(thinkingEffort).chatTemplateKwargs(chatTemplateKwargs).build();
        ChatResponse chatResponse = this.client.chat(parameters.getTransactionId(), textChatRequest);
        if (Objects.nonNull(parameters.getToolChoiceOption()) && parameters.getToolChoiceOption().equals(ChatParameters.ToolChoiceOption.REQUIRED.type()) && Objects.nonNull((assistantMessage = chatResponse.toAssistantMessage()).toolCalls()) && !assistantMessage.toolCalls().isEmpty()) {
            chatResponse.getChoices().get(0).setFinishReason("tool_calls");
        }
        chatResponse.setExtractionTags(extractionTags);
        return chatResponse;
    }

    @Override
    public CompletableFuture<Void> chatStreaming(ChatRequest chatRequest, ChatHandler handler) {
        Objects.requireNonNull(chatRequest, "chatRequest cannot be null");
        Objects.requireNonNull(handler, "The chatHandler parameter can not be null");
        if (Objects.nonNull(chatRequest.getDeploymentId())) {
            logger.info("The deploymentId parameter can not be used with the ChatService. Use the DeploymentService instead");
        }
        List<ChatMessage> messages = chatRequest.getMessages();
        List<Tool> tools = Objects.nonNull(chatRequest.getTools()) && !chatRequest.getTools().isEmpty() ? chatRequest.getTools() : null;
        ChatParameters parameters = Objects.requireNonNullElse(chatRequest.getParameters(), ChatParameters.builder().build());
        if (messages.stream().anyMatch(ControlMessage.class::isInstance) && (Objects.isNull(chatRequest.getThinking()) || Objects.isNull(chatRequest.getThinking().getExtractionTags()))) {
            throw new IllegalArgumentException("Extraction tags are required when using control messages");
        }
        String modelId = Objects.requireNonNullElse(parameters.getModelId(), this.modelId);
        String projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
        String spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
        Long timeout = Objects.requireNonNullElse(parameters.getTimeLimit(), this.timeout.toMillis());
        Boolean includeReasoning = null;
        String thinkingEffort = null;
        ExtractionTags extractionTags = null;
        Map<String, Object> chatTemplateKwargs = null;
        if (Objects.nonNull(chatRequest.getThinking())) {
            Thinking thinking = chatRequest.getThinking();
            chatTemplateKwargs = Map.of("thinking", true);
            extractionTags = thinking.getExtractionTags();
            includeReasoning = thinking.getIncludeReasoning();
            thinkingEffort = Objects.nonNull((Object)thinking.getThinkingEffort()) ? thinking.getThinkingEffort().getValue() : null;
        }
        TextChatRequest textChatRequest = TextChatRequest.builder().modelId(modelId).projectId(projectId).spaceId(spaceId).messages(messages).tools(tools).parameters(parameters).timeLimit(timeout).includeReasoning(includeReasoning).reasoningEffort(thinkingEffort).chatTemplateKwargs(chatTemplateKwargs).build();
        return this.client.chatStreaming(parameters.getTransactionId(), extractionTags, textChatRequest, handler);
    }

    public ChatResponse chat(String message) {
        return this.chat(UserMessage.text(message));
    }

    public ChatResponse chat(ChatMessage ... messages) {
        return this.chat(Arrays.asList(messages));
    }

    public ChatResponse chat(List<ChatMessage> messages) {
        return this.chat(messages, ChatParameters.builder().build());
    }

    public ChatResponse chat(List<ChatMessage> messages, Tool ... tools) {
        return this.chat(messages, Arrays.asList(tools));
    }

    public ChatResponse chat(List<ChatMessage> messages, List<Tool> tools) {
        return this.chat(messages, null, tools);
    }

    public ChatResponse chat(List<ChatMessage> messages, ChatParameters parameters) {
        return this.chat(messages, parameters, List.of());
    }

    public ChatResponse chat(List<ChatMessage> messages, ChatParameters parameters, Tool ... tools) {
        return this.chat(messages, parameters, Arrays.asList(tools));
    }

    public ChatResponse chat(List<ChatMessage> messages, ChatParameters parameters, List<Tool> tools) {
        return this.chat(ChatRequest.builder().messages(messages).parameters(parameters).tools(tools).build());
    }

    public CompletableFuture<Void> chatStreaming(String message, ChatHandler handler) {
        return this.chatStreaming(List.of(UserMessage.text(message)), handler);
    }

    public CompletableFuture<Void> chatStreaming(List<ChatMessage> messages, ChatHandler handler) {
        return this.chatStreaming(messages, ChatParameters.builder().build(), handler);
    }

    public CompletableFuture<Void> chatStreaming(List<ChatMessage> messages, List<Tool> tools, ChatHandler handler) {
        return this.chatStreaming(messages, ChatParameters.builder().build(), tools, handler);
    }

    public CompletableFuture<Void> chatStreaming(List<ChatMessage> messages, ChatParameters parameters, ChatHandler handler) {
        return this.chatStreaming(messages, parameters, null, handler);
    }

    public CompletableFuture<Void> chatStreaming(List<ChatMessage> messages, ChatParameters parameters, List<Tool> tools, ChatHandler handler) {
        ChatRequest chatRequest = ChatRequest.builder().messages(messages).parameters(parameters).tools(tools).build();
        return this.chatStreaming(chatRequest, handler);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxService.ModelService.Builder<Builder> {
        private Builder() {
        }

        public ChatService build() {
            return new ChatService(this);
        }
    }
}

