/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.ThinkingEffort;

public class Thinking {
    private final Boolean includeReasoning;
    private final ExtractionTags extractionTags;
    private final ThinkingEffort thinkingEffort;

    private Thinking(Builder builder) {
        this.includeReasoning = builder.includeReasoning;
        this.extractionTags = builder.extractionTags;
        this.thinkingEffort = builder.thinkingEffort;
    }

    public Boolean getIncludeReasoning() {
        return this.includeReasoning;
    }

    public ExtractionTags getExtractionTags() {
        return this.extractionTags;
    }

    public ThinkingEffort getThinkingEffort() {
        return this.thinkingEffort;
    }

    public static Thinking of(ExtractionTags extractionTags) {
        return Thinking.builder().extractionTags(extractionTags).build();
    }

    public static Thinking of(ThinkingEffort thinkingEffort) {
        return Thinking.builder().thinkingEffort(thinkingEffort).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Boolean includeReasoning;
        private ExtractionTags extractionTags;
        private ThinkingEffort thinkingEffort;

        private Builder() {
        }

        public Builder includeReasoning(Boolean includeReasoning) {
            this.includeReasoning = includeReasoning;
            return this;
        }

        public Builder extractionTags(ExtractionTags extractionTags) {
            this.extractionTags = extractionTags;
            return this;
        }

        public Builder thinkingEffort(ThinkingEffort thinkingEffort) {
            this.thinkingEffort = thinkingEffort;
            return this;
        }

        public Thinking build() {
            return new Thinking(this);
        }
    }
}

