/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import com.ibm.watsonx.ai.chat.model.ChatMessage;
import com.ibm.watsonx.ai.chat.model.TextContent;
import com.ibm.watsonx.ai.chat.model.UserContent;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public record UserMessage(String role, List<UserContent> content, String name) implements ChatMessage
{
    public static final String ROLE = "user";

    public UserMessage {
        role = ROLE;
        Objects.requireNonNull(content);
    }

    public static UserMessage of(String name, List<UserContent> contents) {
        return new UserMessage(ROLE, contents, name);
    }

    public static UserMessage of(List<UserContent> contents) {
        return UserMessage.of(null, contents);
    }

    public static UserMessage of(UserContent ... contents) {
        return UserMessage.of(null, Arrays.asList(contents));
    }

    public static UserMessage text(String text) {
        TextContent content = TextContent.of(text);
        return UserMessage.of(null, List.of(content));
    }
}

