/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.deployment;

import com.ibm.watsonx.ai.chat.ChatHandler;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.ChatSubscriber;
import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.TextChatRequest;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.SseEventLogger;
import com.ibm.watsonx.ai.core.auth.AuthenticationProvider;
import com.ibm.watsonx.ai.core.factory.HttpClientFactory;
import com.ibm.watsonx.ai.core.http.AsyncHttpClient;
import com.ibm.watsonx.ai.core.http.SyncHttpClient;
import com.ibm.watsonx.ai.core.http.interceptors.LoggerInterceptor;
import com.ibm.watsonx.ai.deployment.DeploymentResource;
import com.ibm.watsonx.ai.deployment.DeploymentRestClient;
import com.ibm.watsonx.ai.deployment.FindByIdRequest;
import com.ibm.watsonx.ai.textgeneration.TextGenerationHandler;
import com.ibm.watsonx.ai.textgeneration.TextGenerationResponse;
import com.ibm.watsonx.ai.textgeneration.TextGenerationSubscriber;
import com.ibm.watsonx.ai.textgeneration.TextRequest;
import com.ibm.watsonx.ai.timeseries.ForecastRequest;
import com.ibm.watsonx.ai.timeseries.ForecastResponse;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;

final class DefaultRestClient
extends DeploymentRestClient {
    private final SyncHttpClient syncHttpClient;
    private final AsyncHttpClient asyncHttpClient;

    DefaultRestClient(Builder builder) {
        super(builder);
        Objects.requireNonNull(this.authenticationProvider, "authenticationProvider is mandatory");
        this.syncHttpClient = HttpClientFactory.createSync((AuthenticationProvider)this.authenticationProvider, (LoggerInterceptor.LogMode)LoggerInterceptor.LogMode.of((boolean)this.logRequests, (boolean)this.logResponses));
        this.asyncHttpClient = HttpClientFactory.createAsync((AuthenticationProvider)this.authenticationProvider, (LoggerInterceptor.LogMode)LoggerInterceptor.LogMode.of((boolean)this.logRequests, (boolean)this.logResponses));
    }

    @Override
    public DeploymentResource findById(FindByIdRequest parameters) {
        String deploymentId = parameters.getDeploymentId();
        StringJoiner queryParameters = new StringJoiner("&", "?", "");
        if (Objects.nonNull(parameters.getProjectId())) {
            queryParameters.add("project_id=".concat(parameters.getProjectId()));
        }
        if (Objects.nonNull(parameters.getSpaceId())) {
            queryParameters.add("space_id=".concat(parameters.getSpaceId()));
        }
        queryParameters.add("version=".concat(this.version));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.baseUrl + "/ml/v4/deployments/%s%s".formatted(deploymentId, queryParameters.toString()))).header("Content-Type", "application/json").timeout(Duration.ofMillis(this.timeout.toMillis())).GET();
        if (Objects.nonNull(parameters.getTransactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.getTransactionId());
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (DeploymentResource)Json.fromJson((String)((String)httpReponse.body()), DeploymentResource.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TextGenerationResponse generate(DeploymentRestClient.GenerateRequest generateRequest) {
        String deploymentId = generateRequest.deploymentId();
        Duration timeout = generateRequest.timeout();
        TextRequest textRequest = generateRequest.textRequest();
        String transactionId = generateRequest.transactionId();
        URI url = URI.create(this.baseUrl + "%s/deployments/%s/text/generation?version=%s".formatted("/ml/v1", deploymentId, this.version));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(url).header("Content-Type", "application/json").header("Accept", "application/json").timeout(timeout).POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textRequest)));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (TextGenerationResponse)Json.fromJson((String)((String)httpReponse.body()), TextGenerationResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<Void> generateStreaming(DeploymentRestClient.GenerateStreamingRequest request) {
        String deploymentId = request.deploymentId();
        String transactionId = request.transactionId();
        Duration timeout = request.timeout();
        TextRequest textRequest = request.textRequest();
        TextGenerationHandler handler = request.handler();
        URI url = URI.create(this.baseUrl + "%s/deployments/%s/text/generation_stream?version=%s".formatted("/ml/v1", deploymentId, this.version));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(url).header("Content-Type", "application/json").header("Accept", "text/event-stream").timeout(timeout).POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textRequest)));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        Flow.Subscriber<String> subscriber = this.textGenerationSubscriber(handler);
        return ((CompletableFuture)this.asyncHttpClient.send(httpRequest.build(), responseInfo -> this.logResponses ? HttpResponse.BodySubscribers.fromLineSubscriber((Flow.Subscriber<? super String>)new SseEventLogger(subscriber, responseInfo.statusCode(), responseInfo.headers())) : HttpResponse.BodySubscribers.fromLineSubscriber(subscriber)).thenAccept(r -> {})).exceptionally(t -> TextGenerationSubscriber.handleError(t, handler));
    }

    @Override
    public ChatResponse chat(DeploymentRestClient.ChatRequest request) {
        String deploymentId = request.deploymentId();
        Duration timeout = request.timeout();
        TextChatRequest textChatRequest = request.textChatRequest();
        String transactionId = request.transactionId();
        URI url = URI.create(this.baseUrl + "%s/deployments/%s/text/chat?version=%s".formatted("/ml/v1", deploymentId, this.version));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(url).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textChatRequest))).timeout(timeout);
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (ChatResponse)Json.fromJson((String)((String)httpReponse.body()), ChatResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<Void> chatStreaming(DeploymentRestClient.ChatStreamingRequest request) {
        String deploymentId = request.deploymentId();
        String transactionId = request.transactionId();
        Duration timeout = request.timeout();
        TextChatRequest textChatRequest = request.textChatRequest();
        ExtractionTags extractionTags = request.extractionTags();
        ChatHandler handler = request.handler();
        URI url = URI.create(this.baseUrl + "%s/deployments/%s/text/chat_stream?version=%s".formatted("/ml/v1", deploymentId, this.version));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(url).header("Content-Type", "application/json").header("Accept", "text/event-stream").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textChatRequest))).timeout(timeout);
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        Flow.Subscriber<String> subscriber = this.chatSubscriber(textChatRequest.getToolChoiceOption(), ChatSubscriber.toolHasParameters(textChatRequest.getTools()), extractionTags, handler);
        return ((CompletableFuture)this.asyncHttpClient.send(httpRequest.build(), responseInfo -> this.logResponses ? HttpResponse.BodySubscribers.fromLineSubscriber((Flow.Subscriber<? super String>)new SseEventLogger(subscriber, responseInfo.statusCode(), responseInfo.headers())) : HttpResponse.BodySubscribers.fromLineSubscriber(subscriber)).thenAccept(r -> {})).exceptionally(t -> ChatSubscriber.handleError(t, handler));
    }

    @Override
    public ForecastResponse forecast(DeploymentRestClient.ForecastRequest request) {
        String deploymentId = request.deploymentId();
        Duration timeout = request.timeout();
        ForecastRequest forecastRequest = request.forecastRequest();
        String transactionId = request.transactionId();
        URI url = URI.create(this.baseUrl + "%s/deployments/%s/time_series/forecast?version=%s".formatted("/ml/v1", deploymentId, this.version));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(url).header("Content-Type", "application/json").header("Accept", "application/json").timeout(timeout).POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)forecastRequest)));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (ForecastResponse)Json.fromJson((String)((String)httpReponse.body()), ForecastResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Flow.Subscriber<String> textGenerationSubscriber(final TextGenerationHandler handler) {
        return new Flow.Subscriber<String>(){
            private Flow.Subscription subscription;
            private volatile boolean success = true;
            private volatile TextGenerationSubscriber chatSubscriber = TextGenerationSubscriber.createSubscriber(handler);

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            @Override
            public void onNext(String partialMessage) {
                try {
                    this.chatSubscriber.onNext(partialMessage);
                }
                catch (RuntimeException e) {
                    this.onError(e);
                    this.success = !handler.failOnFirstError();
                }
                finally {
                    if (this.success) {
                        this.subscription.request(1L);
                    } else {
                        this.subscription.cancel();
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                this.chatSubscriber.onError(throwable);
            }

            @Override
            public void onComplete() {
                this.chatSubscriber.onComplete();
            }
        };
    }

    private Flow.Subscriber<String> chatSubscriber(final String toolChoiceOption, final Map<String, Boolean> toolHasParameters, final ExtractionTags extractionTags, final ChatHandler handler) {
        return new Flow.Subscriber<String>(){
            private Flow.Subscription subscription;
            private volatile boolean success = true;
            private volatile ChatSubscriber chatSubscriber = ChatSubscriber.createSubscriber(toolChoiceOption, toolHasParameters, extractionTags, handler);

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            @Override
            public void onNext(String partialMessage) {
                try {
                    this.chatSubscriber.onNext(partialMessage);
                }
                catch (RuntimeException e) {
                    this.onError(e);
                    this.success = !handler.failOnFirstError();
                }
                finally {
                    if (this.success) {
                        this.subscription.request(1L);
                    } else {
                        this.subscription.cancel();
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                this.chatSubscriber.onError(throwable);
            }

            @Override
            public void onComplete() {
                this.chatSubscriber.onComplete();
            }
        };
    }

    static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DeploymentRestClient.Builder {
        private Builder() {
        }

        @Override
        public DefaultRestClient build() {
            return new DefaultRestClient(this);
        }
    }
}

