/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.deployment;

import com.ibm.watsonx.ai.WatsonxRestClient;
import com.ibm.watsonx.ai.chat.ChatHandler;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.TextChatRequest;
import com.ibm.watsonx.ai.deployment.DefaultRestClient;
import com.ibm.watsonx.ai.deployment.DeploymentResource;
import com.ibm.watsonx.ai.deployment.FindByIdRequest;
import com.ibm.watsonx.ai.textgeneration.TextGenerationHandler;
import com.ibm.watsonx.ai.textgeneration.TextGenerationResponse;
import com.ibm.watsonx.ai.textgeneration.TextRequest;
import com.ibm.watsonx.ai.timeseries.ForecastResponse;
import java.time.Duration;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public abstract class DeploymentRestClient
extends WatsonxRestClient {
    protected DeploymentRestClient(Builder builder) {
        super(builder);
    }

    public abstract DeploymentResource findById(FindByIdRequest var1);

    public abstract TextGenerationResponse generate(GenerateRequest var1);

    public abstract CompletableFuture<Void> generateStreaming(GenerateStreamingRequest var1);

    public abstract ChatResponse chat(ChatRequest var1);

    public abstract CompletableFuture<Void> chatStreaming(ChatStreamingRequest var1);

    public abstract ForecastResponse forecast(ForecastRequest var1);

    static Builder builder() {
        return ServiceLoader.load(DeploymentRestClientBuilderFactory.class).findFirst().map(Supplier::get).orElse(DefaultRestClient.builder());
    }

    public static interface DeploymentRestClientBuilderFactory
    extends Supplier<Builder> {
    }

    public static abstract class Builder
    extends WatsonxRestClient.Builder<DeploymentRestClient, Builder> {
    }

    public record ForecastRequest(String transactionId, String deploymentId, Duration timeout, com.ibm.watsonx.ai.timeseries.ForecastRequest forecastRequest) {
    }

    public record ChatStreamingRequest(String transactionId, String deploymentId, Duration timeout, ExtractionTags extractionTags, TextChatRequest textChatRequest, ChatHandler handler) {
    }

    public record ChatRequest(String transactionId, String deploymentId, Duration timeout, TextChatRequest textChatRequest) {
    }

    public record GenerateStreamingRequest(String transactionId, String deploymentId, Duration timeout, TextRequest textRequest, TextGenerationHandler handler) {
    }

    public record GenerateRequest(String transactionId, String deploymentId, Duration timeout, TextRequest textRequest) {
    }
}

