/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.embedding;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.embedding.EmbeddingParameters;
import com.ibm.watsonx.ai.embedding.EmbeddingRequest;
import com.ibm.watsonx.ai.embedding.EmbeddingResponse;
import com.ibm.watsonx.ai.embedding.EmbeddingRestClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class EmbeddingService
extends WatsonxService.ModelService {
    private static final int MAX_SIZE = 1000;
    private final EmbeddingRestClient client;

    private EmbeddingService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.getAuthenticationProvider(), "authenticationProvider cannot be null");
        this.client = (EmbeddingRestClient)((EmbeddingRestClient.Builder)((EmbeddingRestClient.Builder)((EmbeddingRestClient.Builder)((EmbeddingRestClient.Builder)((EmbeddingRestClient.Builder)((EmbeddingRestClient.Builder)EmbeddingRestClient.builder().baseUrl(this.baseUrl)).version(this.version)).logRequests(this.logRequests)).logResponses(this.logResponses)).timeout(this.timeout)).authenticationProvider(builder.getAuthenticationProvider())).build();
    }

    public EmbeddingResponse embedding(String ... inputs) {
        return this.embedding(Arrays.asList(inputs));
    }

    public EmbeddingResponse embedding(List<String> inputs) {
        return this.embedding(inputs, null);
    }

    public EmbeddingResponse embedding(List<String> inputs, EmbeddingParameters parameters) {
        Objects.requireNonNull(inputs, "Inputs cannot be null");
        String modelId = this.modelId;
        String projectId = this.projectId;
        String spaceId = this.spaceId;
        String transactionId = null;
        EmbeddingRequest.Parameters requestParameters = null;
        if (Objects.nonNull(parameters)) {
            modelId = Objects.requireNonNullElse(parameters.getModelId(), this.modelId);
            projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
            spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
            transactionId = parameters.getTransactionId();
            requestParameters = parameters.toEmbeddingRequestParameters();
        }
        int inputTokenCount = 0;
        String createdAt = null;
        ArrayList<EmbeddingResponse.Result> results = new ArrayList<EmbeddingResponse.Result>();
        for (int fromIndex = 0; fromIndex < inputs.size(); fromIndex += 1000) {
            int toIndex = Math.min(fromIndex + 1000, inputs.size());
            List<String> subList = inputs.subList(fromIndex, toIndex);
            EmbeddingRequest embeddingRequest = new EmbeddingRequest(modelId, spaceId, projectId, subList, requestParameters);
            EmbeddingResponse response = this.client.embedding(transactionId, embeddingRequest);
            results.addAll(response.results());
            inputTokenCount += response.inputTokenCount().intValue();
            createdAt = response.createdAt();
        }
        return new EmbeddingResponse(modelId, createdAt, results, inputTokenCount);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxService.ModelService.Builder<Builder> {
        private Builder() {
        }

        public EmbeddingService build() {
            return new EmbeddingService(this);
        }
    }
}

