/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.foundationmodel;

import com.ibm.watsonx.ai.foundationmodel.filter.Filter;
import java.util.Objects;

public class FoundationModelParameters {
    private final Integer start;
    private final Integer limit;
    private final Filter filter;
    private final String transactionId;
    private final Boolean techPreview;

    protected FoundationModelParameters(Builder builder) {
        this.start = builder.start;
        this.limit = builder.limit;
        this.filter = builder.filter;
        this.transactionId = builder.transactionId;
        this.techPreview = builder.techPreview;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getFilter() {
        return Objects.nonNull(this.filter) ? this.filter.toString() : null;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Boolean getTechPreview() {
        return this.techPreview;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer start;
        private Integer limit;
        private Filter filter;
        private String transactionId;
        private Boolean techPreview;

        public Builder start(Integer start) {
            this.start = start;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder techPreview(Boolean techPreview) {
            this.techPreview = techPreview;
            return this;
        }

        public FoundationModelParameters build() {
            return new FoundationModelParameters(this);
        }
    }
}

