/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.foundationmodel.filter;

import com.ibm.watsonx.ai.foundationmodel.filter.FilterExpression;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public final class Filter {
    private final StringJoiner filterExpression;

    private Filter(String logicalOperator, List<FilterExpression> expressions) {
        this.filterExpression = new StringJoiner(",", "", logicalOperator);
        expressions.stream().map(FilterExpression::expression).forEach(this.filterExpression::add);
    }

    public static Filter and(FilterExpression ... expressions) {
        Objects.requireNonNull(expressions, "The expressions cannot be null");
        return new Filter(":and", List.of(expressions));
    }

    public static Filter or(FilterExpression ... expressions) {
        Objects.requireNonNull(expressions, "The expressions cannot be null");
        return new Filter(":or", List.of(expressions));
    }

    public static Filter of(FilterExpression ... expressions) {
        Objects.requireNonNull(expressions, "The expressions cannot be null");
        return new Filter("", List.of(expressions));
    }

    public String expression() {
        return this.toString();
    }

    public String toString() {
        return this.filterExpression.toString();
    }

    public static class Expression {
        private Expression() {
        }

        public static FilterExpression not(FilterExpression expression) {
            Objects.requireNonNull(expression, "The expression cannot be null");
            return () -> "!".concat(expression.expression());
        }

        public static FilterExpression modelId(String modelId) {
            Objects.requireNonNull(modelId, "The modelId cannot be null");
            if (modelId.isBlank()) {
                throw new IllegalArgumentException("The modelId cannot be blank");
            }
            return () -> "modelid_".concat(modelId);
        }

        public static FilterExpression provider(String provider) {
            Objects.requireNonNull(provider, "The provider cannot be null");
            if (provider.isBlank()) {
                throw new IllegalArgumentException("The provider cannot be blank");
            }
            return () -> "provider_".concat(provider);
        }

        public static FilterExpression source(String source) {
            Objects.requireNonNull(source, "The source cannot be null");
            if (source.isBlank()) {
                throw new IllegalArgumentException("The source cannot be blank");
            }
            return () -> "source_".concat(source);
        }

        public static FilterExpression inputTier(String inputTier) {
            Objects.requireNonNull(inputTier, "The inputTier cannot be null");
            if (inputTier.isBlank()) {
                throw new IllegalArgumentException("The inputTier cannot be blank");
            }
            return () -> "input_tier_".concat(inputTier);
        }

        public static FilterExpression tier(String tier) {
            Objects.requireNonNull(tier, "The tier cannot be null");
            if (tier.isBlank()) {
                throw new IllegalArgumentException("The tier cannot be blank");
            }
            return () -> "tier_".concat(tier);
        }

        public static FilterExpression task(String task) {
            Objects.requireNonNull(task, "The task cannot be null");
            if (task.isBlank()) {
                throw new IllegalArgumentException("The task cannot be blank");
            }
            return () -> "task_".concat(task);
        }

        public static FilterExpression lifecycle(String lifecycle) {
            Objects.requireNonNull(lifecycle, "The lifecycle cannot be null");
            if (lifecycle.isBlank()) {
                throw new IllegalArgumentException("The lifecycle cannot be blank");
            }
            return () -> "lifecycle_".concat(lifecycle);
        }

        public static FilterExpression function(String function) {
            Objects.requireNonNull(function, "The function cannot be null");
            if (function.isBlank()) {
                throw new IllegalArgumentException("The function cannot be blank");
            }
            return () -> "function_".concat(function);
        }
    }
}

