/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.rerank;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.rerank.RerankParameters;
import com.ibm.watsonx.ai.rerank.RerankRequest;
import com.ibm.watsonx.ai.rerank.RerankResponse;
import com.ibm.watsonx.ai.rerank.RerankRestClient;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class RerankService
extends WatsonxService.ModelService {
    private final RerankRestClient client;

    private RerankService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.getAuthenticationProvider(), "authenticationProvider cannot be null");
        this.client = (RerankRestClient)((RerankRestClient.Builder)((RerankRestClient.Builder)((RerankRestClient.Builder)((RerankRestClient.Builder)((RerankRestClient.Builder)((RerankRestClient.Builder)RerankRestClient.builder().baseUrl(this.baseUrl)).version(this.version)).logRequests(this.logRequests)).logResponses(this.logResponses)).timeout(this.timeout)).authenticationProvider(builder.getAuthenticationProvider())).build();
    }

    public RerankResponse rerank(String query, List<String> inputs) {
        return this.rerank(query, inputs, null);
    }

    public RerankResponse rerank(String query, List<String> inputs, RerankParameters parameters) {
        Objects.requireNonNull(query, "Query cannot be null");
        Objects.requireNonNull(inputs, "Inputs cannot be null");
        String modelId = this.modelId;
        String projectId = this.projectId;
        String spaceId = this.spaceId;
        String transactionId = null;
        RerankRequest.Parameters requestParameters = null;
        if (Objects.nonNull(parameters)) {
            modelId = Objects.requireNonNullElse(parameters.getModelId(), this.modelId);
            projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
            spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
            transactionId = parameters.getTransactionId();
            requestParameters = parameters.toRerankRequestParameters();
        }
        RerankRequest rerankRequest = new RerankRequest(modelId, inputs.stream().map(RerankRequest.RerankInput::new).toList(), query, spaceId, projectId, requestParameters);
        return this.client.rerank(transactionId, rerankRequest);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxService.ModelService.Builder<Builder> {
        private Builder() {
        }

        public RerankService build() {
            return new RerankService(this);
        }
    }
}

