/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textextraction;

import java.util.List;
import java.util.Map;
import java.util.Objects;

public record TextExtractionRequest(String projectId, String spaceId, DataReference documentReference, DataReference resultsReference, Parameters parameters, Map<String, Object> custom) {

    public record DataReference(String type, CosDataConnection connection, CosDataLocation location) {
        public static final String TYPE_CONNECTION_ASSET = "connection_asset";

        public DataReference(String type, CosDataConnection connection, CosDataLocation location) {
            this.type = type = TYPE_CONNECTION_ASSET;
            this.connection = connection;
            this.location = location;
        }
    }

    public record Parameters(List<String> requestedOutputs, String mode, String ocrMode, List<String> languages, Boolean autoRotationCorrection, String createEmbeddedImages, Integer outputDpi, Boolean outputTokens, String kvpMode, SemanticConfig semanticConfig) {
        public static Parameters of(List<String> requestedOutputs) {
            return new Parameters(requestedOutputs, null, null, null, null, null, null, null, null, null);
        }
    }

    public static class Schema {
        private final String documentType;
        private final String documentDescription;
        private final Integer targetImageWidth;
        private final Boolean enableTextHints;
        private final Boolean enableGenericKvp;
        private final KvpField fields;

        public Schema(Builder builder) {
            this.documentType = builder.documentType;
            this.documentDescription = builder.documentDescription;
            this.targetImageWidth = builder.targetImageWidth;
            this.enableTextHints = builder.enableTextHints;
            this.enableGenericKvp = builder.enableGenericKvp;
            this.fields = builder.fields;
        }

        public String getDocumentType() {
            return this.documentType;
        }

        public String getDocumentDescription() {
            return this.documentDescription;
        }

        public Integer getTargetImageWidth() {
            return this.targetImageWidth;
        }

        public Boolean getEnableTextHints() {
            return this.enableTextHints;
        }

        public Boolean getEnableGenericKvp() {
            return this.enableGenericKvp;
        }

        public KvpField getFields() {
            return this.fields;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String documentType;
            private String documentDescription;
            private Integer targetImageWidth;
            private Boolean enableTextHints;
            private Boolean enableGenericKvp;
            private KvpField fields;

            private Builder() {
            }

            public Builder documentType(String documentType) {
                this.documentType = documentType;
                return this;
            }

            public Builder documentDescription(String documentDescription) {
                this.documentDescription = documentDescription;
                return this;
            }

            public Builder targetImageWidth(Integer targetImageWidth) {
                this.targetImageWidth = targetImageWidth;
                return this;
            }

            public Builder enableTextHints(Boolean enableTextHints) {
                this.enableTextHints = enableTextHints;
                return this;
            }

            public Builder enableGenericKvp(Boolean enableGenericKvp) {
                this.enableGenericKvp = enableGenericKvp;
                return this;
            }

            public Builder fields(KvpField fields) {
                this.fields = fields;
                return this;
            }

            public Schema build() {
                return new Schema(this);
            }
        }
    }

    public static class SemanticConfig {
        private final Integer targetImageWidth;
        private final Boolean enableTextHints;
        private final Boolean enableGenericKvp;
        private final List<Schema> schemas;

        public SemanticConfig(Builder builder) {
            this.targetImageWidth = builder.targetImageWidth;
            this.enableTextHints = builder.enableTextHints;
            this.enableGenericKvp = builder.enableGenericKvp;
            this.schemas = builder.schemas;
        }

        public Integer getTargetImageWidth() {
            return this.targetImageWidth;
        }

        public Boolean getEnableTextHints() {
            return this.enableTextHints;
        }

        public Boolean getEnableGenericKvp() {
            return this.enableGenericKvp;
        }

        public List<Schema> getSchemas() {
            return this.schemas;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Integer targetImageWidth;
            private Boolean enableTextHints;
            private Boolean enableGenericKvp;
            private List<Schema> schemas;

            private Builder() {
            }

            public Builder targetImageWidth(Integer targetImageWidth) {
                this.targetImageWidth = targetImageWidth;
                return this;
            }

            public Builder enableTextHints(Boolean enableTextHints) {
                this.enableTextHints = enableTextHints;
                return this;
            }

            public Builder enableGenericKvp(Boolean enableGenericKvp) {
                this.enableGenericKvp = enableGenericKvp;
                return this;
            }

            public Builder schemas(List<Schema> schemas) {
                this.schemas = schemas;
                return this;
            }

            public SemanticConfig build() {
                return new SemanticConfig(this);
            }
        }
    }

    public record KvpField(String description, String example) {
    }

    public record CosDataLocation(String fileName, String bucket) {
        public CosDataLocation {
            Objects.requireNonNull(fileName, "fileName cannot be null");
        }
    }

    public record CosDataConnection(String id) {
        public CosDataConnection {
            Objects.requireNonNull(id, "id cannot be null");
        }
    }
}

