/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textextraction;

import com.ibm.watsonx.ai.WatsonxRestClient;
import com.ibm.watsonx.ai.textextraction.DefaultRestClient;
import com.ibm.watsonx.ai.textextraction.TextExtractionDeleteParameters;
import com.ibm.watsonx.ai.textextraction.TextExtractionFetchParameters;
import com.ibm.watsonx.ai.textextraction.TextExtractionRequest;
import com.ibm.watsonx.ai.textextraction.TextExtractionResponse;
import java.io.InputStream;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public abstract class TextExtractionRestClient
extends WatsonxRestClient {
    protected final String cosUrl;

    protected TextExtractionRestClient(Builder builder) {
        super(builder);
        this.cosUrl = Objects.requireNonNull(builder.cosUrl, "cosUrl cannot be null");
    }

    public abstract boolean deleteFile(DeleteFileRequest var1);

    public abstract CompletableFuture<Boolean> asyncDeleteFile(DeleteFileRequest var1);

    public abstract String readFile(ReadFileRequest var1);

    public abstract boolean upload(UploadRequest var1);

    public abstract boolean deleteExtraction(DeleteExtractionRequest var1);

    public abstract TextExtractionResponse fetchExtractionDetails(FetchExtractionDetailsRequest var1);

    public abstract TextExtractionResponse startExtraction(StartExtractionRequest var1);

    static Builder builder() {
        return ServiceLoader.load(TextExtractionRestClientBuilderFactory.class).findFirst().map(Supplier::get).orElse(DefaultRestClient.builder());
    }

    public static abstract class Builder
    extends WatsonxRestClient.Builder<TextExtractionRestClient, Builder> {
        private String cosUrl;

        public Builder cosUrl(String cosUrl) {
            this.cosUrl = cosUrl;
            return this;
        }
    }

    public static interface TextExtractionRestClientBuilderFactory
    extends Supplier<Builder> {
    }

    public record StartExtractionRequest(String requestTrackingId, String transactionId, TextExtractionRequest textExtractionRequest) {
        public static StartExtractionRequest of(TextExtractionRequest textExtractionRequest) {
            return StartExtractionRequest.of(null, null, textExtractionRequest);
        }

        public static StartExtractionRequest withTransactionId(String transactionId, TextExtractionRequest textExtractionRequest) {
            return StartExtractionRequest.of(null, transactionId, textExtractionRequest);
        }

        public static StartExtractionRequest withRequestTrackingId(String requestTrackingId, TextExtractionRequest textExtractionRequest) {
            return StartExtractionRequest.of(requestTrackingId, null, textExtractionRequest);
        }

        public static StartExtractionRequest of(String requestTrackingId, String transactionId, TextExtractionRequest textExtractionRequest) {
            return new StartExtractionRequest(requestTrackingId, transactionId, textExtractionRequest);
        }
    }

    public record FetchExtractionDetailsRequest(String requestTrackingId, String extractionId, TextExtractionFetchParameters parameters) {
        public static FetchExtractionDetailsRequest of(String extractionId, TextExtractionFetchParameters parameters) {
            return FetchExtractionDetailsRequest.of(null, extractionId, parameters);
        }

        public static FetchExtractionDetailsRequest of(String requestTrackingId, String extractionId, TextExtractionFetchParameters parameters) {
            return new FetchExtractionDetailsRequest(requestTrackingId, extractionId, parameters);
        }
    }

    public record DeleteExtractionRequest(String requestTrackingId, String extractionId, TextExtractionDeleteParameters parameters) {
        public static DeleteExtractionRequest of(String extractionId, TextExtractionDeleteParameters parameters) {
            return DeleteExtractionRequest.of(null, extractionId, parameters);
        }

        public static DeleteExtractionRequest of(String requestTrackingId, String extractionId, TextExtractionDeleteParameters parameters) {
            return new DeleteExtractionRequest(requestTrackingId, extractionId, parameters);
        }
    }

    public record UploadRequest(String requestTrackingId, String bucketName, InputStream is, String fileName) {
        public static UploadRequest of(String bucketName, InputStream is, String fileName) {
            return UploadRequest.of(null, bucketName, is, fileName);
        }

        public static UploadRequest of(String requestTrackingId, String bucketName, InputStream is, String fileName) {
            return new UploadRequest(requestTrackingId, bucketName, is, fileName);
        }
    }

    public record ReadFileRequest(String requestTrackingId, String bucketName, String fileName) {
        public static ReadFileRequest of(String bucketName, String fileName) {
            return ReadFileRequest.of(null, bucketName, fileName);
        }

        public static ReadFileRequest of(String requestTrackingId, String bucketName, String fileName) {
            return new ReadFileRequest(requestTrackingId, bucketName, fileName);
        }
    }

    public record DeleteFileRequest(String requestTrackingId, String bucketName, String fileName) {
        public static DeleteFileRequest of(String bucketName, String fileName) {
            return DeleteFileRequest.of(null, bucketName, fileName);
        }

        public static DeleteFileRequest of(String requestTrackingId, String bucketName, String fileName) {
            return new DeleteFileRequest(requestTrackingId, bucketName, fileName);
        }
    }
}

