/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textextraction;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.textextraction.CosReference;
import com.ibm.watsonx.ai.textextraction.TextExtractionDeleteParameters;
import com.ibm.watsonx.ai.textextraction.TextExtractionException;
import com.ibm.watsonx.ai.textextraction.TextExtractionFetchParameters;
import com.ibm.watsonx.ai.textextraction.TextExtractionParameters;
import com.ibm.watsonx.ai.textextraction.TextExtractionRequest;
import com.ibm.watsonx.ai.textextraction.TextExtractionResponse;
import com.ibm.watsonx.ai.textextraction.TextExtractionRestClient;
import com.ibm.watsonx.ai.textextraction.TextExtractionUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TextExtractionService
extends WatsonxService.ProjectService {
    private static final Logger logger = LoggerFactory.getLogger(TextExtractionService.class);
    private final String cosUrl;
    private final CosReference documentReference;
    private final CosReference resultReference;
    private final TextExtractionRestClient client;

    private TextExtractionService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.getAuthenticationProvider(), "authenticationProvider cannot be null");
        String tmpUrl = Objects.requireNonNull(builder.cosUrl, "cosUrl value cannot be null");
        this.cosUrl = tmpUrl.endsWith("/") ? tmpUrl.substring(0, tmpUrl.length() - 1) : tmpUrl;
        this.documentReference = Objects.requireNonNull(builder.documentReference, "documentReference value cannot be null");
        this.resultReference = Objects.requireNonNull(builder.resultReference, "resultReference value cannot be null");
        this.client = (TextExtractionRestClient)((TextExtractionRestClient.Builder)((TextExtractionRestClient.Builder)((TextExtractionRestClient.Builder)((TextExtractionRestClient.Builder)((TextExtractionRestClient.Builder)((TextExtractionRestClient.Builder)TextExtractionRestClient.builder().cosUrl(this.cosUrl).baseUrl(this.baseUrl)).version(this.version)).logRequests(this.logRequests)).logResponses(this.logResponses)).timeout(this.timeout)).authenticationProvider(builder.getAuthenticationProvider())).build();
    }

    public TextExtractionResponse startExtraction(String absolutePath) throws TextExtractionException {
        return this.startExtraction(absolutePath, null);
    }

    public TextExtractionResponse startExtraction(String absolutePath, TextExtractionParameters parameters) throws TextExtractionException {
        return this.startExtraction(UUID.randomUUID().toString(), absolutePath, parameters, false);
    }

    public TextExtractionResponse uploadAndStartExtraction(File file) throws TextExtractionException {
        return this.uploadAndStartExtraction(file, null);
    }

    public TextExtractionResponse uploadAndStartExtraction(File file, TextExtractionParameters parameters) throws TextExtractionException {
        Objects.requireNonNull(file);
        if (file.isDirectory()) {
            throw new TextExtractionException("directory_not_allowed", "The file can not be a directory");
        }
        String requestId = UUID.randomUUID().toString();
        try {
            this.upload(requestId, new BufferedInputStream(new FileInputStream(file)), file.getName(), parameters, false);
            return this.startExtraction(requestId, file.getName(), parameters, false);
        }
        catch (FileNotFoundException e) {
            throw new TextExtractionException("file_not_found", e.getMessage(), e);
        }
    }

    public TextExtractionResponse uploadAndStartExtraction(InputStream is, String fileName) throws TextExtractionException {
        return this.uploadAndStartExtraction(is, fileName, null);
    }

    public TextExtractionResponse uploadAndStartExtraction(InputStream is, String fileName, TextExtractionParameters parameters) throws TextExtractionException {
        String requestId = UUID.randomUUID().toString();
        this.upload(requestId, is, fileName, parameters, false);
        return this.startExtraction(requestId, fileName, parameters, false);
    }

    public String extractAndFetch(String absolutePath) throws TextExtractionException {
        return this.extractAndFetch(absolutePath, null);
    }

    public String extractAndFetch(String absolutePath, TextExtractionParameters parameters) throws TextExtractionException {
        return this.extractAndFetch(UUID.randomUUID().toString(), absolutePath, parameters);
    }

    public String uploadExtractAndFetch(File file) throws TextExtractionException {
        return this.uploadExtractAndFetch(file, null);
    }

    public String uploadExtractAndFetch(File file, TextExtractionParameters parameters) throws TextExtractionException {
        if (Objects.nonNull(parameters)) {
            if (parameters.getRequestedOutputs().size() > 1) {
                throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed if more than one file is to be generated");
            }
            if (parameters.getRequestedOutputs().size() == 1 && parameters.getRequestedOutputs().get(0).equals(TextExtractionParameters.Type.PAGE_IMAGES.value())) {
                throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed for the type \"page_images\"");
            }
        }
        String requestId = UUID.randomUUID().toString();
        try {
            this.upload(requestId, new BufferedInputStream(new FileInputStream(file)), file.getName(), parameters, true);
        }
        catch (FileNotFoundException e) {
            throw new TextExtractionException("file_not_found", e.getMessage(), e);
        }
        return this.extractAndFetch(requestId, file.getName(), parameters);
    }

    public String uploadExtractAndFetch(InputStream is, String fileName) throws TextExtractionException {
        return this.uploadExtractAndFetch(is, fileName, null);
    }

    public String uploadExtractAndFetch(InputStream is, String fileName, TextExtractionParameters parameters) throws TextExtractionException {
        if (Objects.nonNull(parameters)) {
            if (parameters.getRequestedOutputs().size() > 1) {
                throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed if more than one file is to be generated");
            }
            if (parameters.getRequestedOutputs().size() == 1 && parameters.getRequestedOutputs().get(0).equals(TextExtractionParameters.Type.PAGE_IMAGES.value())) {
                throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed for the type \"page_images\"");
            }
        }
        String requestId = UUID.randomUUID().toString();
        this.upload(requestId, is, fileName, parameters, true);
        return this.extractAndFetch(requestId, fileName, parameters);
    }

    public TextExtractionResponse fetchExtractionRequest(String id) {
        return this.fetchExtractionRequest(id, TextExtractionFetchParameters.builder().build());
    }

    public TextExtractionResponse fetchExtractionRequest(String id, TextExtractionFetchParameters parameters) {
        return this.fetchExtractionRequest(UUID.randomUUID().toString(), id, parameters);
    }

    public boolean uploadFile(File file) throws TextExtractionException {
        try {
            return this.uploadFile(new BufferedInputStream(new FileInputStream(file)), file.getName());
        }
        catch (FileNotFoundException e) {
            throw new TextExtractionException("file_not_found", e.getMessage(), e);
        }
    }

    public boolean uploadFile(InputStream inputStream, String fileName) {
        String requestId = UUID.randomUUID().toString();
        this.upload(requestId, inputStream, fileName, null, false);
        return true;
    }

    public boolean deleteFile(String bucketName, String fileName) {
        return this.client.deleteFile(TextExtractionRestClient.DeleteFileRequest.of(bucketName, fileName));
    }

    public String readFile(String bucketName, String fileName) {
        return this.client.readFile(TextExtractionRestClient.ReadFileRequest.of(bucketName, fileName));
    }

    public boolean deleteRequest(String id) {
        return this.deleteRequest(id, TextExtractionDeleteParameters.builder().build());
    }

    public boolean deleteRequest(String id, TextExtractionDeleteParameters parameters) {
        Objects.requireNonNull(id, "The id can not be null");
        TextExtractionDeleteParameters p = ((TextExtractionDeleteParameters.Builder)((TextExtractionDeleteParameters.Builder)((TextExtractionDeleteParameters.Builder)TextExtractionDeleteParameters.builder().projectId(Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId))).spaceId(Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId))).transactionId(parameters.getTransactionId())).hardDelete(parameters.getHardDelete().orElse(null)).build();
        if (Objects.isNull(p.getProjectId()) && Objects.isNull(p.getSpaceId())) {
            throw new IllegalArgumentException("Either projectId or spaceId must be provided");
        }
        TextExtractionRestClient.DeleteExtractionRequest request = TextExtractionRestClient.DeleteExtractionRequest.of(parameters.getTransactionId(), id, p);
        return this.client.deleteExtraction(request);
    }

    private TextExtractionResponse fetchExtractionRequest(String requestId, String id, TextExtractionFetchParameters parameters) {
        Objects.requireNonNull(requestId, "The requestId can not be null");
        Objects.requireNonNull(id, "The id can not be null");
        TextExtractionFetchParameters p = ((TextExtractionFetchParameters.Builder)((TextExtractionFetchParameters.Builder)((TextExtractionFetchParameters.Builder)TextExtractionFetchParameters.builder().projectId(Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId))).spaceId(Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId))).transactionId(parameters.getTransactionId())).build();
        if (Objects.isNull(p.getProjectId()) && Objects.isNull(p.getSpaceId())) {
            throw new IllegalArgumentException("Either projectId or spaceId must be provided");
        }
        TextExtractionRestClient.FetchExtractionDetailsRequest request = TextExtractionRestClient.FetchExtractionDetailsRequest.of(requestId, id, p);
        return this.client.fetchExtractionDetails(request);
    }

    private String extractAndFetch(String requestId, String absolutePath, TextExtractionParameters parameters) throws TextExtractionException {
        Objects.requireNonNull(requestId, "requestId cannot be null");
        if (Objects.nonNull(parameters)) {
            if (parameters.getRequestedOutputs().size() > 1) {
                throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed if more than one file is to be generated");
            }
            if (parameters.getRequestedOutputs().size() == 1 && parameters.getRequestedOutputs().get(0).equals(TextExtractionParameters.Type.PAGE_IMAGES.value())) {
                throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed for the type \"page_images\"");
            }
        }
        TextExtractionResponse textExtractionResponse = this.startExtraction(requestId, absolutePath, parameters, true);
        return this.getExtractedText(requestId, textExtractionResponse, parameters);
    }

    private void upload(String requestId, InputStream is, String fileName, TextExtractionParameters parameters, boolean waitForExtraction) {
        Objects.requireNonNull(requestId, "requestId value cannot be null");
        Objects.requireNonNull(is, "is value cannot be null");
        Objects.requireNonNull(fileName, "fileName value cannot be null");
        boolean removeOutputFile = false;
        boolean removeUploadedFile = false;
        CosReference documentReference = this.documentReference;
        if (Objects.nonNull(parameters)) {
            removeOutputFile = parameters.isRemoveOutputFile();
            removeUploadedFile = parameters.isRemoveUploadedFile();
            documentReference = Objects.requireNonNullElse(parameters.getDocumentReference(), this.documentReference);
        }
        if (!waitForExtraction && (removeOutputFile || removeUploadedFile)) {
            throw new IllegalArgumentException("The asynchronous version of startExtraction doesn't allow the use of the \"removeOutputFile\" and \"removeUploadedFile\" parameters");
        }
        TextExtractionRestClient.UploadRequest request = TextExtractionRestClient.UploadRequest.of(requestId, documentReference.bucket(), is, fileName);
        this.client.upload(request);
    }

    private TextExtractionResponse startExtraction(String requestId, String path, TextExtractionParameters parameters, boolean waitUntilJobIsDone) throws TextExtractionException {
        TextExtractionResponse.Status status;
        boolean isMultiOutput;
        Objects.requireNonNull(path);
        Objects.requireNonNull(requestId);
        Object outputFileName = null;
        String projectId = this.projectId;
        String spaceId = this.spaceId;
        boolean removeOutputFile = false;
        boolean removeUploadedFile = false;
        List<String> requestedOutputs = List.of(TextExtractionParameters.Type.MD.value());
        CosReference documentReference = this.documentReference;
        CosReference resultReference = this.resultReference;
        TextExtractionRequest.Parameters params = null;
        Map<String, Object> custom = null;
        Duration timeout = Duration.ofSeconds(60L);
        String transactionId = null;
        if (Objects.nonNull(parameters)) {
            removeOutputFile = parameters.isRemoveOutputFile();
            removeUploadedFile = parameters.isRemoveUploadedFile();
            outputFileName = parameters.getOutputFileName();
            projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
            spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
            requestedOutputs = Objects.requireNonNullElse(parameters.getRequestedOutputs(), requestedOutputs);
            documentReference = Objects.requireNonNullElse(parameters.getDocumentReference(), this.documentReference);
            resultReference = Objects.requireNonNullElse(parameters.getResultReference(), this.resultReference);
            params = parameters.toParameters();
            custom = parameters.getCustom();
            timeout = Objects.requireNonNullElse(parameters.getTimeout(), Duration.ofSeconds(60L));
            transactionId = parameters.getTransactionId();
        } else {
            params = TextExtractionRequest.Parameters.of(requestedOutputs);
        }
        if (!waitUntilJobIsDone && (removeOutputFile || removeUploadedFile)) {
            throw new IllegalArgumentException("The asynchronous version of startExtraction doesn't allow the use of the \"removeOutputFile\" and \"removeUploadedFile\" parameters");
        }
        boolean bl = isMultiOutput = requestedOutputs.size() > 1 || requestedOutputs.get(0).equals(TextExtractionParameters.Type.PAGE_IMAGES.value());
        if (Objects.isNull(outputFileName)) {
            if (isMultiOutput) {
                outputFileName = "/";
            } else {
                TextExtractionParameters.Type type = TextExtractionParameters.Type.fromValue(requestedOutputs.get(0));
                outputFileName = TextExtractionUtils.addExtension(path, type);
            }
        } else {
            boolean isDirectory = ((String)outputFileName).endsWith("/");
            if (isDirectory && !isMultiOutput) {
                TextExtractionParameters.Type type = TextExtractionParameters.Type.fromValue(requestedOutputs.get(0));
                outputFileName = (String)outputFileName + TextExtractionUtils.addExtension(path, type);
            }
        }
        TextExtractionRequest textExtractionRequest = new TextExtractionRequest(projectId, spaceId, documentReference.toDataReference(path), resultReference.toDataReference((String)outputFileName), params, custom);
        TextExtractionRestClient.StartExtractionRequest request = TextExtractionRestClient.StartExtractionRequest.of(requestId, transactionId, textExtractionRequest);
        TextExtractionResponse response = this.client.startExtraction(request);
        if (!waitUntilJobIsDone) {
            return response;
        }
        long sleepTime = 100L;
        LocalTime endTime = LocalTime.now().plus(timeout);
        do {
            if (LocalTime.now().isAfter(endTime)) {
                throw new TextExtractionException("timeout", "Execution to extract %s file took longer than the timeout set by %s milliseconds".formatted(path, timeout.toMillis()));
            }
            try {
                Thread.sleep(sleepTime);
                sleepTime *= 2L;
                sleepTime = Math.min(sleepTime, 3000L);
            }
            catch (Exception e) {
                throw new TextExtractionException("interrupted", e.getMessage());
            }
            String processId = response.metadata().id();
            response = this.fetchExtractionRequest(requestId, processId, ((TextExtractionFetchParameters.Builder)((TextExtractionFetchParameters.Builder)TextExtractionFetchParameters.builder().projectId(projectId)).spaceId(spaceId)).build());
            status = TextExtractionResponse.Status.fromValue(response.entity().results().status());
            int pagesProcessed = response.entity().results().numberPagesProcessed();
            logger.debug("Extraction status: {} for the file {} (pages processed {})", new Object[]{status, path, pagesProcessed});
        } while (status != TextExtractionResponse.Status.FAILED && status != TextExtractionResponse.Status.COMPLETED);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExtractedText(String requestId, TextExtractionResponse textExtractionResponse, TextExtractionParameters parameters) throws TextExtractionException {
        Objects.requireNonNull(requestId);
        String uploadedPath = textExtractionResponse.entity().documentReference().location().fileName();
        String outputPath = textExtractionResponse.entity().resultsReference().location().fileName();
        TextExtractionResponse.Status status = TextExtractionResponse.Status.fromValue(textExtractionResponse.entity().results().status());
        boolean removeUploadedFile = false;
        boolean removeOutputFile = false;
        CosReference documentReference = this.documentReference;
        CosReference resultsReference = this.resultReference;
        if (Objects.nonNull(parameters)) {
            removeUploadedFile = parameters.isRemoveUploadedFile();
            removeOutputFile = parameters.isRemoveOutputFile();
            documentReference = Objects.requireNonNullElse(parameters.getDocumentReference(), this.documentReference);
            resultsReference = Objects.requireNonNullElse(parameters.getDocumentReference(), this.resultReference);
        }
        String documentBucketName = documentReference.bucket();
        String resultsBucketName = resultsReference.bucket();
        try {
            String extractedFile = this.client.readFile(switch (status) {
                case TextExtractionResponse.Status.COMPLETED -> TextExtractionRestClient.ReadFileRequest.of(requestId, documentBucketName, outputPath);
                case TextExtractionResponse.Status.FAILED -> {
                    TextExtractionResponse.Error error = textExtractionResponse.entity().results().error();
                    throw new TextExtractionException(error.code(), error.message());
                }
                default -> throw new TextExtractionException("generic_error", "Status %s not managed".formatted(new Object[]{status}));
            });
            if (removeOutputFile) {
                try {
                    String encodedFileName = new URI(null, null, outputPath, null).toASCIIString();
                    TextExtractionRestClient.DeleteFileRequest request = TextExtractionRestClient.DeleteFileRequest.of(requestId, resultsBucketName, encodedFileName);
                    this.client.asyncDeleteFile(request);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            String string = extractedFile;
            return string;
        }
        finally {
            if (removeUploadedFile) {
                try {
                    String encodedFileName = new URI(null, null, uploadedPath, null).toASCIIString();
                    TextExtractionRestClient.DeleteFileRequest request = TextExtractionRestClient.DeleteFileRequest.of(requestId, resultsBucketName, encodedFileName);
                    this.client.asyncDeleteFile(request);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxService.ProjectService.Builder<Builder> {
        private String cosUrl;
        private CosReference documentReference;
        private CosReference resultReference;

        private Builder() {
        }

        public Builder cosUrl(String cosUrl) {
            this.cosUrl = cosUrl;
            return this;
        }

        public Builder cosUrl(TextExtractionParameters.CosUrl cosUrl) {
            Objects.requireNonNull(cosUrl, "cosUrl cannot be null");
            return this.cosUrl(cosUrl.value());
        }

        public Builder documentReference(CosReference documentReference) {
            this.documentReference = documentReference;
            return this;
        }

        public Builder documentReference(String connectionId, String bucket) {
            return this.documentReference(CosReference.of(connectionId, bucket));
        }

        public Builder resultReference(CosReference resultReference) {
            this.resultReference = resultReference;
            return this;
        }

        public Builder resultReference(String connectionId, String bucket) {
            return this.resultReference(CosReference.of(connectionId, bucket));
        }

        public TextExtractionService build() {
            return new TextExtractionService(this);
        }
    }
}

