/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textgeneration;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.textgeneration.Moderation;
import com.ibm.watsonx.ai.textgeneration.TextGenerationHandler;
import com.ibm.watsonx.ai.textgeneration.TextGenerationParameters;
import com.ibm.watsonx.ai.textgeneration.TextGenerationProvider;
import com.ibm.watsonx.ai.textgeneration.TextGenerationRequest;
import com.ibm.watsonx.ai.textgeneration.TextGenerationResponse;
import com.ibm.watsonx.ai.textgeneration.TextGenerationRestClient;
import com.ibm.watsonx.ai.textgeneration.TextRequest;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TextGenerationService
extends WatsonxService.ModelService
implements TextGenerationProvider {
    private static final Logger logger = LoggerFactory.getLogger(TextGenerationService.class);
    private final TextGenerationRestClient client;

    private TextGenerationService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.getAuthenticationProvider(), "authenticationProvider cannot be null");
        this.client = (TextGenerationRestClient)((TextGenerationRestClient.Builder)((TextGenerationRestClient.Builder)((TextGenerationRestClient.Builder)((TextGenerationRestClient.Builder)((TextGenerationRestClient.Builder)((TextGenerationRestClient.Builder)TextGenerationRestClient.builder().baseUrl(this.baseUrl)).version(this.version)).logRequests(this.logRequests)).logResponses(this.logResponses)).timeout(this.timeout)).authenticationProvider(builder.getAuthenticationProvider())).build();
    }

    @Override
    public TextGenerationResponse generate(TextGenerationRequest textGenerationRequest) {
        Objects.requireNonNull(textGenerationRequest, "textGenerationRequest cannot be null");
        if (Objects.nonNull(textGenerationRequest.getDeploymentId())) {
            logger.info("The deploymentId parameter can not be used with the TextGenerationService. Use the DeploymentService instead");
        }
        String input = Objects.requireNonNull(textGenerationRequest.getInput(), "input cannot be null");
        Moderation moderation = textGenerationRequest.getModeration();
        TextGenerationParameters parameters = Objects.requireNonNullElse(textGenerationRequest.getParameters(), TextGenerationParameters.builder().build());
        if (Objects.nonNull(parameters.getPromptVariables())) {
            parameters.setPromptVariables(null);
            logger.warn("Prompt variables are not supported in Text Generation service");
        }
        String modelId = Objects.requireNonNullElse(parameters.getModelId(), this.modelId);
        String projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
        String spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
        Long timeout = Objects.requireNonNullElse(parameters.getTimeLimit(), this.timeout.toMillis());
        parameters.setTimeLimit(timeout);
        TextRequest textGenRequest = new TextRequest(modelId, spaceId, projectId, input, parameters.toSanitized(), moderation);
        return this.client.generate(parameters.getTransactionId(), textGenRequest);
    }

    @Override
    public CompletableFuture<Void> generateStreaming(TextGenerationRequest textGenerationRequest, TextGenerationHandler handler) {
        Objects.requireNonNull(textGenerationRequest, "textGenerationRequest cannot be null");
        if (Objects.nonNull(textGenerationRequest.getDeploymentId())) {
            logger.info("The deploymentId parameter can not be used with the TextGenerationService. Use the DeploymentService instead");
        }
        String input = Objects.requireNonNull(textGenerationRequest.getInput(), "input cannot be null");
        TextGenerationParameters parameters = Objects.requireNonNullElse(textGenerationRequest.getParameters(), TextGenerationParameters.builder().build());
        if (Objects.nonNull(parameters.getPromptVariables())) {
            parameters.setPromptVariables(null);
            logger.warn("Prompt variables are not supported in Text Generation service");
        }
        String modelId = Objects.requireNonNullElse(parameters.getModelId(), this.modelId);
        String projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
        String spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
        Long timeout = Objects.requireNonNullElse(parameters.getTimeLimit(), this.timeout.toMillis());
        parameters.setTimeLimit(timeout);
        TextRequest textGenRequest = new TextRequest(modelId, spaceId, projectId, input, parameters.toSanitized(), null);
        return this.client.generateStreaming(parameters.getTransactionId(), textGenRequest, handler);
    }

    public TextGenerationResponse generate(String input) {
        return this.generate(input, TextGenerationParameters.builder().build());
    }

    public TextGenerationResponse generate(String input, TextGenerationParameters parameters) {
        return this.generate(TextGenerationRequest.builder().input(input).parameters(parameters).build());
    }

    public TextGenerationResponse generate(String input, Moderation moderation) {
        return this.generate(TextGenerationRequest.builder().input(input).moderation(moderation).build());
    }

    public CompletableFuture<Void> generateStreaming(String input, TextGenerationHandler handler) {
        return this.generateStreaming(input, null, handler);
    }

    public CompletableFuture<Void> generateStreaming(String input, TextGenerationParameters parameters, TextGenerationHandler handler) {
        return this.generateStreaming(TextGenerationRequest.builder().input(input).parameters(parameters).build(), handler);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxService.ModelService.Builder<Builder> {
        private Builder() {
        }

        public TextGenerationService build() {
            return new TextGenerationService(this);
        }
    }
}

