/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.timeseries;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class InputSchema {
    private final String timestampColumn;
    private final List<String> idColumns;
    private final String freq;
    private final List<String> targetColumns;

    protected InputSchema(Builder builder) {
        this.timestampColumn = Objects.requireNonNull(builder.timestampColumn, "The timestampColumn must be provided");
        this.idColumns = builder.idColumns.isEmpty() ? null : builder.idColumns;
        this.freq = builder.freq;
        this.targetColumns = builder.targetColumns.isEmpty() ? null : builder.targetColumns;
    }

    public String getTimestampColumn() {
        return this.timestampColumn;
    }

    public List<String> getIdColumns() {
        return this.idColumns;
    }

    public String getFreq() {
        return this.freq;
    }

    public List<String> getTargetColumns() {
        return this.targetColumns;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String timestampColumn;
        private List<String> idColumns = new ArrayList<String>();
        private String freq;
        private List<String> targetColumns = new ArrayList<String>();

        protected Builder() {
        }

        public Builder timestampColumn(String timestampColumn) {
            this.timestampColumn = timestampColumn;
            return this;
        }

        public Builder idColumns(List<String> idColumns) {
            idColumns = Objects.requireNonNullElse(idColumns, new ArrayList());
            this.idColumns = Objects.requireNonNullElse(idColumns, this.idColumns);
            return this;
        }

        public Builder idColumns(String ... idColumns) {
            return this.idColumns(new ArrayList<String>(List.of(idColumns)));
        }

        public Builder addIdColumn(String idColumn) {
            this.idColumns.add(idColumn);
            return this;
        }

        public Builder freq(String freq) {
            this.freq = freq;
            return this;
        }

        public Builder targetColumns(List<String> targetColumns) {
            targetColumns = Objects.requireNonNullElse(targetColumns, new ArrayList());
            this.targetColumns.addAll(targetColumns);
            return this;
        }

        public Builder targetColumns(String ... targetColumns) {
            return this.targetColumns(new ArrayList<String>(List.of(targetColumns)));
        }

        public Builder addTargetColumn(String targetColumn) {
            this.targetColumns.add(targetColumn);
            return this;
        }

        public InputSchema build() {
            return new InputSchema(this);
        }
    }
}

