/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat;

import com.ibm.watsonx.ai.chat.ChatHandler;
import com.ibm.watsonx.ai.chat.ChatRequest;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.model.ChatMessage;
import com.ibm.watsonx.ai.chat.model.ChatParameters;
import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.PartialChatResponse;
import com.ibm.watsonx.ai.chat.model.ResultMessage;
import com.ibm.watsonx.ai.chat.model.Tool;
import com.ibm.watsonx.ai.chat.model.ToolCall;
import com.ibm.watsonx.ai.chat.util.StreamingStateTracker;
import com.ibm.watsonx.ai.chat.util.StreamingToolFetcher;
import com.ibm.watsonx.ai.core.Json;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;

public interface ChatProvider {
    default public ChatResponse chat(ChatMessage ... messages) {
        return this.chat(Arrays.asList(messages));
    }

    default public ChatResponse chat(List<ChatMessage> messages) {
        return this.chat(messages, ChatParameters.builder().build());
    }

    default public ChatResponse chat(List<ChatMessage> messages, Tool ... tools) {
        return this.chat(messages, Arrays.asList(tools));
    }

    default public ChatResponse chat(List<ChatMessage> messages, List<Tool> tools) {
        return this.chat(messages, null, tools);
    }

    default public ChatResponse chat(List<ChatMessage> messages, ChatParameters parameters) {
        return this.chat(messages, parameters, List.of());
    }

    default public ChatResponse chat(List<ChatMessage> messages, ChatParameters parameters, Tool ... tools) {
        return this.chat(messages, parameters, Arrays.asList(tools));
    }

    default public ChatResponse chat(List<ChatMessage> messages, ChatParameters parameters, List<Tool> tools) {
        return this.chat(ChatRequest.builder().messages(messages).parameters(parameters).tools(tools).build());
    }

    default public CompletableFuture<Void> chatStreaming(List<ChatMessage> messages, ChatHandler handler) {
        return this.chatStreaming(messages, ChatParameters.builder().build(), handler);
    }

    default public CompletableFuture<Void> chatStreaming(List<ChatMessage> messages, List<Tool> tools, ChatHandler handler) {
        return this.chatStreaming(messages, ChatParameters.builder().build(), tools, handler);
    }

    default public CompletableFuture<Void> chatStreaming(List<ChatMessage> messages, ChatParameters parameters, ChatHandler handler) {
        return this.chatStreaming(messages, parameters, null, handler);
    }

    default public CompletableFuture<Void> chatStreaming(List<ChatMessage> messages, ChatParameters parameters, List<Tool> tools, ChatHandler handler) {
        ChatRequest chatRequest = ChatRequest.builder().messages(messages).parameters(parameters).tools(tools).build();
        return this.chatStreaming(chatRequest, handler);
    }

    public ChatResponse chat(ChatRequest var1);

    public CompletableFuture<Void> chatStreaming(ChatRequest var1, ChatHandler var2);

    default public Void handlerError(Throwable t, ChatHandler handler) {
        Optional.ofNullable(t).map(Throwable::getCause).ifPresent(handler::onError);
        return null;
    }

    default public Flow.Subscriber<String> subscriber(String toolChoiceOption, final Map<String, Boolean> toolHasParameters, final ExtractionTags extractionTags, final ChatHandler handler) {
        return new Flow.Subscriber<String>(){
            private Flow.Subscription subscription;
            private volatile String finishReason;
            private volatile String role;
            private volatile String refusal;
            private volatile boolean success = true;
            private final StringBuilder stringBuilder = new StringBuilder();
            private final List<StreamingToolFetcher> tools = new ArrayList<StreamingToolFetcher>();
            private final ChatResponse chatResponse = new ChatResponse();
            private final StreamingStateTracker stateTracker = Objects.nonNull(extractionTags) ? new StreamingStateTracker(extractionTags) : null;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(String partialMessage) {
                try {
                    if (Objects.isNull(partialMessage) || partialMessage.isBlank() || !partialMessage.startsWith("data: ")) {
                        return;
                    }
                    String messageData = partialMessage.split("data: ")[1];
                    PartialChatResponse chunk = (PartialChatResponse)Json.fromJson((String)messageData, PartialChatResponse.class);
                    if (chunk.choices().size() == 0) {
                        this.chatResponse.setUsage(chunk.usage());
                        return;
                    }
                    PartialChatResponse.ResultChoice message = chunk.choices().get(0);
                    if (Objects.isNull(this.chatResponse.getCreated()) && Objects.nonNull(chunk.created())) {
                        this.chatResponse.setCreated(chunk.created());
                    }
                    if (Objects.isNull(this.chatResponse.getCreatedAt()) && Objects.nonNull(chunk.createdAt())) {
                        this.chatResponse.setCreatedAt(chunk.createdAt());
                    }
                    if (Objects.isNull(this.chatResponse.getId()) && Objects.nonNull(chunk.id())) {
                        this.chatResponse.setId(chunk.id());
                    }
                    if (Objects.isNull(this.chatResponse.getModelId()) && Objects.nonNull(chunk.modelId())) {
                        this.chatResponse.setModelId(chunk.modelId());
                    }
                    if (Objects.isNull(this.chatResponse.getObject()) && Objects.nonNull(chunk.object())) {
                        this.chatResponse.setObject(chunk.object());
                    }
                    if (Objects.isNull(this.chatResponse.getModelVersion()) && Objects.nonNull(chunk.modelVersion())) {
                        this.chatResponse.setModelVersion(chunk.modelVersion());
                    }
                    if (Objects.isNull(this.chatResponse.getModel()) && Objects.nonNull(chunk.model())) {
                        this.chatResponse.setModel(chunk.model());
                    }
                    if (Objects.isNull(this.finishReason) && Objects.nonNull(message.finishReason())) {
                        this.finishReason = message.finishReason();
                    }
                    if (Objects.isNull(this.role) && Objects.nonNull(message.delta().role())) {
                        this.role = message.delta().role();
                    }
                    if (Objects.isNull(this.refusal) && Objects.nonNull(message.delta().refusal())) {
                        this.refusal = message.delta().refusal();
                    }
                    if (message.delta().toolCalls() != null) {
                        StreamingToolFetcher toolFetcher;
                        this.finishReason = "tool_calls";
                        ToolCall deltaTool = message.delta().toolCalls().get(0);
                        Integer index = deltaTool.index();
                        if (index + 1 > this.tools.size()) {
                            toolFetcher = new StreamingToolFetcher(index);
                            this.tools.add(toolFetcher);
                            if (index - 1 >= 0) {
                                ToolCall tool = this.tools.get(index - 1).build();
                                handler.onCompleteToolCall(tool);
                            }
                        } else {
                            toolFetcher = this.tools.get(index);
                        }
                        toolFetcher.setId(deltaTool.id());
                        if (Objects.nonNull(deltaTool.function())) {
                            String arguments;
                            toolFetcher.setName(deltaTool.function().name());
                            toolFetcher.appendArguments(deltaTool.function().arguments());
                            Boolean toolHasParameter = (Boolean)toolHasParameters.get(toolFetcher.getName());
                            String string = arguments = toolHasParameter != false ? deltaTool.function().arguments() : "{}";
                            if (!arguments.isEmpty()) {
                                StreamingToolFetcher.PartialToolCall partialToolCall = new StreamingToolFetcher.PartialToolCall(toolFetcher.getIndex(), toolFetcher.getId(), toolFetcher.getName(), arguments);
                                handler.onPartialToolCall(partialToolCall);
                            }
                        }
                    }
                    if (Objects.nonNull(message.delta().content())) {
                        String token = message.delta().content();
                        if (token.isEmpty()) {
                            return;
                        }
                        this.stringBuilder.append(token);
                        if (Objects.nonNull(this.stateTracker)) {
                            StreamingStateTracker.Result r = this.stateTracker.update(token);
                            Optional<String> content = r.content();
                            switch (r.state()) {
                                case RESPONSE: {
                                    content.ifPresent(c -> handler.onPartialResponse((String)c, chunk));
                                    break;
                                }
                                case THINKING: {
                                    content.ifPresent(c -> handler.onPartialThinking((String)c, chunk));
                                    break;
                                }
                                case NO_THINKING: {
                                    content.ifPresent(c -> handler.onPartialResponse((String)c, chunk));
                                    break;
                                }
                            }
                        } else {
                            handler.onPartialResponse(token, chunk);
                        }
                    }
                }
                catch (RuntimeException e) {
                    handler.onError(e);
                    this.success = !handler.failOnFirstError();
                }
                finally {
                    if (this.success) {
                        this.subscription.request(1L);
                    } else {
                        this.subscription.cancel();
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                handler.onError(throwable);
            }

            @Override
            public void onComplete() {
                try {
                    List<ToolCall> toolCalls = null;
                    String content = this.stringBuilder.toString();
                    if (Objects.nonNull(this.finishReason) && this.finishReason.equals("tool_calls")) {
                        content = null;
                        toolCalls = this.tools.stream().map(StreamingToolFetcher::build).toList();
                        handler.onCompleteToolCall(toolCalls.get(toolCalls.size() - 1));
                    }
                    ResultMessage resultMessage = new ResultMessage(this.role, content, this.refusal, toolCalls);
                    this.chatResponse.setChoices(List.of(new ChatResponse.ResultChoice(0, resultMessage, this.finishReason)));
                    handler.onCompleteResponse(this.chatResponse);
                }
                catch (RuntimeException e) {
                    handler.onError(e);
                }
            }
        };
    }
}

