/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat;

import com.ibm.watsonx.ai.chat.model.ChatMessage;
import com.ibm.watsonx.ai.chat.model.ChatParameters;
import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.Tool;
import java.util.List;
import java.util.Objects;

public class ChatRequest {
    private final List<ChatMessage> messages;
    private final List<Tool> tools;
    private final ChatParameters parameters;
    private final ExtractionTags extractionTags;

    protected ChatRequest(Builder builder) {
        this.messages = Objects.requireNonNull(builder.messages, "messages cannot be null");
        if (this.messages.isEmpty()) {
            throw new RuntimeException("messages cannot be empty");
        }
        this.tools = builder.tools;
        this.parameters = builder.parameters;
        this.extractionTags = builder.extractionTags;
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public ChatParameters getParameters() {
        return this.parameters;
    }

    public ExtractionTags getExtractionTags() {
        return this.extractionTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<ChatMessage> messages;
        private List<Tool> tools;
        private ChatParameters parameters;
        private ExtractionTags extractionTags;

        public Builder messages(ChatMessage ... messages) {
            return this.messages(List.of(messages));
        }

        public Builder messages(List<ChatMessage> messages) {
            this.messages = messages;
            return this;
        }

        public Builder tools(Tool ... tools) {
            return this.tools(List.of(tools));
        }

        public Builder tools(List<Tool> tools) {
            this.tools = tools;
            return this;
        }

        public Builder parameters(ChatParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder thinking(ExtractionTags extractionTags) {
            this.extractionTags = extractionTags;
            return this;
        }

        public ChatRequest build() {
            return new ChatRequest(this);
        }
    }
}

