/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat;

import com.ibm.watsonx.ai.chat.model.AssistantMessage;
import com.ibm.watsonx.ai.chat.model.ChatUsage;
import com.ibm.watsonx.ai.chat.model.FinishReason;
import com.ibm.watsonx.ai.chat.model.ResultMessage;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.XmlUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ChatResponse {
    private String id;
    private String object;
    private String modelId;
    private String model;
    private List<ResultChoice> choices;
    private Long created;
    private String modelVersion;
    private String createdAt;
    private ChatUsage usage;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getObject() {
        return this.object;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getModel() {
        return this.model;
    }

    public void setChoices(List<ResultChoice> choices) {
        this.choices = choices;
    }

    public List<ResultChoice> getChoices() {
        return this.choices;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setUsage(ChatUsage usage) {
        this.usage = usage;
    }

    public ChatUsage getUsage() {
        return this.usage;
    }

    public String toText() {
        AssistantMessage assistantMessage = this.toAssistantMessage();
        if (Objects.nonNull(assistantMessage.toolCalls())) {
            throw new RuntimeException("The response is of the type \"tool_calls\" and contains no text");
        }
        return assistantMessage.content();
    }

    public Map<String, String> toTextByTags(Set<String> tags) {
        Objects.requireNonNull(tags, "tags cannot be null");
        String wrappedXml = "<root>" + this.toText() + "</root>";
        Document doc = XmlUtils.parse((String)wrappedXml);
        Element root = doc.getDocumentElement();
        HashMap<String, String> result = new HashMap<String, String>();
        for (String tag : tags) {
            NodeList nodes = doc.getElementsByTagName(tag);
            for (int i = 0; i < nodes.getLength(); ++i) {
                String textContent;
                Element element = (Element)nodes.item(i);
                if (element == root) {
                    StringBuilder sb = new StringBuilder();
                    NodeList children = element.getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        String text;
                        Node child = children.item(j);
                        if (child.getNodeType() != 3 || (text = child.getTextContent().trim()).isEmpty()) continue;
                        sb.append(text);
                    }
                    textContent = sb.isEmpty() ? null : sb.toString();
                } else {
                    textContent = element.getTextContent().trim();
                }
                result.put(tag, textContent);
            }
        }
        return result;
    }

    public String toTextByTag(String tag) {
        return this.toTextByTags(Set.of(tag)).get(tag);
    }

    public <T> T toText(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return (T)Json.fromJson((String)this.toText(), clazz);
    }

    public AssistantMessage toAssistantMessage() {
        if (Objects.isNull(this.choices) || this.choices.isEmpty()) {
            throw new RuntimeException("The \"choices\" field is null or empty");
        }
        ResultMessage resultMessage = this.choices.get(0).getMessage();
        return new AssistantMessage("assistant", resultMessage.content(), null, resultMessage.refusal(), resultMessage.toolCalls());
    }

    public FinishReason finishReason() {
        if (Objects.isNull(this.choices) || this.choices.isEmpty()) {
            throw new RuntimeException("The \"choices\" field is null or empty");
        }
        ResultChoice resultMessage = this.choices.get(0);
        return FinishReason.fromValue(resultMessage.getFinishReason());
    }

    public static class ResultChoice {
        private Integer index;
        private ResultMessage message;
        private String finishReason;

        public ResultChoice() {
        }

        public ResultChoice(Integer index, ResultMessage message, String finishReason) {
            this.index = index;
            this.message = message;
            this.finishReason = finishReason;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public ResultMessage getMessage() {
            return this.message;
        }

        public void setMessage(ResultMessage message) {
            this.message = message;
        }

        public String getFinishReason() {
            return this.finishReason;
        }

        public void setFinishReason(String finishReason) {
            this.finishReason = finishReason;
        }
    }
}

