/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.chat.ChatHandler;
import com.ibm.watsonx.ai.chat.ChatProvider;
import com.ibm.watsonx.ai.chat.ChatRequest;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.model.AssistantMessage;
import com.ibm.watsonx.ai.chat.model.ChatMessage;
import com.ibm.watsonx.ai.chat.model.ChatParameters;
import com.ibm.watsonx.ai.chat.model.TextChatRequest;
import com.ibm.watsonx.ai.chat.model.Tool;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.SseEventLogger;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;

public final class ChatService
extends WatsonxService.ModelService
implements ChatProvider {
    protected ChatService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.getAuthenticationProvider(), "authenticationProvider cannot be null");
    }

    @Override
    public ChatResponse chat(ChatRequest chatRequest) {
        List<ChatMessage> messages = chatRequest.getMessages();
        List<Tool> tools = Objects.nonNull(chatRequest.getTools()) && !chatRequest.getTools().isEmpty() ? chatRequest.getTools() : null;
        ChatParameters parameters = chatRequest.getParameters();
        parameters = Objects.requireNonNullElse(parameters, ChatParameters.builder().build());
        String modelId = Objects.requireNonNullElse(parameters.getModelId(), this.modelId);
        String projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
        String spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
        Long timeout = Objects.requireNonNullElse(parameters.getTimeLimit(), this.timeout.toMillis());
        TextChatRequest textChatRequest = TextChatRequest.builder().modelId(modelId).projectId(projectId).spaceId(spaceId).messages(messages).tools(tools).parameters(parameters).timeLimit(timeout).build();
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString() + "%s/chat?version=%s".formatted(ML_API_TEXT_PATH, this.version))).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textChatRequest))).timeout(Duration.ofMillis(timeout));
        if (Objects.nonNull(parameters.getTransactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.getTransactionId());
        }
        try {
            AssistantMessage assistantMessage;
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            ChatResponse chatResponse = (ChatResponse)Json.fromJson((String)((String)httpReponse.body()), ChatResponse.class);
            if (Objects.nonNull(parameters.getToolChoiceOption()) && parameters.getToolChoiceOption().equals(ChatParameters.ToolChoice.REQUIRED.type()) && Objects.nonNull((assistantMessage = chatResponse.toAssistantMessage()).toolCalls()) && !assistantMessage.toolCalls().isEmpty()) {
                chatResponse.getChoices().get(0).setFinishReason("tool_calls");
            }
            return chatResponse;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<Void> chatStreaming(ChatRequest chatRequest, ChatHandler handler) {
        List<ChatMessage> messages = chatRequest.getMessages();
        List<Tool> tools = Objects.nonNull(chatRequest.getTools()) && !chatRequest.getTools().isEmpty() ? chatRequest.getTools() : null;
        ChatParameters parameters = chatRequest.getParameters();
        Objects.requireNonNull(handler, "The chatHandler parameter can not be null");
        parameters = Objects.requireNonNullElse(parameters, ChatParameters.builder().build());
        String modelId = Objects.requireNonNullElse(parameters.getModelId(), this.modelId);
        String projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
        String spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
        Long timeout = Objects.requireNonNullElse(parameters.getTimeLimit(), this.timeout.toMillis());
        TextChatRequest textChatRequest = TextChatRequest.builder().modelId(modelId).projectId(projectId).spaceId(spaceId).messages(messages).tools(tools).parameters(parameters).timeLimit(timeout).build();
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString() + "%s/chat_stream?version=%s".formatted(ML_API_TEXT_PATH, this.version))).header("Content-Type", "application/json").header("Accept", "text/event-stream").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textChatRequest))).timeout(Duration.ofMillis(timeout));
        if (Objects.nonNull(parameters.getTransactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.getTransactionId());
        }
        HashMap<String, Boolean> toolHasParameters = new HashMap<String, Boolean>();
        if (Objects.nonNull(tools)) {
            tools.stream().forEach(tool -> toolHasParameters.put(tool.function().name(), tool.hasParameters()));
        }
        Flow.Subscriber<String> subscriber = this.subscriber(textChatRequest.getToolChoiceOption(), toolHasParameters, chatRequest.getExtractionTags(), handler);
        return ((CompletableFuture)this.asyncHttpClient.send(httpRequest.build(), responseInfo -> this.logResponses ? HttpResponse.BodySubscribers.fromLineSubscriber((Flow.Subscriber<? super String>)new SseEventLogger(subscriber, responseInfo.statusCode(), responseInfo.headers())) : HttpResponse.BodySubscribers.fromLineSubscriber(subscriber)).thenAccept(r -> {})).exceptionally(t -> this.handlerError((Throwable)t, handler));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxService.ModelService.Builder<Builder> {
        public ChatService build() {
            return new ChatService(this);
        }
    }
}

