/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.util;

import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import java.util.Objects;
import java.util.Optional;

public class StreamingStateTracker {
    private final String THINKING_START_TAG;
    private final String THINKING_CLOSE_TAG;
    private final String RESPONSE_START_TAG;
    private final String RESPONSE_CLOSE_TAG;
    private final ExtractionTags extractionTags;
    private final StringBuilder tagBuffer = new StringBuilder();
    private final StringBuilder textBuffer = new StringBuilder();
    private State currentState = State.START;
    private TagParseState parseState = TagParseState.CONTENT;

    public StreamingStateTracker(ExtractionTags extractionTags) {
        Objects.requireNonNull(extractionTags, "extractionTags cannot be null");
        this.extractionTags = extractionTags;
        this.THINKING_START_TAG = "<" + extractionTags.think() + ">";
        this.THINKING_CLOSE_TAG = "</" + extractionTags.think() + ">";
        this.RESPONSE_START_TAG = "<" + extractionTags.response() + ">";
        this.RESPONSE_CLOSE_TAG = "</" + extractionTags.response() + ">";
    }

    public Result update(String chunk) {
        char[] chars;
        if (chunk.isEmpty()) {
            return new Result(this.currentState, Optional.empty());
        }
        chunk = this.decodeUnicodeSymbols(chunk);
        if (this.currentState == State.NO_THINKING) {
            return new Result(this.currentState, Optional.of(chunk));
        }
        block5: for (char c : chars = chunk.toCharArray()) {
            switch (this.parseState) {
                case CONTENT: {
                    if (c == '<') {
                        this.parseState = TagParseState.OPEN_TAG_START;
                        this.tagBuffer.setLength(0);
                        this.tagBuffer.append(c);
                        continue block5;
                    }
                    this.textBuffer.append(c);
                    continue block5;
                }
                case OPEN_TAG_START: {
                    if (c == '/') {
                        this.parseState = TagParseState.CLOSE_TAG_START;
                        this.tagBuffer.append(c);
                        continue block5;
                    }
                    this.parseState = TagParseState.TAG_NAME;
                    this.tagBuffer.append(c);
                    continue block5;
                }
                case CLOSE_TAG_START: 
                case TAG_NAME: {
                    boolean matchesAnyPrefix;
                    this.tagBuffer.append(c);
                    boolean bl = matchesAnyPrefix = this.THINKING_START_TAG.startsWith(this.tagBuffer.toString()) || this.THINKING_CLOSE_TAG.startsWith(this.tagBuffer.toString()) || this.RESPONSE_START_TAG.startsWith(this.tagBuffer.toString()) || this.RESPONSE_CLOSE_TAG.startsWith(this.tagBuffer.toString());
                    if (!matchesAnyPrefix) {
                        if (this.currentState == State.START) {
                            this.currentState = State.NO_THINKING;
                        }
                        this.parseState = TagParseState.CONTENT;
                        this.textBuffer.append((CharSequence)this.tagBuffer);
                        this.tagBuffer.setLength(0);
                        continue block5;
                    }
                    if (c != '>') continue block5;
                    this.handleCompleteTag(this.tagBuffer.toString());
                    this.tagBuffer.setLength(0);
                    this.parseState = TagParseState.CONTENT;
                }
            }
        }
        String partialTag = this.tagBuffer.toString();
        if (this.currentState == State.START && (partialTag.isEmpty() || partialTag.startsWith(this.THINKING_START_TAG))) {
            this.currentState = State.NO_THINKING;
        }
        String textOut = this.textBuffer.toString();
        this.textBuffer.setLength(0);
        return new Result(this.currentState, textOut.isEmpty() ? Optional.empty() : Optional.of(textOut));
    }

    private void handleCompleteTag(String tag) {
        if (tag.equals(this.THINKING_START_TAG)) {
            this.currentState = State.THINKING;
        } else if (tag.equals(this.THINKING_CLOSE_TAG)) {
            this.currentState = "root".equals(this.extractionTags.response()) ? State.RESPONSE : State.UNKNOWN;
        } else if (tag.equals(this.RESPONSE_START_TAG)) {
            this.currentState = State.RESPONSE;
        } else if (tag.equals(this.RESPONSE_CLOSE_TAG)) {
            this.currentState = State.UNKNOWN;
        }
    }

    private String decodeUnicodeSymbols(String s) {
        return s.replace("\\u003c", "<").replace("\\u003e", ">");
    }

    public static enum State {
        START,
        THINKING,
        RESPONSE,
        NO_THINKING,
        UNKNOWN;

    }

    private static enum TagParseState {
        CONTENT,
        OPEN_TAG_START,
        CLOSE_TAG_START,
        TAG_NAME;

    }

    public record Result(State state, Optional<String> content) {
    }
}

