/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.util;

import com.ibm.watsonx.ai.chat.model.ToolCall;
import java.util.Objects;
import java.util.UUID;

public final class StreamingToolFetcher {
    private int index;
    private StringBuilder arguments;
    private String id;
    private String name;

    public StreamingToolFetcher(int index) {
        this.index = index;
        this.arguments = new StringBuilder();
    }

    public void setId(String id) {
        if (Objects.nonNull(id) && !id.isEmpty()) {
            this.id = id;
        }
    }

    public void setName(String name) {
        if (Objects.nonNull(name) && !name.isEmpty()) {
            this.name = name;
        }
    }

    public void appendArguments(String arguments) {
        if (Objects.nonNull(arguments) && !arguments.isEmpty()) {
            this.arguments.append(arguments);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public ToolCall build() {
        if (Objects.isNull(this.id)) {
            this.id = UUID.randomUUID().toString();
        }
        return ToolCall.of(this.index, this.id, this.name, this.arguments.toString().isBlank() ? "{}" : this.arguments.toString());
    }

    public record PartialToolCall(int index, String id, String name, String arguments) {
    }
}

