/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.deployment;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.chat.ChatHandler;
import com.ibm.watsonx.ai.chat.ChatProvider;
import com.ibm.watsonx.ai.chat.ChatRequest;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.model.AssistantMessage;
import com.ibm.watsonx.ai.chat.model.ChatMessage;
import com.ibm.watsonx.ai.chat.model.ChatParameters;
import com.ibm.watsonx.ai.chat.model.TextChatRequest;
import com.ibm.watsonx.ai.chat.model.Tool;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.SseEventLogger;
import com.ibm.watsonx.ai.deployment.DeploymentResource;
import com.ibm.watsonx.ai.deployment.FindByIdParameters;
import com.ibm.watsonx.ai.textgeneration.Moderation;
import com.ibm.watsonx.ai.textgeneration.TextGenerationHandler;
import com.ibm.watsonx.ai.textgeneration.TextGenerationParameters;
import com.ibm.watsonx.ai.textgeneration.TextGenerationProvider;
import com.ibm.watsonx.ai.textgeneration.TextGenerationRequest;
import com.ibm.watsonx.ai.textgeneration.TextGenerationResponse;
import com.ibm.watsonx.ai.timeseries.ForecastData;
import com.ibm.watsonx.ai.timeseries.ForecastRequest;
import com.ibm.watsonx.ai.timeseries.ForecastResponse;
import com.ibm.watsonx.ai.timeseries.InputSchema;
import com.ibm.watsonx.ai.timeseries.TimeSeriesParameters;
import com.ibm.watsonx.ai.timeseries.TimeSeriesProvider;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentService
extends WatsonxService
implements ChatProvider,
TextGenerationProvider,
TimeSeriesProvider {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentService.class);
    private final String deployment;

    protected DeploymentService(Builder builder) {
        super(builder);
        this.deployment = Objects.requireNonNull(builder.deployment, "deployment cannot be null");
    }

    public DeploymentResource findById(FindByIdParameters parameters) {
        parameters = Objects.requireNonNullElse(parameters, FindByIdParameters.builder().build());
        String deploymentId = Objects.requireNonNullElse(parameters.getDeployment(), this.deployment);
        StringJoiner queryParameters = new StringJoiner("&", "?", "");
        if (Objects.nonNull(parameters.getProjectId())) {
            queryParameters.add("project_id=".concat(parameters.getProjectId()));
        }
        if (Objects.nonNull(parameters.getSpaceId())) {
            queryParameters.add("space_id=".concat(parameters.getSpaceId()));
        }
        if (queryParameters.length() == 1) {
            throw new IllegalArgumentException("Either projectId or spaceId must be provided");
        }
        queryParameters.add("version=".concat(this.version));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString() + "/ml/v4/deployments/%s%s".formatted(deploymentId, queryParameters.toString()))).header("Content-Type", "application/json").timeout(Duration.ofMillis(this.timeout.toMillis())).GET();
        if (Objects.nonNull(parameters.getTransactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.getTransactionId());
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (DeploymentResource)Json.fromJson((String)((String)httpReponse.body()), DeploymentResource.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TextGenerationResponse generate(String input, Moderation moderation, TextGenerationParameters parameters) {
        parameters = Objects.requireNonNullElse(parameters, TextGenerationParameters.builder().build());
        Long timeout = Objects.requireNonNullElse(parameters.getTimeLimit(), this.timeout.toMillis());
        parameters.setTimeLimit(timeout);
        this.logIgnoredParameters(parameters.getModelId(), parameters.getProjectId(), parameters.getSpaceId());
        TextGenerationRequest textGenerationRequest = new TextGenerationRequest(null, null, null, input, parameters.toSanitized(), moderation);
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString() + "%s/deployments/%s/text/generation?version=%s".formatted("/ml/v1", this.deployment, this.version))).header("Content-Type", "application/json").header("Accept", "application/json").timeout(Duration.ofMillis(timeout)).POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textGenerationRequest)));
        if (Objects.nonNull(parameters.getTransactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.getTransactionId());
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (TextGenerationResponse)Json.fromJson((String)((String)httpReponse.body()), TextGenerationResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<Void> generateStreaming(String input, TextGenerationParameters parameters, TextGenerationHandler handler) {
        parameters = Objects.requireNonNullElse(parameters, TextGenerationParameters.builder().build());
        Long timeout = Objects.requireNonNullElse(parameters.getTimeLimit(), this.timeout.toMillis());
        parameters.setTimeLimit(timeout);
        this.logIgnoredParameters(parameters.getModelId(), parameters.getProjectId(), parameters.getSpaceId());
        TextGenerationRequest textGenerationRequest = new TextGenerationRequest(null, null, null, input, parameters.toSanitized(), null);
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString() + "%s/deployments/%s/text/generation_stream?version=%s".formatted("/ml/v1", this.deployment, this.version))).header("Content-Type", "application/json").header("Accept", "text/event-stream").timeout(Duration.ofMillis(timeout)).POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textGenerationRequest)));
        if (Objects.nonNull(parameters.getTransactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.getTransactionId());
        }
        Flow.Subscriber<String> subscriber = this.subscriber(handler);
        return ((CompletableFuture)this.asyncHttpClient.send(httpRequest.build(), responseInfo -> this.logResponses ? HttpResponse.BodySubscribers.fromLineSubscriber((Flow.Subscriber<? super String>)new SseEventLogger(subscriber, responseInfo.statusCode(), responseInfo.headers())) : HttpResponse.BodySubscribers.fromLineSubscriber(subscriber)).thenAcceptAsync(r -> {}, this.asyncHttpClient.executor())).exceptionallyAsync(t -> this.handlerError((Throwable)t, handler), this.asyncHttpClient.executor());
    }

    @Override
    public ChatResponse chat(ChatRequest chatRequest) {
        List<ChatMessage> messages = chatRequest.getMessages();
        List<Tool> tools = Objects.nonNull(chatRequest.getTools()) && !chatRequest.getTools().isEmpty() ? chatRequest.getTools() : null;
        ChatParameters parameters = chatRequest.getParameters();
        parameters = Objects.requireNonNullElse(parameters, ChatParameters.builder().build());
        Long timeout = Objects.requireNonNullElse(parameters.getTimeLimit(), this.timeout.toMillis());
        this.logIgnoredParameters(parameters.getModelId(), parameters.getProjectId(), parameters.getSpaceId());
        TextChatRequest textChatRequest = TextChatRequest.builder().messages(messages).tools(tools).parameters(parameters).timeLimit(timeout).build();
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString() + "%s/deployments/%s/text/chat?version=%s".formatted("/ml/v1", this.deployment, this.version))).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textChatRequest))).timeout(Duration.ofMillis(timeout));
        if (Objects.nonNull(parameters.getTransactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.getTransactionId());
        }
        try {
            AssistantMessage assistantMessage;
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            ChatResponse chatResponse = (ChatResponse)Json.fromJson((String)((String)httpReponse.body()), ChatResponse.class);
            if (Objects.nonNull(parameters.getToolChoiceOption()) && parameters.getToolChoiceOption().equals(ChatParameters.ToolChoice.REQUIRED.type()) && Objects.nonNull((assistantMessage = chatResponse.toAssistantMessage()).toolCalls()) && !assistantMessage.toolCalls().isEmpty()) {
                chatResponse.getChoices().get(0).setFinishReason("tool_calls");
            }
            return chatResponse;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<Void> chatStreaming(ChatRequest chatRequest, ChatHandler handler) {
        List<ChatMessage> messages = chatRequest.getMessages();
        List<Tool> tools = Objects.nonNull(chatRequest.getTools()) && !chatRequest.getTools().isEmpty() ? chatRequest.getTools() : null;
        ChatParameters parameters = chatRequest.getParameters();
        Objects.requireNonNull(handler, "The chatHandler parameter can not be null");
        parameters = Objects.requireNonNullElse(parameters, ChatParameters.builder().build());
        Long timeout = Objects.requireNonNullElse(parameters.getTimeLimit(), this.timeout.toMillis());
        this.logIgnoredParameters(parameters.getModelId(), parameters.getProjectId(), parameters.getSpaceId());
        TextChatRequest textChatRequest = TextChatRequest.builder().messages(messages).tools(tools).parameters(parameters).timeLimit(timeout).build();
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString() + "%s/deployments/%s/text/chat_stream?version=%s".formatted("/ml/v1", this.deployment, this.version))).header("Content-Type", "application/json").header("Accept", "text/event-stream").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textChatRequest))).timeout(Duration.ofMillis(timeout));
        if (Objects.nonNull(parameters.getTransactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.getTransactionId());
        }
        HashMap<String, Boolean> toolHasParameters = new HashMap<String, Boolean>();
        if (Objects.nonNull(tools)) {
            tools.stream().forEach(tool -> toolHasParameters.put(tool.function().name(), tool.hasParameters()));
        }
        Flow.Subscriber<String> subscriber = this.subscriber(textChatRequest.getToolChoiceOption(), toolHasParameters, chatRequest.getExtractionTags(), handler);
        return ((CompletableFuture)this.asyncHttpClient.send(httpRequest.build(), responseInfo -> this.logResponses ? HttpResponse.BodySubscribers.fromLineSubscriber((Flow.Subscriber<? super String>)new SseEventLogger(subscriber, responseInfo.statusCode(), responseInfo.headers())) : HttpResponse.BodySubscribers.fromLineSubscriber(subscriber)).thenAcceptAsync(r -> {}, this.asyncHttpClient.executor())).exceptionallyAsync(t -> this.handlerError((Throwable)t, handler), this.asyncHttpClient.executor());
    }

    @Override
    public ForecastResponse forecast(InputSchema inputSchema, ForecastData data, TimeSeriesParameters parameters) {
        Objects.requireNonNull(inputSchema, "InputSchema cannot be null");
        Objects.requireNonNull(data, "Data cannot be null");
        ForecastRequest.Parameters requestParameters = null;
        Map futureData = null;
        String transactionId = null;
        if (Objects.nonNull(parameters)) {
            this.logIgnoredParameters(parameters.getModelId(), parameters.getProjectId(), parameters.getSpaceId());
            requestParameters = parameters.toParameters();
            futureData = Optional.ofNullable(parameters.getFutureData()).map(p -> p.asMap()).orElse(null);
            transactionId = parameters.getTransactionId();
        }
        ForecastRequest forecastRequest = new ForecastRequest(null, null, null, data.asMap(), inputSchema, futureData, requestParameters);
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString() + "%s/deployments/%s/time_series/forecast?version=%s".formatted("/ml/v1", this.deployment, this.version))).header("Content-Type", "application/json").header("Accept", "application/json").timeout(this.timeout).POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)forecastRequest)));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (ForecastResponse)Json.fromJson((String)((String)httpReponse.body()), ForecastResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private void logIgnoredParameters(String modelId, String projectId, String spaceId) {
        if (Objects.nonNull(modelId)) {
            logger.info("The modelId parameter is ignored for the deployment service");
        }
        if (Objects.nonNull(projectId)) {
            logger.info("The projectId parameter is ignored for the deployment service");
        }
        if (Objects.nonNull(spaceId)) {
            logger.info("The spaceId parameter is ignored for the deployment service");
        }
    }

    public static class Builder
    extends WatsonxService.Builder<Builder> {
        private String deployment;

        public Builder deployment(String deployment) {
            this.deployment = deployment;
            return this;
        }

        public DeploymentService build() {
            return new DeploymentService(this);
        }
    }
}

