/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.embedding;

import com.ibm.watsonx.ai.WatsonxParameters;
import com.ibm.watsonx.ai.embedding.EmbeddingRequest;
import java.util.Objects;

public final class EmbeddingParameters
extends WatsonxParameters.WatsonxModelParameters {
    private final Integer truncateInputTokens;
    private final Boolean inputText;

    public EmbeddingParameters(Builder builder) {
        super(builder);
        this.truncateInputTokens = builder.truncateInputTokens;
        this.inputText = builder.inputText;
    }

    public Integer getTruncateInputTokens() {
        return this.truncateInputTokens;
    }

    public Boolean getInputText() {
        return this.inputText;
    }

    protected EmbeddingRequest.Parameters toEmbeddingRequestParameters() {
        EmbeddingRequest.Parameters parameters = null;
        EmbeddingRequest.ReturnOptions returnOptions = null;
        if (Objects.nonNull(this.inputText)) {
            returnOptions = new EmbeddingRequest.ReturnOptions(this.inputText);
        }
        if (Objects.nonNull(this.truncateInputTokens) || Objects.nonNull(returnOptions)) {
            parameters = new EmbeddingRequest.Parameters(this.truncateInputTokens, returnOptions);
        }
        return parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WatsonxParameters.WatsonxModelParameters.Builder<Builder> {
        private Integer truncateInputTokens;
        private Boolean inputText;

        public Builder truncateInputTokens(Integer truncateInputTokens) {
            this.truncateInputTokens = truncateInputTokens;
            return this;
        }

        public Builder inputText(Boolean inputText) {
            this.inputText = inputText;
            return this;
        }

        public EmbeddingParameters build() {
            return new EmbeddingParameters(this);
        }
    }
}

