/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.embedding;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.embedding.EmbeddingParameters;
import com.ibm.watsonx.ai.embedding.EmbeddingRequest;
import com.ibm.watsonx.ai.embedding.EmbeddingResponse;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class EmbeddingService
extends WatsonxService.ModelService {
    private static final int MAX_SIZE = 1000;

    protected EmbeddingService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.getAuthenticationProvider(), "authenticationProvider cannot be null");
    }

    public EmbeddingResponse embedding(String ... inputs) {
        return this.embedding(Arrays.asList(inputs));
    }

    public EmbeddingResponse embedding(List<String> inputs) {
        return this.embedding(inputs, null);
    }

    public EmbeddingResponse embedding(List<String> inputs, EmbeddingParameters parameters) {
        Objects.requireNonNull(inputs, "Inputs cannot be null");
        String modelId = this.modelId;
        String projectId = this.projectId;
        String spaceId = this.spaceId;
        String transactionId = null;
        EmbeddingRequest.Parameters requestParameters = null;
        if (Objects.nonNull(parameters)) {
            modelId = Objects.requireNonNullElse(parameters.getModelId(), this.modelId);
            projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
            spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
            transactionId = parameters.getTransactionId();
            requestParameters = parameters.toEmbeddingRequestParameters();
        }
        int inputTokenCount = 0;
        String createdAt = null;
        ArrayList<EmbeddingResponse.Result> results = new ArrayList<EmbeddingResponse.Result>();
        for (int fromIndex = 0; fromIndex < inputs.size(); fromIndex += 1000) {
            int toIndex = Math.min(fromIndex + 1000, inputs.size());
            List<String> subList = inputs.subList(fromIndex, toIndex);
            EmbeddingRequest embeddingRequest = new EmbeddingRequest(modelId, spaceId, projectId, subList, requestParameters);
            HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString() + "%s/embeddings?version=%s".formatted(ML_API_TEXT_PATH, this.version))).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)embeddingRequest))).timeout(this.timeout);
            if (Objects.nonNull(transactionId)) {
                httpRequest.header("X-Global-Transaction-Id", transactionId);
            }
            try {
                HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
                EmbeddingResponse response = (EmbeddingResponse)Json.fromJson((String)((String)httpReponse.body()), EmbeddingResponse.class);
                results.addAll(response.results());
                inputTokenCount += response.inputTokenCount().intValue();
                createdAt = response.createdAt();
                continue;
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return new EmbeddingResponse(modelId, createdAt, results, inputTokenCount);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxService.ModelService.Builder<Builder> {
        public EmbeddingService build() {
            return new EmbeddingService(this);
        }
    }
}

