/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textextraction;

import com.ibm.watsonx.ai.WatsonxParameters;
import com.ibm.watsonx.ai.textextraction.CosReference;
import com.ibm.watsonx.ai.textextraction.TextExtractionRequest;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public final class TextExtractionParameters
extends WatsonxParameters {
    private final String cosUrl;
    private final List<String> requestedOutputs;
    private final String mode;
    private final String ocrMode;
    private final List<String> languages;
    private final Boolean autoRotationCorrection;
    private final String createEmbeddedImages;
    private final Integer outputDpi;
    private final Boolean outputTokensAndBbox;
    private final String kvpMode;
    private final TextExtractionRequest.SemanticConfig semanticConfig;
    private final boolean removeUploadedFile;
    private final boolean removeOutputFile;
    private final String outputFileName;
    private final CosReference documentReference;
    private final CosReference resultReference;
    private final Map<String, Object> custom;
    private final Duration timeout;

    public TextExtractionParameters(Builder builder) {
        super(builder);
        this.cosUrl = builder.cosUrl;
        this.requestedOutputs = Objects.requireNonNullElse(builder.requestedOutputs, List.of("plain_text"));
        this.mode = builder.mode;
        this.ocrMode = builder.ocrMode;
        this.languages = builder.languages;
        this.autoRotationCorrection = builder.autoRotationCorrection;
        this.createEmbeddedImages = builder.createEmbeddedImages;
        this.outputDpi = builder.outputDpi;
        this.outputTokensAndBbox = builder.outputTokensAndBbox;
        this.kvpMode = builder.kvpMode;
        this.semanticConfig = builder.semanticConfig;
        this.removeUploadedFile = builder.removeUploadedFile;
        this.removeOutputFile = builder.removeOutputFile;
        this.outputFileName = builder.outputFileName;
        this.documentReference = builder.documentReference;
        this.resultReference = builder.resultReference;
        this.custom = builder.custom;
        this.timeout = Objects.requireNonNullElse(builder.timeout, Duration.ofSeconds(30L));
    }

    public List<String> getRequestedOutputs() {
        return this.requestedOutputs;
    }

    public String getMode() {
        return this.mode;
    }

    public String getOcrMode() {
        return this.ocrMode;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public Boolean getAutoRotationCorrection() {
        return this.autoRotationCorrection;
    }

    public String getCreateEmbeddedImages() {
        return this.createEmbeddedImages;
    }

    public Integer getOutputDpi() {
        return this.outputDpi;
    }

    public Boolean getOutputTokensAndBbox() {
        return this.outputTokensAndBbox;
    }

    public String getKvpMode() {
        return this.kvpMode;
    }

    public TextExtractionRequest.SemanticConfig getSemanticConfig() {
        return this.semanticConfig;
    }

    public boolean isRemoveUploadedFile() {
        return this.removeUploadedFile;
    }

    public boolean isRemoveOutputFile() {
        return this.removeOutputFile;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public CosReference getDocumentReference() {
        return this.documentReference;
    }

    public CosReference getResultReference() {
        return this.resultReference;
    }

    public Map<String, Object> getCustom() {
        return this.custom;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public String getCosUrl() {
        return this.cosUrl;
    }

    public TextExtractionRequest.Parameters toParameters() {
        return new TextExtractionRequest.Parameters(this.getRequestedOutputs(), this.getMode(), this.getOcrMode(), this.getLanguages(), this.getAutoRotationCorrection(), this.getCreateEmbeddedImages(), this.getOutputDpi(), this.getOutputTokensAndBbox(), this.getKvpMode(), this.getSemanticConfig());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxParameters.Builder<Builder> {
        private String cosUrl;
        private List<String> requestedOutputs;
        private String mode;
        private String ocrMode;
        private List<String> languages;
        private Boolean autoRotationCorrection;
        private String createEmbeddedImages;
        private Integer outputDpi;
        private Boolean outputTokensAndBbox;
        private String kvpMode;
        private TextExtractionRequest.SemanticConfig semanticConfig;
        private boolean removeUploadedFile = false;
        private boolean removeOutputFile = false;
        private String outputFileName;
        private CosReference documentReference;
        private CosReference resultReference;
        private Map<String, Object> custom;
        private Duration timeout;

        public Builder cosUrl(String cosUrl) {
            this.cosUrl = cosUrl;
            return this;
        }

        public Builder cosUrl(CosUrl cosUrl) {
            Objects.requireNonNull(cosUrl, "cosUrl cannot be null");
            return this.cosUrl(cosUrl.value());
        }

        public Builder requestedOutputs(List<Type> types) {
            this.requestedOutputs = types.stream().map(Type::value).toList();
            return this;
        }

        public Builder requestedOutputs(Type ... types) {
            return this.requestedOutputs(Arrays.asList(types));
        }

        public Builder mode(Mode mode) {
            this.mode = mode.value();
            return this;
        }

        public Builder ocrMode(OcrMode ocrMode) {
            this.ocrMode = switch (ocrMode) {
                case OcrMode.AUTO -> null;
                default -> ocrMode.value();
            };
            return this;
        }

        public Builder languages(List<String> languages) {
            this.languages = languages;
            return this;
        }

        public Builder languages(String ... languages) {
            return this.languages(Arrays.asList(languages));
        }

        public Builder languages(Language ... languages) {
            return this.languages(Stream.of(languages).map(Language::isoCode).toList());
        }

        public Builder autoRotationCorrection(boolean autoRotationCorrection) {
            this.autoRotationCorrection = autoRotationCorrection;
            return this;
        }

        public Builder createEmbeddedImages(EmbeddedImageMode embeddedImageMode) {
            Objects.requireNonNull(embeddedImageMode, "embeddedImageMode cannot be null");
            this.createEmbeddedImages = embeddedImageMode.value();
            return this;
        }

        public Builder outputDpi(int outputDpi) {
            this.outputDpi = outputDpi;
            return this;
        }

        public Builder outputTokensAndBbox(boolean outputTokensAndBbox) {
            this.outputTokensAndBbox = outputTokensAndBbox;
            return this;
        }

        public Builder kvpMode(KvpMode kvpMode) {
            Objects.requireNonNull(kvpMode, "kvpMode cannot be null");
            this.kvpMode = kvpMode.value();
            return this;
        }

        public Builder semanticConfig(TextExtractionRequest.SemanticConfig semanticConfig) {
            this.semanticConfig = semanticConfig;
            return this;
        }

        public Builder semanticConfig(TextExtractionRequest.SemanticConfig.Builder semanticConfig) {
            Objects.requireNonNull(semanticConfig, "semanticConfig cannot be null");
            return this.semanticConfig(semanticConfig.build());
        }

        public Builder removeUploadedFile(boolean removeUploadedFile) {
            this.removeUploadedFile = removeUploadedFile;
            return this;
        }

        public Builder removeOutputFile(boolean removeOutputFile) {
            this.removeOutputFile = removeOutputFile;
            return this;
        }

        public Builder outputFileName(String outputFileName) {
            this.outputFileName = outputFileName;
            return this;
        }

        public Builder documentReference(CosReference documentReference) {
            this.documentReference = documentReference;
            return this;
        }

        public Builder resultReference(CosReference resultReference) {
            this.resultReference = resultReference;
            return this;
        }

        public Builder addCustomProperty(String key, Object value) {
            this.custom = Objects.requireNonNullElse(this.custom, new HashMap());
            this.custom.put(key, value);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public TextExtractionParameters build() {
            return new TextExtractionParameters(this);
        }
    }

    public static enum Language {
        AFRIKAANS("af"),
        ALBANIAN("sq"),
        AYMARA("ay"),
        BASQUE("eu"),
        BELARUSIAN("be"),
        BISLAMA("bi"),
        BULGARIAN("bg"),
        CATALAN("ca"),
        CREE("cr"),
        DANISH("da"),
        DUTCH("nl"),
        ENGLISH("en"),
        ESTONIAN("et"),
        FIJIAN("fj"),
        FILIPINO("fil"),
        FINNISH("fi"),
        FRENCH("fr"),
        GALICIAN("gl"),
        GERMAN("de"),
        GREEK("el"),
        HAITIAN_CREOLE("ht"),
        HEBREW("he"),
        HINDI("hi"),
        INDONESIAN("id"),
        IRISH("ga"),
        ITALIAN("it"),
        JAPANESE("ja"),
        JAVANESE("jv"),
        KALAALLISUT("kl"),
        KINYARWANDA("rw"),
        KONGO("kg"),
        KOREAN("ko"),
        KUANYAMA("kj"),
        LATIN("la"),
        MALAGASY("mg"),
        MANX("gv"),
        MARATHI("mr"),
        MACEDONIAN("mk"),
        NDONGA("ng"),
        NEPALI("ne"),
        NORTH_NDEBELE("nd"),
        NORWEGIAN("no"),
        OCCITAN("oc"),
        OJIBWA("oj"),
        POLISH("pl"),
        PORTUGUESE("pt"),
        QUECHUA("qu"),
        ROMANSH("rm"),
        RUNDI("rn"),
        RUSSIAN("ru"),
        SANGO("sg"),
        SANSKRIT("sa"),
        SERBIAN("sr"),
        SHONA("sn"),
        SPANISH("es"),
        SUNDANESE("su"),
        SWAHILI("sw"),
        SWATI("ss"),
        SWEDISH("sv"),
        TAMIL("ta"),
        TELUGU("te"),
        TSONGA("ts"),
        TSWANA("tn"),
        UKRAINIAN("uk"),
        UZBEK("uz"),
        XHOSA("xh"),
        ZULU("zu");

        private final String isoCode;

        private Language(String isoCode) {
            this.isoCode = isoCode;
        }

        public String isoCode() {
            return this.isoCode;
        }
    }

    public static enum CosUrl {
        US_SOUTH("https://s3.us-south.cloud-object-storage.appdomain.cloud"),
        US_EAST("https://s3.us-east.cloud-object-storage.appdomain.cloud"),
        EU_GB("https://s3.eu-gb.cloud-object-storage.appdomain.cloud"),
        EU_DE("https://s3.eu-de.cloud-object-storage.appdomain.cloud"),
        AU_SYD("https://s3.au-syd.cloud-object-storage.appdomain.cloud"),
        JP_TOK("https://s3.jp-tok.cloud-object-storage.appdomain.cloud"),
        JP_OSA("https://s3.jp-osa.cloud-object-storage.appdomain.cloud"),
        CA_TOR("https://s3.ca-tor.cloud-object-storage.appdomain.cloud"),
        BR_SAO("https://s3.br-sao.cloud-object-storage.appdomain.cloud"),
        EU_ES("https://s3.eu-es.cloud-object-storage.appdomain.cloud"),
        CA_MON("https://s3.ca-mon.cloud-object-storage.appdomain.cloud");

        private final String url;

        private CosUrl(String url) {
            this.url = url;
        }

        public String value() {
            return this.url;
        }
    }

    public static enum KvpMode {
        DISABLED("disabled"),
        INVOICE("invoice"),
        UBILL("ubill"),
        GENERIC_WITH_SEMANTIC("generic_with_semantic");

        private final String value;

        private KvpMode(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum EmbeddedImageMode {
        DISABLED("disabled"),
        ENABLED_PLACEHOLDER("enabled_placeholder"),
        ENABLED_TEXT("enabled_text"),
        ENABLED_VERBALIZATION("enabled_verbalization"),
        ENABLED_VERBALIZATION_ALL("enabled_verbalization_all");

        private final String value;

        private EmbeddedImageMode(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum OcrMode {
        DISABLED("disabled"),
        ENABLED("enabled"),
        FORCED("forced"),
        AUTO("");

        private final String value;

        private OcrMode(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum Mode {
        STANDARD("standard"),
        HIGH_QUALITY("high_quality");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum Type {
        JSON("assembly"),
        HTML("html"),
        MD("md"),
        PLAIN_TEXT("plain_text"),
        PAGE_IMAGES("page_images");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static Type fromValue(String value) {
            return Stream.of(Type.values()).filter(status -> status.value.equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown Type value: " + value));
        }
    }
}

