/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textextraction;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.exeception.WatsonxException;
import com.ibm.watsonx.ai.textextraction.CosReference;
import com.ibm.watsonx.ai.textextraction.TextExtractionDeleteParameters;
import com.ibm.watsonx.ai.textextraction.TextExtractionException;
import com.ibm.watsonx.ai.textextraction.TextExtractionFetchParameters;
import com.ibm.watsonx.ai.textextraction.TextExtractionParameters;
import com.ibm.watsonx.ai.textextraction.TextExtractionRequest;
import com.ibm.watsonx.ai.textextraction.TextExtractionResponse;
import com.ibm.watsonx.ai.textextraction.TextExtractionUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TextExtractionService
extends WatsonxService.ProjectService {
    private static final Logger logger = LoggerFactory.getLogger(TextExtractionService.class);
    private final String cosUrl;
    private final CosReference documentReference;
    private final CosReference resultReference;

    protected TextExtractionService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.getAuthenticationProvider(), "authenticationProvider cannot be null");
        String tmpUrl = Objects.requireNonNull(builder.cosUrl, "cosUrl value cannot be null");
        this.cosUrl = tmpUrl.endsWith("/") ? tmpUrl.substring(0, tmpUrl.length() - 1) : tmpUrl;
        this.documentReference = Objects.requireNonNull(builder.documentReference, "documentReference value cannot be null");
        this.resultReference = Objects.requireNonNull(builder.resultReference, "resultReference value cannot be null");
    }

    public TextExtractionResponse startExtraction(String absolutePath) throws TextExtractionException {
        return this.startExtraction(absolutePath, null);
    }

    public TextExtractionResponse startExtraction(String absolutePath, TextExtractionParameters parameters) throws TextExtractionException {
        return this.startExtraction(absolutePath, parameters, false);
    }

    public TextExtractionResponse uploadAndStartExtraction(File file) throws TextExtractionException {
        return this.uploadAndStartExtraction(file, null);
    }

    public TextExtractionResponse uploadAndStartExtraction(File file, TextExtractionParameters parameters) throws TextExtractionException {
        Objects.requireNonNull(file);
        if (file.isDirectory()) {
            throw new TextExtractionException("directory_not_allowed", "The file can not be a directory");
        }
        try {
            this.upload(new BufferedInputStream(new FileInputStream(file)), file.getName(), parameters, false);
            return this.startExtraction(file.getName(), parameters);
        }
        catch (FileNotFoundException e) {
            throw new TextExtractionException("file_not_found", e.getMessage(), e);
        }
    }

    public TextExtractionResponse uploadAndStartExtraction(InputStream is, String fileName) throws TextExtractionException {
        return this.uploadAndStartExtraction(is, fileName, null);
    }

    public TextExtractionResponse uploadAndStartExtraction(InputStream is, String fileName, TextExtractionParameters parameters) throws TextExtractionException {
        this.upload(is, fileName, parameters, false);
        return this.startExtraction(fileName, parameters);
    }

    public String extractAndFetch(String absolutePath) throws TextExtractionException {
        return this.extractAndFetch(absolutePath, null);
    }

    public String extractAndFetch(String absolutePath, TextExtractionParameters parameters) throws TextExtractionException {
        if (Objects.nonNull(parameters)) {
            if (parameters.getRequestedOutputs().size() > 1) {
                throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed if more than one file is to be generated");
            }
            if (parameters.getRequestedOutputs().size() == 1 && parameters.getRequestedOutputs().get(0).equals(TextExtractionParameters.Type.PAGE_IMAGES.value())) {
                throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed for the type \"page_images\"");
            }
        }
        TextExtractionResponse textExtractionResponse = this.startExtraction(absolutePath, parameters, true);
        InputStream is = this.getExtractedText(textExtractionResponse, parameters);
        try {
            return new String(is.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new TextExtractionException("fetch_operation_failed", "Failed to fetch the extracted text", e);
        }
    }

    public String uploadExtractAndFetch(File file) throws TextExtractionException {
        return this.uploadExtractAndFetch(file, null);
    }

    public String uploadExtractAndFetch(File file, TextExtractionParameters parameters) throws TextExtractionException {
        if (Objects.nonNull(parameters)) {
            if (parameters.getRequestedOutputs().size() > 1) {
                throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed if more than one file is to be generated");
            }
            if (parameters.getRequestedOutputs().size() == 1 && parameters.getRequestedOutputs().get(0).equals(TextExtractionParameters.Type.PAGE_IMAGES.value())) {
                throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed for the type \"page_images\"");
            }
        }
        try {
            this.upload(new BufferedInputStream(new FileInputStream(file)), file.getName(), parameters, true);
        }
        catch (FileNotFoundException e) {
            throw new TextExtractionException("file_not_found", e.getMessage(), e);
        }
        return this.extractAndFetch(file.getName(), parameters);
    }

    public String uploadExtractAndFetch(InputStream is, String fileName) throws TextExtractionException {
        return this.uploadExtractAndFetch(is, fileName, null);
    }

    public String uploadExtractAndFetch(InputStream is, String fileName, TextExtractionParameters parameters) throws TextExtractionException {
        if (Objects.nonNull(parameters)) {
            if (parameters.getRequestedOutputs().size() > 1) {
                throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed if more than one file is to be generated");
            }
            if (parameters.getRequestedOutputs().size() == 1 && parameters.getRequestedOutputs().get(0).equals(TextExtractionParameters.Type.PAGE_IMAGES.value())) {
                throw new TextExtractionException("fetch_operation_not_allowed", "The fetch operation cannot be executed for the type \"page_images\"");
            }
        }
        this.upload(is, fileName, parameters, true);
        return this.extractAndFetch(fileName, parameters);
    }

    public TextExtractionResponse fetchExtractionRequest(String id) {
        return this.fetchExtractionRequest(id, TextExtractionFetchParameters.builder().build());
    }

    public TextExtractionResponse fetchExtractionRequest(String id, TextExtractionFetchParameters parameters) {
        Objects.requireNonNull(id, "The id can not be null");
        String projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
        String spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
        String queryParameters = this.getQueryParameters(projectId, spaceId);
        URI uri = URI.create(this.url.toString() + "%s/extractions/%s?%s".formatted(ML_API_TEXT_PATH, id, queryParameters));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(uri).header("Accept", "application/json").timeout(this.timeout).GET();
        if (Objects.nonNull(parameters.getTransactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.getTransactionId());
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (TextExtractionResponse)Json.fromJson((String)((String)httpReponse.body()), TextExtractionResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean deleteFile(String bucketName, String fileName) {
        try {
            String encodedFileName = new URI(null, null, fileName, null).toASCIIString();
            URI uri = URI.create(this.cosUrl + "/%s/%s".formatted(bucketName, encodedFileName));
            HttpRequest httpRequest = HttpRequest.newBuilder(uri).DELETE().timeout(this.timeout).build();
            HttpResponse response = this.syncHttpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            return response.statusCode() == 204;
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String readFile(String bucketName, String fileName) {
        try {
            String encodedFileName = new URI(null, null, fileName, null).toASCIIString();
            URI uri = URI.create(this.cosUrl + "/%s/%s".formatted(bucketName, encodedFileName));
            HttpRequest httpRequest = HttpRequest.newBuilder(uri).GET().timeout(this.timeout).build();
            return (String)this.syncHttpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString()).body();
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean deleteRequest(String id) {
        return this.deleteRequest(id, TextExtractionDeleteParameters.builder().build());
    }

    public boolean deleteRequest(String id, TextExtractionDeleteParameters parameters) {
        Objects.requireNonNull(id, "The id can not be null");
        String projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
        String spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
        String queryParameters = parameters.getHardDelete().map(nullable -> this.getQueryParameters(projectId, spaceId).concat("&hard_delete=true")).orElse(this.getQueryParameters(projectId, spaceId));
        URI uri = URI.create(this.url.toString() + "%s/extractions/%s?%s".formatted(ML_API_TEXT_PATH, id, queryParameters));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(uri).timeout(this.timeout).DELETE();
        if (Objects.nonNull(parameters.getTransactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.getTransactionId());
        }
        try {
            this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return true;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (WatsonxException e) {
            if (e.statusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    private String getQueryParameters(String projectId, String spaceId) {
        if (Objects.nonNull(projectId)) {
            return "version=%s&project_id=%s".formatted(this.version, URLEncoder.encode(projectId, Charset.defaultCharset()));
        }
        return "version=%s&space_id=%s".formatted(this.version, URLEncoder.encode(spaceId, Charset.defaultCharset()));
    }

    private void upload(InputStream is, String fileName, TextExtractionParameters parameters, boolean waitForExtraction) {
        Objects.requireNonNull(is, "is value cannot be null");
        Objects.requireNonNull(fileName, "fileName value cannot be null");
        boolean removeOutputFile = false;
        boolean removeUploadedFile = false;
        CosReference documentReference = this.documentReference;
        if (Objects.nonNull(parameters)) {
            removeOutputFile = parameters.isRemoveOutputFile();
            removeUploadedFile = parameters.isRemoveUploadedFile();
            documentReference = Objects.requireNonNullElse(parameters.getDocumentReference(), this.documentReference);
        }
        if (!waitForExtraction && (removeOutputFile || removeUploadedFile)) {
            throw new IllegalArgumentException("The asynchronous version of startExtraction doesn't allow the use of the \"removeOutputFile\" and \"removeUploadedFile\" parameters");
        }
        try {
            String encodedFileName = new URI(null, null, fileName, null).toASCIIString();
            URI uri = URI.create(this.cosUrl + "/%s/%s".formatted(documentReference.bucket(), encodedFileName));
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(uri.toASCIIString())).PUT(HttpRequest.BodyPublishers.ofInputStream(() -> is)).timeout(this.timeout).build();
            this.syncHttpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private TextExtractionResponse startExtraction(String path, TextExtractionParameters parameters, boolean waitUntilJobIsDone) throws TextExtractionException {
        Objects.requireNonNull(path);
        String outputFileName = null;
        String projectId = this.projectId;
        String spaceId = this.spaceId;
        boolean removeOutputFile = false;
        boolean removeUploadedFile = false;
        List<String> requestedOutputs = List.of("plain_text");
        CosReference documentReference = this.documentReference;
        CosReference resultReference = this.resultReference;
        TextExtractionRequest.Parameters params = null;
        Map<String, Object> custom = null;
        Duration timeout = Duration.ofSeconds(60L);
        String transactionId = null;
        if (Objects.nonNull(parameters)) {
            removeOutputFile = parameters.isRemoveOutputFile();
            removeUploadedFile = parameters.isRemoveUploadedFile();
            outputFileName = parameters.getOutputFileName();
            projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
            spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
            requestedOutputs = Objects.requireNonNullElse(parameters.getRequestedOutputs(), requestedOutputs);
            documentReference = Objects.requireNonNullElse(parameters.getDocumentReference(), this.documentReference);
            resultReference = Objects.requireNonNullElse(parameters.getResultReference(), this.resultReference);
            params = parameters.toParameters();
            custom = parameters.getCustom();
            timeout = Objects.requireNonNullElse(parameters.getTimeout(), Duration.ofSeconds(60L));
            transactionId = parameters.getTransactionId();
        }
        if (!waitUntilJobIsDone && (removeOutputFile || removeUploadedFile)) {
            throw new IllegalArgumentException("The asynchronous version of startExtraction doesn't allow the use of the \"removeOutputFile\" and \"removeUploadedFile\" parameters");
        }
        if (Objects.isNull(outputFileName)) {
            boolean isMultiOutput;
            boolean bl = isMultiOutput = requestedOutputs.size() > 1 || requestedOutputs.get(0).equals(TextExtractionParameters.Type.PAGE_IMAGES.value());
            if (isMultiOutput) {
                outputFileName = "/";
            } else {
                TextExtractionParameters.Type type = TextExtractionParameters.Type.fromValue(requestedOutputs.get(0));
                outputFileName = TextExtractionUtils.addExtension(path, type);
            }
        }
        TextExtractionRequest request = new TextExtractionRequest(projectId, spaceId, documentReference.toDataReference(path), resultReference.toDataReference(outputFileName), params, custom);
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString() + "%s/extractions?version=%s".formatted(ML_API_TEXT_PATH, this.version))).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)request))).timeout(timeout);
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            TextExtractionResponse.Status status;
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            TextExtractionResponse response = (TextExtractionResponse)Json.fromJson((String)((String)httpReponse.body()), TextExtractionResponse.class);
            if (!waitUntilJobIsDone) {
                return response;
            }
            long sleepTime = 100L;
            LocalTime endTime = LocalTime.now().plus(timeout);
            do {
                if (LocalTime.now().isAfter(endTime)) {
                    throw new TextExtractionException("timeout", "Execution to extract %s file took longer than the timeout set by %s milliseconds".formatted(path, timeout.toMillis()));
                }
                try {
                    Thread.sleep(sleepTime);
                    sleepTime *= 2L;
                    sleepTime = Math.min(sleepTime, 3000L);
                }
                catch (Exception e) {
                    throw new TextExtractionException("interrupted", e.getMessage());
                }
                String processId = response.metadata().id();
                response = this.fetchExtractionRequest(processId, ((TextExtractionFetchParameters.Builder)((TextExtractionFetchParameters.Builder)TextExtractionFetchParameters.builder().projectId(projectId)).spaceId(spaceId)).build());
                status = TextExtractionResponse.Status.fromValue(response.entity().results().status());
                int pagesProcessed = response.entity().results().numberPagesProcessed();
                logger.debug("Extraction status: {} for the file {} (pages processed {})", new Object[]{status, path, pagesProcessed});
            } while (status != TextExtractionResponse.Status.FAILED && status != TextExtractionResponse.Status.COMPLETED);
            return response;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getExtractedText(TextExtractionResponse textExtractionResponse, TextExtractionParameters parameters) throws TextExtractionException {
        InputStream inputStream;
        block17: {
            Object httpRequest;
            URI uri;
            String encodedFileName;
            String cosUrl = this.cosUrl;
            String uploadedPath = textExtractionResponse.entity().documentReference().location().fileName();
            String outputPath = textExtractionResponse.entity().resultsReference().location().fileName();
            TextExtractionResponse.Status status = TextExtractionResponse.Status.fromValue(textExtractionResponse.entity().results().status());
            boolean removeUploadedFile = false;
            boolean removeOutputFile = false;
            CosReference documentReference = this.documentReference;
            CosReference resultsReference = this.resultReference;
            if (Objects.nonNull(parameters)) {
                cosUrl = Objects.requireNonNullElse(parameters.getCosUrl(), this.cosUrl);
                removeUploadedFile = parameters.isRemoveUploadedFile();
                removeOutputFile = parameters.isRemoveOutputFile();
                documentReference = Objects.requireNonNullElse(parameters.getDocumentReference(), this.documentReference);
                resultsReference = Objects.requireNonNullElse(parameters.getDocumentReference(), this.resultReference);
            }
            String documentBucketName = documentReference.bucket();
            String resultsBucketName = resultsReference.bucket();
            try {
                switch (status) {
                    case COMPLETED: {
                        try {
                            encodedFileName = new URI(null, null, outputPath, null).toASCIIString();
                            uri = URI.create(cosUrl + "/%s/%s".formatted(resultsBucketName, encodedFileName));
                            httpRequest = HttpRequest.newBuilder().uri(URI.create(uri.toASCIIString())).timeout(this.timeout).GET().build();
                            inputStream = (InputStream)this.syncHttpClient.send((HttpRequest)httpRequest, HttpResponse.BodyHandlers.ofInputStream()).body();
                            break;
                        }
                        catch (IOException | InterruptedException | URISyntaxException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case FAILED: {
                        TextExtractionResponse.Error error = textExtractionResponse.entity().results().error();
                        throw new TextExtractionException(error.code(), error.message());
                    }
                    default: {
                        throw new TextExtractionException("generic_error", "Status %s not managed".formatted(new Object[]{status}));
                    }
                }
                InputStream extractedFile = inputStream;
                if (removeOutputFile) {
                    try {
                        String encodedFileName2 = new URI(null, null, outputPath, null).toASCIIString();
                        URI uri2 = URI.create(cosUrl + "/%s/%s".formatted(resultsBucketName, encodedFileName2));
                        HttpRequest.Builder httpRequest2 = HttpRequest.newBuilder(URI.create(uri2.toASCIIString())).timeout(this.timeout).DELETE();
                        this.asyncHttpClient.send(httpRequest2.build(), HttpResponse.BodyHandlers.ofString());
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
                inputStream = extractedFile;
                if (!removeUploadedFile) break block17;
            }
            catch (Throwable throwable) {
                if (removeUploadedFile) {
                    try {
                        String encodedFileName3 = new URI(null, null, uploadedPath, null).toASCIIString();
                        URI uri3 = URI.create(cosUrl + "/%s/%s".formatted(documentBucketName, encodedFileName3));
                        HttpRequest.Builder httpRequest3 = HttpRequest.newBuilder(URI.create(uri3.toASCIIString())).timeout(this.timeout).DELETE();
                        this.asyncHttpClient.send(httpRequest3.build(), HttpResponse.BodyHandlers.ofString());
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
                throw throwable;
            }
            try {
                encodedFileName = new URI(null, null, uploadedPath, null).toASCIIString();
                uri = URI.create(cosUrl + "/%s/%s".formatted(documentBucketName, encodedFileName));
                httpRequest = HttpRequest.newBuilder(URI.create(uri.toASCIIString())).timeout(this.timeout).DELETE();
                this.asyncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return inputStream;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxService.ProjectService.Builder<Builder> {
        private String cosUrl;
        private CosReference documentReference;
        private CosReference resultReference;

        public Builder cosUrl(String cosUrl) {
            this.cosUrl = cosUrl;
            return this;
        }

        public Builder cosUrl(TextExtractionParameters.CosUrl cosUrl) {
            Objects.requireNonNull(cosUrl, "cosUrl cannot be null");
            return this.cosUrl(cosUrl.value());
        }

        public Builder documentReference(CosReference documentReference) {
            this.documentReference = documentReference;
            return this;
        }

        public Builder documentReference(String connectionId, String bucket) {
            return this.documentReference(CosReference.of(connectionId, bucket));
        }

        public Builder resultReference(CosReference resultReference) {
            this.resultReference = resultReference;
            return this;
        }

        public Builder resultReference(String connectionId, String bucket) {
            return this.resultReference(CosReference.of(connectionId, bucket));
        }

        public TextExtractionService build() {
            return new TextExtractionService(this);
        }
    }
}

