/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textgeneration;

import java.util.List;

public final class Moderation {
    private final Hap hap;
    private final Pii pii;
    private final GraniteGuardian graniteGuardian;
    private final List<InputRanges> inputRanges;

    public Moderation(Builder builder) {
        this.hap = builder.hap;
        this.pii = builder.pii;
        this.graniteGuardian = builder.graniteGuardian;
        this.inputRanges = builder.inputRanges;
    }

    public Hap getHap() {
        return this.hap;
    }

    public Pii getPii() {
        return this.pii;
    }

    public GraniteGuardian getGraniteGuardian() {
        return this.graniteGuardian;
    }

    public List<InputRanges> getInputRanges() {
        return this.inputRanges;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Hap hap;
        private Pii pii;
        private GraniteGuardian graniteGuardian;
        private List<InputRanges> inputRanges;

        public Builder hap(Hap hap) {
            this.hap = hap;
            return this;
        }

        public Builder pii(Pii pii) {
            this.pii = pii;
            return this;
        }

        public Builder graniteGuardian(GraniteGuardian graniteGuardian) {
            this.graniteGuardian = graniteGuardian;
            return this;
        }

        public Builder inputRanges(List<InputRanges> inputRanges) {
            this.inputRanges = inputRanges;
            return this;
        }

        public Moderation build() {
            return new Moderation(this);
        }
    }

    public record Hap(TextModeration input, TextModeration output, MaskProperties mask) {
        public static Hap of(TextModeration input, TextModeration output, boolean mask) {
            return new Hap(input, output, new MaskProperties(mask));
        }
    }

    public record Pii(TextModerationWithoutThreshold input, TextModerationWithoutThreshold output, MaskProperties mask) {
        public static Pii of(boolean input, boolean output, boolean mask) {
            return new Pii(new TextModerationWithoutThreshold(input), new TextModerationWithoutThreshold(output), new MaskProperties(mask));
        }
    }

    public record GraniteGuardian(TextModeration input, MaskProperties mask) {
        public static GraniteGuardian of(TextModeration input, boolean mask) {
            return new GraniteGuardian(input, new MaskProperties(mask));
        }
    }

    public record InputRanges(Integer start, Integer end) {
        public static InputRanges of(Integer start, Integer end) {
            return new InputRanges(start, end);
        }
    }

    public record TextModerationWithoutThreshold(boolean enabled) {
    }

    public record MaskProperties(boolean removeEntityValue) {
    }

    public record TextModeration(boolean enabled, float threshold) {
        public static TextModeration of(float threshold) {
            return new TextModeration(true, threshold);
        }
    }
}

