/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textgeneration;

import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.textgeneration.Moderation;
import com.ibm.watsonx.ai.textgeneration.TextGenerationHandler;
import com.ibm.watsonx.ai.textgeneration.TextGenerationParameters;
import com.ibm.watsonx.ai.textgeneration.TextGenerationResponse;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;

public interface TextGenerationProvider {
    default public TextGenerationResponse generate(String input) {
        return this.generate(input, null, null);
    }

    default public TextGenerationResponse generate(String input, TextGenerationParameters parameters) {
        return this.generate(input, null, parameters);
    }

    default public TextGenerationResponse generate(String input, Moderation moderation) {
        return this.generate(input, moderation, null);
    }

    public TextGenerationResponse generate(String var1, Moderation var2, TextGenerationParameters var3);

    default public CompletableFuture<Void> generateStreaming(String input, TextGenerationHandler handler) {
        return this.generateStreaming(input, null, handler);
    }

    public CompletableFuture<Void> generateStreaming(String var1, TextGenerationParameters var2, TextGenerationHandler var3);

    default public Void handlerError(Throwable t, TextGenerationHandler handler) {
        Optional.ofNullable(t).ifPresent(handler::onError);
        return null;
    }

    default public Flow.Subscriber<String> subscriber(final TextGenerationHandler handler) {
        return new Flow.Subscriber<String>(){
            private Flow.Subscription subscription;
            private volatile String modelId;
            private volatile int inputTokenCount;
            private volatile int generatedTokenCount;
            private volatile String stopReason;
            private volatile boolean success = true;
            private final StringBuilder stringBuilder = new StringBuilder();

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(String partialMessage) {
                try {
                    TextGenerationResponse.Result result;
                    if (Objects.isNull(partialMessage) || partialMessage.isBlank() || !partialMessage.startsWith("data: ")) {
                        return;
                    }
                    String messageData = partialMessage.split("data: ")[1];
                    TextGenerationResponse chunk = (TextGenerationResponse)Json.fromJson((String)messageData, TextGenerationResponse.class);
                    if (chunk.results().size() == 0) {
                        return;
                    }
                    if (Objects.isNull(this.modelId) && Objects.nonNull(chunk.modelId())) {
                        this.modelId = chunk.modelId();
                    }
                    if (Objects.nonNull((result = chunk.results().get(0)).inputTokenCount())) {
                        this.inputTokenCount += result.inputTokenCount().intValue();
                    }
                    if (Objects.nonNull(result.generatedTokenCount())) {
                        this.generatedTokenCount += result.generatedTokenCount().intValue();
                    }
                    if (Objects.nonNull(result.stopReason())) {
                        this.stopReason = result.stopReason();
                    }
                    if (Objects.nonNull(result.generatedText()) && !result.generatedText().isEmpty()) {
                        this.stringBuilder.append(result.generatedText());
                        handler.onPartialResponse(result.generatedText());
                    }
                }
                catch (RuntimeException e) {
                    handler.onError(e);
                    this.success = !handler.failOnFirstError();
                }
                finally {
                    if (this.success) {
                        this.subscription.request(1L);
                    } else {
                        this.subscription.cancel();
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                handler.onError(throwable);
            }

            @Override
            public void onComplete() {
                try {
                    List<TextGenerationResponse.Result> result = List.of(new TextGenerationResponse.Result(this.stringBuilder.toString(), this.stopReason, this.generatedTokenCount, this.inputTokenCount, null, null, null, null));
                    handler.onCompleteResponse(new TextGenerationResponse(this.modelId, null, null, result));
                }
                catch (RuntimeException e) {
                    handler.onError(e);
                }
            }
        };
    }
}

