/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.timeseries;

import com.ibm.watsonx.ai.WatsonxParameters;
import com.ibm.watsonx.ai.timeseries.ForecastData;
import com.ibm.watsonx.ai.timeseries.ForecastRequest;
import java.util.Objects;

public final class TimeSeriesParameters
extends WatsonxParameters.WatsonxModelParameters {
    private final Integer predictionLength;
    private final ForecastData futureData;

    public TimeSeriesParameters(Builder builder) {
        super(builder);
        this.predictionLength = builder.predictionLength;
        this.futureData = builder.futureData;
    }

    public Integer getPredictionLength() {
        return this.predictionLength;
    }

    public ForecastData getFutureData() {
        return this.futureData;
    }

    public ForecastRequest.Parameters toParameters() {
        return Objects.nonNull(this.predictionLength) ? new ForecastRequest.Parameters(this.predictionLength) : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WatsonxParameters.WatsonxModelParameters.Builder<Builder> {
        private Integer predictionLength;
        private ForecastData futureData;

        public Builder predictionLength(int predictionLength) {
            this.predictionLength = predictionLength;
            return this;
        }

        public Builder futureData(ForecastData futureData) {
            this.futureData = futureData;
            return this;
        }

        public TimeSeriesParameters build() {
            return new TimeSeriesParameters(this);
        }
    }
}

