/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.timeseries;

import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.timeseries.ForecastData;
import com.ibm.watsonx.ai.timeseries.ForecastRequest;
import com.ibm.watsonx.ai.timeseries.ForecastResponse;
import com.ibm.watsonx.ai.timeseries.InputSchema;
import com.ibm.watsonx.ai.timeseries.TimeSeriesParameters;
import com.ibm.watsonx.ai.timeseries.TimeSeriesProvider;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public final class TimeSeriesService
extends WatsonxService.ModelService
implements TimeSeriesProvider {
    protected TimeSeriesService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.getAuthenticationProvider(), "authenticationProvider cannot be null");
    }

    @Override
    public ForecastResponse forecast(InputSchema inputSchema, ForecastData data, TimeSeriesParameters parameters) {
        Objects.requireNonNull(inputSchema, "InputSchema cannot be null");
        Objects.requireNonNull(data, "Data cannot be null");
        String modelId = this.modelId;
        String projectId = this.projectId;
        String spaceId = this.spaceId;
        String transactionId = null;
        ForecastRequest.Parameters requestParameters = null;
        if (Objects.nonNull(parameters)) {
            modelId = Objects.requireNonNullElse(parameters.getModelId(), this.modelId);
            projectId = Optional.ofNullable(parameters.getProjectId()).orElse(this.projectId);
            spaceId = Optional.ofNullable(parameters.getSpaceId()).orElse(this.spaceId);
            transactionId = parameters.getTransactionId();
            requestParameters = parameters.toParameters();
        }
        ForecastRequest forecastRequest = new ForecastRequest(modelId, spaceId, projectId, data.asMap(), inputSchema, null, requestParameters);
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.url.toString() + "%s/time_series/forecast?version=%s".formatted("/ml/v1", this.version))).header("Content-Type", "application/json").header("Accept", "application/json").timeout(this.timeout).POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)forecastRequest)));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            HttpResponse httpReponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (ForecastResponse)Json.fromJson((String)((String)httpReponse.body()), ForecastResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WatsonxService.ModelService.Builder<Builder> {
        public TimeSeriesService build() {
            return new TimeSeriesService(this);
        }
    }
}

