/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.appserver.tools.jaxrpc.common;

import com.ibm.websphere.appserver.tools.jaxrpc.common.CommonLoggerI;
import com.ibm.websphere.appserver.tools.jaxrpc.common.WsdlDocumentElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WSDLValidationResult {
    private String wsdlPath;
    private boolean wsdlValid = true;
    private boolean isInteroperable = true;
    private boolean qualifiedNamespace = false;
    private boolean isJmsDefined = false;
    private Boolean isValidMimeType;
    private boolean isRpcEncoded = false;
    private boolean isUnsupportedApacheSoapNS = false;
    private boolean isUnsupportedSoapEncodingNS = false;
    private boolean isUnsupportedWebsphereNS = false;
    private boolean isImportLocationValid = true;
    private boolean hasIbmTwasNs = false;
    private boolean hasValidPort = false;
    private transient HashMap<String, WsdlDocumentElement> wsdlMessages = new HashMap();
    private transient HashMap<String, HashMap<String, WsdlDocumentElement>> mimeCollections = new HashMap();
    private transient HashMap<String, WsdlDocumentElement> schemaElements = new HashMap();
    private transient HashMap<String, WsdlDocumentElement> innerElements = new HashMap();
    private transient HashMap<String, String> varToXsdTypeMap = new HashMap();
    private transient CommonLoggerI log;
    private String targetNamespace = null;
    private Map<String, String> soapAddresses = new HashMap<String, String>();
    private List<String> warnMessages = new ArrayList<String>();
    private List<String> errorMessages = new ArrayList<String>();

    public WSDLValidationResult(CommonLoggerI log) {
        this.log = log;
    }

    public void setTargetNamespace(String namespace) {
        this.targetNamespace = namespace;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void addSoapAddress(String portName, String address) {
        this.soapAddresses.put(portName, address);
        this.setValidPort();
    }

    public Map<String, String> getSoapAddresses() {
        return this.soapAddresses;
    }

    public boolean isInteroperable() {
        return this.isInteroperable;
    }

    public void setNotInteroperable() {
        this.isInteroperable = false;
    }

    public boolean isQualifiedNamespace() {
        return this.qualifiedNamespace;
    }

    public void setQualifiedNamespace(boolean qualifiedNamespace) {
        this.qualifiedNamespace = qualifiedNamespace;
        this.wsdlValid = this.wsdlValid && !qualifiedNamespace;
    }

    public boolean isSoapOverJmsDefined() {
        return this.isJmsDefined;
    }

    public void setJmsDefined(boolean isJmsDefined) {
        this.isJmsDefined = isJmsDefined;
        this.wsdlValid = this.wsdlValid && !isJmsDefined;
    }

    public boolean isRpcEncoded() {
        return this.isRpcEncoded;
    }

    public void setRpcEncoded(boolean isRpcEncoded) {
        this.isRpcEncoded = isRpcEncoded;
        this.wsdlValid = this.wsdlValid && !isRpcEncoded;
    }

    public boolean isUnsupportedApacheSoapNS() {
        return this.isUnsupportedApacheSoapNS;
    }

    public void setUnsupportedApacheSoapNS(boolean isUnsupportedNamespace) {
        this.isUnsupportedApacheSoapNS = isUnsupportedNamespace;
        this.wsdlValid = this.wsdlValid && !isUnsupportedNamespace;
    }

    public boolean isUnsupportedSoapEncodingNS() {
        return this.isUnsupportedSoapEncodingNS;
    }

    public void setUnsupportedSoapEncodingNS(boolean isUnsupportedNamespace) {
        this.isUnsupportedSoapEncodingNS = isUnsupportedNamespace;
        this.wsdlValid = this.wsdlValid && !isUnsupportedNamespace;
    }

    public boolean isUnsupportedWebsphereNS() {
        return this.isUnsupportedWebsphereNS;
    }

    public void setUnsupportedWebsphereNS(boolean isUnsupportedNamespace) {
        this.isUnsupportedWebsphereNS = isUnsupportedNamespace;
        this.wsdlValid = this.wsdlValid && !isUnsupportedNamespace;
    }

    public boolean isImportLocationValid() {
        return this.isImportLocationValid;
    }

    public void setImportLocationValid(boolean isImportLocationValid) {
        this.isImportLocationValid = this.isImportLocationValid && isImportLocationValid;
        this.wsdlValid = this.wsdlValid && isImportLocationValid;
    }

    public boolean isWsdlValid() {
        return this.wsdlValid && this.hasValidPort;
    }

    public void setWsdlInvalid() {
        this.wsdlValid = false;
    }

    public WsdlDocumentElement getWsdlMessageElement(String wsdlMessageName) {
        return this.wsdlMessages.get(wsdlMessageName);
    }

    public void putWsdlMessageElement(String key, WsdlDocumentElement element) {
        this.wsdlMessages.put(key, element);
    }

    public int messageElementCount() {
        return this.wsdlMessages.size();
    }

    public WsdlDocumentElement getSchemaElement(String elementName) {
        return this.schemaElements.get(elementName);
    }

    public void putSchemaElement(String key, WsdlDocumentElement element) {
        this.schemaElements.put(key, element);
    }

    public WsdlDocumentElement getInnerElement(String elementName) {
        return this.innerElements.get(elementName);
    }

    public void putInnerElement(String key, WsdlDocumentElement element) {
        this.innerElements.put(key, element);
    }

    public HashMap<String, WsdlDocumentElement> getInnerElementsCollection() {
        return this.innerElements;
    }

    public HashMap<String, HashMap<String, WsdlDocumentElement>> getMimeCollections() {
        return this.mimeCollections;
    }

    public HashMap<String, WsdlDocumentElement> addMimePartsMap(String ioName, HashMap<String, WsdlDocumentElement> mimeParts) {
        return this.mimeCollections.put(ioName, mimeParts);
    }

    public HashMap<String, WsdlDocumentElement> getMimePartsMap(String ioName) {
        return this.mimeCollections.get(ioName);
    }

    public Set<String> getMimePartsKeySet(String ioName) {
        if (this.mimeCollections.get(ioName) == null) {
            return null;
        }
        return this.mimeCollections.get(ioName).keySet();
    }

    public boolean isValidMimeType() {
        return this.isValidMimeType;
    }

    public void updateValidMimeType(boolean isValidMimeType) {
        this.isValidMimeType = this.isValidMimeType == null ? isValidMimeType : this.isValidMimeType != false && isValidMimeType;
        this.wsdlValid = this.wsdlValid && this.isValidMimeType != false;
    }

    public HashMap<String, String> getVarToXsdTypeMap() {
        return this.varToXsdTypeMap;
    }

    public void setVarToXsdTypeMap(HashMap<String, String> varToXsdTypeMap) {
        this.varToXsdTypeMap = varToXsdTypeMap;
    }

    public void addVarToXsdType(String varName, String xsdType) {
        this.varToXsdTypeMap.put(varName, xsdType);
    }

    public boolean hasIBMtWASNs() {
        return this.hasIbmTwasNs;
    }

    public void setHasIbmTwasNs(boolean hasIbmTwasNs) {
        this.hasIbmTwasNs = hasIbmTwasNs;
    }

    public boolean containsValidPort() {
        return this.hasValidPort;
    }

    private void setValidPort() {
        this.hasValidPort = true;
    }

    public String getWsdlPath() {
        return this.wsdlPath;
    }

    public void setWsdlPath(String filePath) {
        this.wsdlPath = filePath;
    }

    public void setLogger(CommonLoggerI log) {
        this.log = log;
    }

    public void logError(String message) {
        this.errorMessages.add(message);
        this.log.error(message);
    }

    public void logWarn(String message) {
        this.warnMessages.add(message);
        this.log.warn(message);
    }
}

