/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.appserver.tools.jaxrpc.common.data;

import com.ibm.websphere.appserver.tools.jaxrpc.common.data.WSDLResources;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class WSDLResource {
    private String wsdlPath;
    private String wsdlReferenceFile;
    private File wsdlFile = null;
    private URL wsdlUrl = null;
    private boolean isWsdlLocation = false;
    private String wsImportDir;
    private String generatedPortionOfDir;
    private HashMap<String, String> xsdBucket = new HashMap();
    private String targetNamespace = null;
    private Map<String, String> soapAddresses = new HashMap<String, String>();
    private Map<String, String> xsdTypeNames = new HashMap<String, String>();
    private String packageName = null;

    public static WSDLResource createWsdlLocation(String wsdlPath, String baseDir) throws Exception {
        return new WSDLResource(wsdlPath, baseDir, "jaxrpc-tools-wsimport", true);
    }

    public static WSDLResource createServiceWsdl(String wsdlPath, String wsdlReferenceFile) throws Exception {
        return new WSDLResource(wsdlPath, wsdlReferenceFile, WSDLResources.WSIMPORT_SERVICE_DIR, false);
    }

    public static WSDLResource createClientWsdl(String wsdlPath, String wsdlReferenceFile) throws Exception {
        return new WSDLResource(wsdlPath, wsdlReferenceFile, WSDLResources.WSIMPORT_CLIENT_DIR, false);
    }

    private WSDLResource(String wsdlPath, String wsdlReference, String genDir, boolean isWsdlLocation) throws Exception {
        this.wsdlReferenceFile = wsdlReference;
        this.isWsdlLocation = isWsdlLocation;
        try {
            this.wsdlUrl = new URL(wsdlPath);
            this.wsdlPath = this.wsdlUrl.toString();
            String wsdlReferencePath = new File(wsdlReference).getParent();
            String wsdlName = this.wsdlUrl.getPath();
            this.generatedPortionOfDir = genDir + File.separator + wsdlName.substring(wsdlName.lastIndexOf("/"));
            this.wsImportDir = new File(wsdlReferencePath, this.generatedPortionOfDir).getCanonicalPath();
        }
        catch (MalformedURLException e) {
            try {
                if (isWsdlLocation) {
                    File file = new File(wsdlPath);
                    if (!file.isAbsolute() || !file.exists()) {
                        file = new File(wsdlReference, wsdlPath);
                    }
                    this.wsdlFile = file.getCanonicalFile();
                    if (!this.wsdlFile.exists()) {
                        throw new Exception(MessageFormat.format("File at wsdlLocation {0} does not exist. Correct the wsdlLocation parameter and try again.", this.wsdlFile.getCanonicalPath()));
                    }
                } else {
                    this.wsdlFile = new File(wsdlPath);
                }
                this.wsdlPath = this.wsdlFile.getCanonicalPath();
                String wsdlName = this.wsdlFile.getName();
                this.generatedPortionOfDir = genDir + File.separator + wsdlName.substring(0, wsdlName.length() - 5);
                this.wsImportDir = new File(this.wsdlFile.getParent(), this.generatedPortionOfDir).getCanonicalPath();
            }
            catch (IOException ioe) {
                StringBuilder sb = new StringBuilder();
                sb.append("The specified wsdl path " + wsdlPath + " is neither a valid File or URL.");
                if (isWsdlLocation) {
                    sb.append(" Please ensure there is a valid wsdlLocation set.");
                } else {
                    sb.append(" The wsdl path was specified in: " + wsdlReference);
                }
                throw new Exception(sb.toString());
            }
        }
    }

    public String getWsdlPath() {
        return this.wsdlPath;
    }

    public String getWsdlReferencePath() {
        return this.wsdlReferenceFile;
    }

    public String getGeneratedPortionOfPath() {
        return this.generatedPortionOfDir;
    }

    public URL getWsdlUrl() {
        return this.wsdlUrl;
    }

    public File getWsdlFile() {
        return this.wsdlFile;
    }

    public boolean isURL() {
        return this.wsdlUrl != null;
    }

    public boolean isFile() {
        return this.wsdlFile != null;
    }

    public boolean isWsdlLocation() {
        return this.isWsdlLocation;
    }

    public String getWsImportDirPath() {
        return this.wsImportDir;
    }

    public void setXsdBucket(HashMap<String, String> map) {
        this.xsdBucket = map;
    }

    public String getXsdType(String wsdlVarName) {
        return this.xsdBucket.get(wsdlVarName);
    }

    public void addXsdTypeName(String name2, String type) {
        this.xsdTypeNames.put(name2, type);
    }

    public Map<String, String> getXsdTypeNames() {
        return this.xsdTypeNames;
    }

    public String getMappingTypeForName(String name2) {
        return this.xsdTypeNames.get(name2);
    }

    public void setTargetNamespace(String namespace) {
        this.targetNamespace = namespace;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setSoapAddresses(Map<String, String> map) {
        this.soapAddresses = map;
    }

    public String getSoapAddress(String portName) {
        return this.soapAddresses.get(portName);
    }

    public void setPackageName(String name2) {
        this.packageName = name2;
    }

    public String getPackageName() {
        return this.packageName;
    }
}

