/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.binary.cmdline;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.binary.cmdline.MergeFeaturesResult;
import com.ibm.websphere.binary.cmdline.exceptions.FeatureConflictException;
import com.ibm.websphere.binary.cmdline.exceptions.FeatureNotAvailableAtRequestedLevelException;
import com.ibm.websphere.binary.cmdline.exceptions.IllegalTargetCombinationException;
import com.ibm.websphere.binary.cmdline.exceptions.IllegalTargetException;
import com.ibm.websphere.binary.cmdline.exceptions.ProvidedFeatureConflictException;
import com.ibm.websphere.binary.cmdline.exceptions.RequiredFeatureModifiedException;
import com.ibm.ws.report.analyze.AnalysisResults;
import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.cmdline.DriveScan;
import com.ibm.ws.report.binary.cmdline.DriveScanGenerateConfig;
import com.ibm.ws.report.binary.cmdline.Messages;
import com.ibm.ws.report.binary.cmdline.utilities.ReportBuilderHelper;
import com.ibm.ws.report.binary.utilities.BinaryReportBuilder;
import com.ibm.ws.report.ta.RewriteConfig;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;

public class BinaryScanner {
    public static final String TARGET_APP_SERVER_LIBERTY = "liberty";
    public static final String TARGET_APP_SERVER_OPEN_LIBERTY = "openLiberty";

    public static Set<String> generateFeatureList(Set<String> binaryInputs, String targetJavaEE, String targetMicroProfile, Set<String> currentFeatures, String logLocation, String logLevel, Locale locale) throws FeatureConflictException, RequiredFeatureModifiedException, ProvidedFeatureConflictException, FeatureNotAvailableAtRequestedLevelException, IllegalTargetException, IllegalTargetCombinationException {
        ReportUtility.setLocale(locale == null ? Locale.getDefault() : locale);
        ReportInputData data = DriveScan.processGenerateFeatureListAPIParameters(binaryInputs, targetJavaEE, targetMicroProfile, logLocation, logLevel);
        DriveScanGenerateConfig scanner = new DriveScanGenerateConfig(data, true);
        return scanner.runFeatureList((List<String>)(null == currentFeatures ? null : new ArrayList<String>(currentFeatures)));
    }

    public static MergeFeaturesResult mergeFeatures(Set<String> features, String targetAppServer) throws IllegalArgumentException {
        return BinaryScanner.mergeFeatures(features, targetAppServer, null, null, Locale.getDefault());
    }

    private static MergeFeaturesResult mergeFeatures(Set<String> features, String targetAppServer, String logLocation, String logLevel, Locale locale) throws IllegalArgumentException {
        ReportUtility.setLocale(locale);
        ReportInputData data = DriveScan.processMergeFeaturesAPIParameters(targetAppServer, logLocation, logLevel);
        DriveScanGenerateConfig scanner = new DriveScanGenerateConfig(data, true);
        return scanner.mergeFeatures(features);
    }

    public static AnalysisResults getAllRulesAnalysisResults() {
        ReportUtility.initiateLogger(false, false);
        ReportUtility.setLocale(Locale.getDefault());
        BinaryReportBuilder builder = new BinaryReportBuilder();
        builder._loadAllRules = true;
        ReportBuilderHelper.loadAllRules(builder);
        HashSet<String> rulesFlagged = new HashSet<String>();
        AnalysisResults analysisResults = new AnalysisResults(builder._descToRuleIds, null, builder.getSortedRulesByCategories(), builder.getSortedRulesAnalyzedForCategoriesStartingWithPrefix("appconversion.cloud.category.technology.connectivity"), builder._severities, builder._helpIds, rulesFlagged, true, null, builder.getRulesToRecipesMap());
        return analysisResults;
    }

    public static RewriteConfig getRecipeConfigFromRuleIds(List<String> ruleIds) {
        AnalysisResults analysisResults = BinaryScanner.getAllRulesAnalysisResults();
        RewriteConfig config = analysisResults.getRewriteConfig(ruleIds);
        return config;
    }

    public static String getHelpFromRuleIdDynamically(String ruleId) {
        ReportUtility.initiateLogger(false, false);
        ReportUtility.setLocale(Locale.getDefault());
        BinaryReportBuilder analyze = new BinaryReportBuilder();
        analyze._loadAllRules = true;
        ReportBuilderHelper.loadAllRules(analyze);
        String helpFileLoc = (String)analyze._helpIds.get(ruleId);
        String loadedHelp = null;
        try {
            loadedHelp = ReportUtility.loadRuleHelpBody(helpFileLoc, Locale.getDefault());
        }
        catch (FileNotFoundException e) {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("File_Not_Loaded"), helpFileLoc));
        }
        return loadedHelp;
    }

    public static String getHelpFromRuleId(String ruleId) {
        ReportUtility.initiateLogger(false, false);
        ReportUtility.setLocale(Locale.getDefault());
        String helpFileLocation = null;
        String helpContent = null;
        try {
            String jsonData = ReportUtility.loadFileAsString("/resources/ruleIdToHelp.json");
            JSONObject jsonObject = JSONObject.parse(jsonData.toString());
            helpFileLocation = (String)jsonObject.get(ruleId);
            helpContent = ReportUtility.loadRuleHelpBody(helpFileLocation, Locale.getDefault());
        }
        catch (Exception e) {
            if (null != helpFileLocation) {
                if (ReportUtility.isDebug()) {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("File_Not_Loaded_Log"), helpFileLocation), e);
                } else {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("File_Not_Loaded"), helpFileLocation));
                }
            }
            if (ReportUtility.isDebug()) {
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("BinaryScanner_NoHelpForRuleID"), ruleId), e);
            }
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("BinaryScanner_NoHelpForRuleID"), ruleId));
        }
        return helpContent;
    }
}

