/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.appconversion.jsp.core.util;

import com.ibm.ws.appconversion.jsp.core.model.AttributeValueInfo;
import com.ibm.ws.appconversion.jsp.core.model.CoreJspNodeModelMapper;
import com.ibm.ws.appconversion.jsp.core.model.JspImport;
import com.ibm.ws.appconversion.jsp.core.model.JspNode;
import com.ibm.ws.appconversion.jsp.core.model.JspNodeType;
import com.ibm.ws.appconversion.jsp.core.parser.JspData;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CoreJspHelper {
    public static final String JAVA_NAME_PREFIX = "_AppConversion_";
    public static final String[] javaReservedKeywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
    public static final String[] elReservedKeywords = new String[]{"and", "div", "empty", "eq", "false", "ge", "gt", "instanceof", "le", "lt", "mod", "ne", "not", "null", "or", "true"};
    public static final char DOUBLE_QUOTE = '\"';
    public static final char SINGLE_QUOTE = '\'';

    public static List<JspNode> filterForTagName(List<JspNode> nodes, String tagName) {
        ArrayList<JspNode> result = new ArrayList<JspNode>();
        for (JspNode jspNode : nodes) {
            if (!jspNode.getData().startsWith(tagName)) continue;
            result.add(jspNode);
        }
        return result;
    }

    public static Map<String, Integer> getAttributes(String data) {
        HashMap<String, Integer> toReturn = new HashMap<String, Integer>();
        List<String> attributes = null;
        try {
            attributes = CoreJspHelper.splitAttributes(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String key = null;
        int pos = 0;
        if (attributes != null) {
            for (String attr : attributes) {
                if (attr.indexOf(61) <= 0) continue;
                key = attr.substring(0, attr.indexOf(61));
                key = key.trim();
                pos = data.indexOf(attr);
                toReturn.put(key, pos);
            }
        }
        return toReturn;
    }

    public static List<String> splitAttributes(String in) throws IOException {
        int firstBlank;
        ArrayList<String> out = new ArrayList<String>();
        String[] strings = in.split("\\s");
        int n = firstBlank = strings.length > 1 ? strings[0].length() : -1;
        if (firstBlank != -1) {
            int c;
            String attributes = in.substring(firstBlank);
            if (attributes.endsWith("/>")) {
                attributes = attributes.substring(0, attributes.length() - 2);
            } else if (attributes.endsWith(">")) {
                attributes = attributes.substring(0, attributes.length() - 1);
            }
            attributes = attributes.trim();
            StringReader r = new StringReader(attributes);
            StringBuilder b = new StringBuilder();
            int inDQuote = -1;
            int inSQuote = -1;
            int hitEqual = -1;
            boolean escape = false;
            boolean startValue = false;
            while ((c = r.read()) != -1) {
                if (escape) {
                    b.append((char)c);
                    escape = false;
                    continue;
                }
                switch (c) {
                    case 92: {
                        escape = true;
                        break;
                    }
                    case 34: {
                        inDQuote = inDQuote == -1 ? c : -1;
                        if (hitEqual != -1) {
                            startValue = true;
                        }
                        b.append((char)c);
                        break;
                    }
                    case 39: {
                        inSQuote = inSQuote == -1 ? c : -1;
                        if (hitEqual != -1) {
                            startValue = true;
                        }
                        b.append((char)c);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 32: {
                        if (inSQuote == -1 && inDQuote == -1) {
                            if (hitEqual == -1) {
                                b.append((char)c);
                                break;
                            }
                            if (!startValue) {
                                b.append((char)c);
                                break;
                            }
                            out.add(b.toString().trim());
                            b.setLength(0);
                            hitEqual = -1;
                            startValue = false;
                            break;
                        }
                        b.append((char)c);
                        break;
                    }
                    case 61: {
                        b.append((char)c);
                        hitEqual = (char)c;
                        break;
                    }
                    default: {
                        b.append((char)c);
                    }
                }
            }
            if (b.length() > 0) {
                out.add(b.toString().trim());
            }
        }
        return out;
    }

    public static List<JspNode> filterForNodeType(List<JspNode> nodes, JspNodeType jspNodeType) {
        ArrayList<JspNode> result = new ArrayList<JspNode>();
        for (JspNode jspNode : nodes) {
            if (!jspNodeType.equals((Object)jspNode.getJspNodeType())) continue;
            result.add(jspNode);
        }
        return result;
    }

    public static StringBuffer simpleJSP2Java(JspData jspData, String packageName) {
        String data;
        String name2 = CoreJspHelper.getJavaNameFromJSP(jspData.getName(), JAVA_NAME_PREFIX);
        StringBuffer sb = new StringBuffer();
        sb.append("package ").append(packageName).append(";\n");
        List<JspNode> jspNodes = jspData.getJSPNodes();
        List<JspNode> jspNodesFiltered = CoreJspHelper.filterForNodeType(jspNodes, JspNodeType.DIRECTIVE);
        for (JspNode jspNode : jspNodesFiltered) {
            JspImport jspImport = CoreJspNodeModelMapper.getImportInfo(jspNode);
            if (jspImport == null) continue;
            for (String imp : jspImport.getImports()) {
                sb.append("import " + imp + ";\n");
            }
        }
        sb.append("import javax.servlet.*;\n");
        sb.append("import javax.servlet.jsp.*;\n");
        sb.append("import javax.servlet.http.*;\n");
        sb.append("\n");
        sb.append("public class " + name2.replace(".java", "") + " {\n");
        sb.append("private javax.servlet.ServletContext application = null; \n");
        sb.append("private javax.servlet.ServletConfig config = null; \n");
        sb.append("private java.lang.Throwable exception = null; \n");
        sb.append("private javax.servlet.jsp.JspWriter out = null; \n");
        sb.append("private Object page = null; \n");
        sb.append("private javax.servlet.jsp.PageContext pageContext = null; \n");
        sb.append("private javax.servlet.http.HttpSession session = null; \n");
        sb.append("private javax.servlet.http.HttpServletRequest request = null; \n");
        sb.append("private javax.servlet.http.HttpServletResponse response = null; \n");
        jspNodesFiltered = CoreJspHelper.filterForNodeType(jspNodes, JspNodeType.DECLARATION);
        for (JspNode jspNode : jspNodesFiltered) {
            try {
                data = jspNode.getData().substring(3, jspNode.getData().length() - 2);
                CoreJspHelper.addNodeData(sb, data, jspNode.getLine(), jspNode.getOffset(), jspNode.getOffset() + 3);
            }
            catch (Throwable throwable) {}
        }
        sb.append("public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException { \n");
        jspNodesFiltered = CoreJspHelper.filterForNodeType(jspNodes, JspNodeType.SCRIPTLET);
        for (JspNode jspNode : jspNodesFiltered) {
            try {
                data = jspNode.getData().substring(2, jspNode.getData().length() - 2);
                CoreJspHelper.addNodeData(sb, data, jspNode.getLine(), jspNode.getOffset(), jspNode.getOffset() + 2);
            }
            catch (Throwable throwable) {}
        }
        sb.append("} \n");
        sb.append("}");
        return sb;
    }

    public static void addNodeData(StringBuffer sb, String data, int line, int initialOffset, int offset) {
        StringTokenizer st = new StringTokenizer(data, "\n");
        sb.append("//_appconversion_Node line:" + line + ",offset:" + initialOffset + ",length:" + data.length()).append("\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            sb.append("//_appconversion_Entry line:" + line + ",offset:" + offset + ",length:" + token.length()).append("\n");
            sb.append(token).append("\n");
            offset += token.length() + 1;
            ++line;
        }
    }

    public static String getJavaNameFromJSP(String name2, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (name2.endsWith(".jsp")) {
            name2 = name2.replace(".jsp", "");
            name2 = String.valueOf(prefix) + name2 + ".java";
        }
        return name2;
    }

    public static boolean containsReservedKeyword(String nodeData) {
        String expression = nodeData.substring(2, nodeData.length() - 1);
        if (expression == null || expression.equals("")) {
            return false;
        }
        expression = CoreJspHelper.removeQuotedStrings(expression);
        String[] tokens = expression.split("\\.");
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            buf.append(tokens[i]);
            if (i != tokens.length - 1) {
                buf.append(" . ");
            }
            ++i;
        }
        expression = buf.toString();
        String pattern = "[\\s\\[\\]()\\-!\\*/%+<>=?:]+|&&|\\|\\|";
        tokens = expression.split(pattern);
        int i2 = 0;
        while (i2 < tokens.length) {
            if (!tokens[i2].equals(".")) {
                if (CoreJspHelper.isReservedKeyword(tokens[i2], javaReservedKeywords)) {
                    return true;
                }
                if (CoreJspHelper.isDotBeforeOrAfter(tokens, i2) && CoreJspHelper.isReservedKeyword(tokens[i2], elReservedKeywords)) {
                    return true;
                }
            }
            ++i2;
        }
        return false;
    }

    public static boolean isDotBeforeOrAfter(String[] tokens, int i) {
        if (i > 0 && tokens[i - 1].equals(".")) {
            return true;
        }
        return i < tokens.length - 1 && tokens[i + 1].equals(".");
    }

    public static String removeQuotedStrings(String expression) {
        String pattern = "\\\\\"|\\\\'";
        String[] tokens = expression.split(pattern);
        String result = null;
        if (tokens.length == 1) {
            result = tokens[0];
        } else {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < tokens.length) {
                buf.append(tokens[i]);
                buf.append(" ");
                ++i;
            }
            result = buf.toString();
        }
        result = CoreJspHelper.removeStrings(result, '\"');
        while (result.indexOf(34) >= 0) {
            result = CoreJspHelper.removeStrings(result, '\"');
        }
        result = CoreJspHelper.removeStrings(result.toString(), '\'');
        while (result.indexOf(39) >= 0) {
            result = CoreJspHelper.removeStrings(result, '\'');
        }
        return result;
    }

    public static String removeStrings(String input, char quote) {
        String result = input;
        int q1 = result.indexOf(quote);
        if (q1 >= 0) {
            int q2 = result.indexOf(quote, q1);
            result = result.substring(0, q1);
            if (q2 >= 0) {
                result = String.valueOf(result) + " " + result.substring(q2);
            }
        }
        return result;
    }

    public static boolean isReservedKeyword(String token, String[] reservedList) {
        if (token == null || token.length() == 0) {
            return false;
        }
        int i = 0;
        int j = reservedList.length;
        while (i < j) {
            int k = (i + j) / 2;
            int result = reservedList[k].compareTo(token);
            if (result == 0) {
                return true;
            }
            if (result < 0) {
                i = k + 1;
                continue;
            }
            j = k;
        }
        return false;
    }

    public static Boolean isELIgnoredFromPageDirective(JspNode jspNode) {
        if (jspNode.getData().contains("isELIgnored")) {
            AttributeValueInfo attInfo = CoreJspNodeModelMapper.getAttributeValue("isELIgnored", jspNode.getData());
            if ("true".equalsIgnoreCase(attInfo.getValue())) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public static Boolean isJSFIgnoredFromPageDirective(JspNode jspNode) {
        if (jspNode.getData().contains("deferredSyntaxAllowedAsLiteral")) {
            AttributeValueInfo attInfo = CoreJspNodeModelMapper.getAttributeValue("deferredSyntaxAllowedAsLiteral", jspNode.getData());
            if ("true".equalsIgnoreCase(attInfo.getValue())) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }
}

