/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.analyze;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.analyze.AnalysisRule;
import com.ibm.ws.report.ta.RewriteConfig;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.utilities.RuleSeverity;
import com.ibm.ws.report.writer.ModuleData;
import com.ibm.ws.report.writer.RewriteGradleConfigWriter;
import com.ibm.ws.report.writer.RewriteMavenConfigWriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AnalysisResults {
    protected static final Pattern MATCH_ONCLICK_PATTERN = Pattern.compile("onclick{0,}\\=\\s{0,}\".*?\"");
    protected static final String TABLE_ELEMENT = "<table";
    protected Set<String> helpInProcessOfBeingLoaded = new HashSet<String>();
    protected static final Pattern PLUGINS_ROOT_REGEX = Pattern.compile("PLUGINS_ROOT/.+/(ruleinfo|help)/.+\\.html");
    protected static final String TARGET_BLANK = "target=\"_blank\"";
    protected static final String REL_ATTRIBUTE = "rel=\"noopener noreferrer\"";
    protected SortedMap<String, String> mapOfHelpContent = new TreeMap<String, String>();
    protected Set<String> helpLoaded = new HashSet<String>();
    protected Set<String> helpWritten = new HashSet<String>();
    protected Map<String, LinkedHashSet<String>> rulesToRecipes = null;
    private boolean includeConnectivitySummary = false;
    private boolean showAllHelp = false;
    private final ModuleData moduleData;
    private final SortedMap<String, AnalysisRule> mapOfIdToAnalysisRules = new TreeMap<String, AnalysisRule>();
    private final TreeMap<RuleSeverity, SortedMap<String, TreeSet<AnalysisRule>>> mapOfSeverityToAnalysisRules = new TreeMap(new MySeverityComp());
    private final Map<String, AnalysisRule> connectivityRuleNameToRule = new HashMap<String, AnalysisRule>();
    private final Set<String> rulesWithResultsIds = new HashSet<String>();
    private int totalNumberOfResults = 0;
    private int totalNumberOfRecipes = 0;
    private int totalNumberOfRulesWithResults = 0;
    private int totalNumberOfRecipesWithResults = 0;
    protected int numSevereRules = 0;
    protected int numWarningRules = 0;
    protected int numInfoRules = 0;
    protected int numNoSeverityRules = 0;
    protected int numSevereRuleResults = 0;
    protected int numWarningRuleResults = 0;
    protected int numInfoRuleResults = 0;
    protected int numNoSeverityRuleResults = 0;
    protected int numSevereRecipes = 0;
    protected int numWarningRecipes = 0;
    protected int numInfoRecipes = 0;
    protected int numNoSeverityRecipes = 0;
    protected int numSevereRecipeResults = 0;
    protected int numWarningRecipeResults = 0;
    protected int numInfoRecipeResults = 0;
    protected int numNoSeverityRecipeResults = 0;
    protected String rewriteGradleConfig = null;
    protected String rewriteMavenConfig = null;

    public AnalysisResults(Map<String, SortedSet<String>> ruleDescToRuleId, Map<String, List<DetailResult>> projectsToRulesFound, Map<String, Map<String, Map<String, List<String>>>> rulesAnalyzedByCategory, List<String> connectivityRulesAnalyzed, Map<String, RuleSeverity> ruleSeverities, Map<String, String> mapOfRuleIdToHelpNames, Set<String> rulesFlagged, boolean showAllHelp) {
        this(ruleDescToRuleId, projectsToRulesFound, rulesAnalyzedByCategory, connectivityRulesAnalyzed, ruleSeverities, mapOfRuleIdToHelpNames, rulesFlagged, showAllHelp, null, null);
    }

    public AnalysisResults(Map<String, SortedSet<String>> ruleDescToRuleId, Map<String, List<DetailResult>> projectsToRulesFound, Map<String, Map<String, Map<String, List<String>>>> rulesAnalyzedByCategory, List<String> connectivityRulesAnalyzed, Map<String, RuleSeverity> ruleSeverities, Map<String, String> mapOfRuleIdToHelpNames, Set<String> rulesFlagged, boolean showAllHelp, Set<String> categoriesToInclude, Map<String, LinkedHashSet<String>> rulesToRecipes) {
        this.showAllHelp = showAllHelp;
        this.includeConnectivitySummary = !connectivityRulesAnalyzed.isEmpty();
        this.moduleData = new ModuleData(connectivityRulesAnalyzed);
        this.rulesToRecipes = rulesToRecipes;
        for (Map.Entry<String, Map<String, Map<String, List<String>>>> rulesAnalyzedByCategoryEntry : rulesAnalyzedByCategory.entrySet()) {
            String mainCatKey = rulesAnalyzedByCategoryEntry.getKey();
            for (Map.Entry<String, Map<String, List<String>>> subCatsEntry : rulesAnalyzedByCategoryEntry.getValue().entrySet()) {
                String category;
                String subCatKey = subCatsEntry.getKey();
                String string = category = !mainCatKey.equals(subCatKey) ? String.valueOf(mainCatKey) + " / " + subCatKey : mainCatKey;
                if (categoriesToInclude != null && !categoriesToInclude.contains(category)) continue;
                this.storeAnalysisRulesByCategoryNames(category, subCatsEntry.getValue(), ruleDescToRuleId, ruleSeverities, mapOfRuleIdToHelpNames, connectivityRulesAnalyzed, rulesFlagged);
            }
        }
        this.buildResultsForAnalysisRules(projectsToRulesFound, ruleDescToRuleId, mapOfRuleIdToHelpNames);
    }

    private void buildResultsForAnalysisRules(Map<String, List<DetailResult>> projectsToRulesFound, Map<String, SortedSet<String>> ruleDescToRuleId, Map<String, String> mapOfRuleIdToHelpNames) {
        Pattern archiveFileNamesPattern = Pattern.compile(".*\\.[ejrw]ar$");
        boolean fileNameIsAnArchive = false;
        boolean contains2orMoreArchives = false;
        int ruleIndex = 0;
        HashSet<String> rulesAddedToSeverityMap = new HashSet<String>();
        if (projectsToRulesFound != null) {
            for (String projectName : projectsToRulesFound.keySet()) {
                List<DetailResult> results = projectsToRulesFound.get(projectName);
                for (DetailResult result : results) {
                    String fileName = result.getFileName();
                    String desc = result.getRuleDesc();
                    String id = result.getRuleName();
                    String lastArchiveName = ReportUtility.getLastArchiveFileName(fileName);
                    AnalysisRule rule = (AnalysisRule)this.mapOfIdToAnalysisRules.get(id);
                    if (rule == null) continue;
                    this.totalNumberOfResults += result.getNumberOfOccurrences();
                    if (rule.hasRecipe()) {
                        this.totalNumberOfRecipes += result.getNumberOfOccurrences();
                    }
                    fileNameIsAnArchive = archiveFileNamesPattern.matcher(fileName).matches();
                    RuleSeverity sev = rule.getSeverity();
                    switch (sev) {
                        case SEVERE: {
                            this.numSevereRuleResults += result.getNumberOfOccurrences();
                            if (!rule.hasRecipe()) break;
                            this.numSevereRecipeResults += result.getNumberOfOccurrences();
                            break;
                        }
                        case WARNING: {
                            this.numWarningRuleResults += result.getNumberOfOccurrences();
                            if (!rule.hasRecipe()) break;
                            this.numWarningRecipeResults += result.getNumberOfOccurrences();
                            break;
                        }
                        case INFO: {
                            this.numInfoRuleResults += result.getNumberOfOccurrences();
                            if (!rule.hasRecipe()) break;
                            this.numInfoRecipeResults += result.getNumberOfOccurrences();
                            break;
                        }
                        case NONE: {
                            this.numNoSeverityRuleResults += result.getNumberOfOccurrences();
                            if (!rule.hasRecipe()) break;
                            this.numNoSeverityRecipeResults += result.getNumberOfOccurrences();
                        }
                    }
                    contains2orMoreArchives = ReportUtility.containMoreThanOneArchive(lastArchiveName);
                    String archivePath = fileNameIsAnArchive && contains2orMoreArchives ? ReportUtility.getLastPreviousArchivePath(lastArchiveName) : lastArchiveName;
                    rule.addResult(result, archivePath);
                    ruleIndex = this.addHelpToRule(rulesAddedToSeverityMap, rule, ruleDescToRuleId, mapOfRuleIdToHelpNames, desc, sev, ruleIndex);
                }
            }
        }
        if (this.showAllHelp) {
            for (AnalysisRule rule : this.mapOfIdToAnalysisRules.values()) {
                String desc = rule.getRuleName();
                RuleSeverity sev = rule.getSeverity();
                this.addHelpToRule(rulesAddedToSeverityMap, rule, ruleDescToRuleId, mapOfRuleIdToHelpNames, desc, sev, ruleIndex);
            }
        }
    }

    public int addHelpToRule(Set<String> rulesAddedToSeverityMap, AnalysisRule rule, Map<String, SortedSet<String>> ruleDescToRuleId, Map<String, String> mapOfRuleIdToHelpNames, String desc, RuleSeverity sev, int ruleIndex) {
        if (!rulesAddedToSeverityMap.contains(rule.getRuleId())) {
            TreeSet<AnalysisRule> rulesBySeverity;
            SortedMap<Object, Object> mapOfCategoryToRules;
            String category = rule.getCategory();
            String ruleId = (String)ruleDescToRuleId.get(desc).iterator().next();
            String helpFileName = mapOfRuleIdToHelpNames.get(ruleId);
            String helpId = this.getHelpId(helpFileName);
            if (helpId != null) {
                String helpContent = this.loadRuleHelpBody(helpFileName, helpId, desc);
                rule.setHelpInfo(helpContent, helpId, helpFileName);
                this.helpLoaded.add(helpFileName);
                this.mapOfHelpContent.put(helpId, helpContent);
            }
            if (!this.mapOfSeverityToAnalysisRules.containsKey((Object)sev)) {
                mapOfCategoryToRules = new TreeMap();
                this.mapOfSeverityToAnalysisRules.put(sev, mapOfCategoryToRules);
            } else {
                mapOfCategoryToRules = this.mapOfSeverityToAnalysisRules.get((Object)sev);
            }
            if (!mapOfCategoryToRules.containsKey(category)) {
                rulesBySeverity = new TreeSet<AnalysisRule>(new MyAnalysisComp());
                mapOfCategoryToRules.put(category, rulesBySeverity);
            } else {
                rulesBySeverity = (TreeSet<AnalysisRule>)mapOfCategoryToRules.get(category);
            }
            boolean ruleAdded = rulesBySeverity.add(rule);
            if (ruleAdded) {
                rule.setRuleIndexAdded(ruleIndex);
                ++ruleIndex;
            }
            rulesAddedToSeverityMap.add(rule.getRuleId());
        }
        return ruleIndex;
    }

    public Map<String, AnalysisRule> getConnectivityRules() {
        return this.connectivityRuleNameToRule;
    }

    public ModuleData getModuleData() {
        return this.moduleData;
    }

    protected void storeAnalysisRulesByCategoryNames(String category, Map<String, List<String>> rulesByType, Map<String, SortedSet<String>> ruleDescToRuleIds, Map<String, RuleSeverity> ruleSeverities, Map<String, String> mapOfRuleIdToHelpNames, List<String> connectivityRulesAnalyzed, Set<String> rulesFlagged) {
        Set<String> ruleTypes = rulesByType.keySet();
        for (String ruleType : ruleTypes) {
            List<String> ruleIdentifiers = rulesByType.get(ruleType);
            for (String ruleIdentifier : ruleIdentifiers) {
                int splitIndex = ruleIdentifier.lastIndexOf(61);
                String ruleId = ruleIdentifier.substring(splitIndex + 1);
                String ruleName = ruleIdentifier.substring(0, splitIndex);
                boolean hasResults = false;
                SortedSet<String> ruleIds = ruleDescToRuleIds.get(ruleName);
                for (String id : ruleIds) {
                    if (!id.equals(ruleId) || !rulesFlagged.contains(id)) continue;
                    hasResults = true;
                    break;
                }
                if (!hasResults && !this.showAllHelp || this.mapOfIdToAnalysisRules.containsKey(ruleId)) continue;
                RuleSeverity severity = ruleSeverities.get(ruleId);
                boolean hasRecipe = false;
                LinkedHashSet<String> recipes = null;
                if (this.rulesToRecipes != null) {
                    recipes = this.rulesToRecipes.get(ruleId);
                    boolean bl = hasRecipe = recipes != null && !recipes.isEmpty();
                }
                if (hasResults) {
                    switch (severity) {
                        case SEVERE: {
                            ++this.numSevereRules;
                            if (!hasRecipe) break;
                            ++this.numSevereRecipes;
                            break;
                        }
                        case WARNING: {
                            ++this.numWarningRules;
                            if (!hasRecipe) break;
                            ++this.numWarningRecipes;
                            break;
                        }
                        case INFO: {
                            ++this.numInfoRules;
                            if (!hasRecipe) break;
                            ++this.numInfoRecipes;
                            break;
                        }
                        case NONE: {
                            ++this.numNoSeverityRules;
                            if (!hasRecipe) break;
                            ++this.numNoSeverityRecipes;
                        }
                    }
                    ++this.totalNumberOfRulesWithResults;
                    if (hasRecipe) {
                        ++this.totalNumberOfRecipesWithResults;
                    }
                }
                this.rulesWithResultsIds.add(ruleId);
                AnalysisRule rule = new AnalysisRule(ruleId, ruleName, category, severity, recipes);
                this.mapOfIdToAnalysisRules.put(ruleId, rule);
                if (!connectivityRulesAnalyzed.contains(ruleName)) continue;
                this.connectivityRuleNameToRule.put(ruleName, rule);
            }
        }
    }

    public String loadRuleHelpBody(String fileName, String helpId, String defaultHelpTitle) {
        this.helpInProcessOfBeingLoaded.add(helpId);
        String h3WithId = "<h3>";
        String fileContents = ReportUtility.loadFileAsString(fileName.startsWith("/ruleinfo/") || fileName.startsWith("/help/") ? String.valueOf(ReportUtility.helpPrefix.get()) + fileName : fileName);
        boolean useDefaultHelpTitle = false;
        if (!(fileContents != null && fileContents.length() != 0 || ReportUtility.helpPrefix.equals("/help"))) {
            fileContents = ReportUtility.loadFileAsString("/help" + fileName);
            useDefaultHelpTitle = true;
        }
        String helpBodyContents = null;
        if (fileContents != null) {
            fileContents = fileContents.replaceAll("<script[\\s\\S]*?(\\/>|\\/script>)", "");
            fileContents = fileContents.replaceAll("<form[\\s\\S]*?(\\/>|\\/form>)", "");
            fileContents = fileContents.replaceAll("<\\?php[\\s\\S]*?\\?>", "");
            int startIndex = fileContents.indexOf("<body");
            int endIndex = fileContents.indexOf("</body>");
            if (startIndex > -1 && endIndex > -1 && endIndex > startIndex) {
                helpBodyContents = fileContents.substring(startIndex, endIndex + "</body>".length());
                String helpTitle = defaultHelpTitle;
                int index = helpBodyContents.indexOf("<p");
                if (!useDefaultHelpTitle) {
                    int spanIndex = helpBodyContents.indexOf("<span");
                    int h2Index = helpBodyContents.indexOf("<h2");
                    if (spanIndex > -1 && spanIndex < index) {
                        int titleIndex = helpBodyContents.indexOf(62, spanIndex);
                        int endTitleIndex = helpBodyContents.indexOf("</span>", titleIndex);
                        helpTitle = helpBodyContents.substring(titleIndex + 1, endTitleIndex);
                    } else if (h2Index > -1 && h2Index < index) {
                        int titleIndex = helpBodyContents.indexOf(62, h2Index);
                        int endTitleIndex = helpBodyContents.indexOf("</h2>", titleIndex);
                        helpTitle = helpBodyContents.substring(titleIndex + 1, endTitleIndex);
                    }
                }
                h3WithId = String.valueOf(h3WithId) + helpTitle + "</h3>\n";
                int endDivIndex = helpBodyContents.lastIndexOf("</div>");
                if (index > -1 && endDivIndex > -1 && endDivIndex > index) {
                    helpBodyContents = helpBodyContents.substring(index, endDivIndex);
                }
                String TABLE_SUMMARY = "<table summary=\"" + Messages.getString("ANALYSIS_REPORT_TABLE_SUMMARY_HELP") + "\"";
                helpBodyContents = helpBodyContents.replace(TABLE_ELEMENT, TABLE_SUMMARY);
                helpBodyContents = this.replaceReferencesToOtherHelpFiles(helpBodyContents, fileName, helpId);
                helpBodyContents = String.valueOf(h3WithId) + helpBodyContents;
            } else {
                helpBodyContents = "<h3>" + defaultHelpTitle + "</h3>\n";
            }
        } else {
            helpBodyContents = "<h3>" + defaultHelpTitle + "</h3>\n";
        }
        this.helpInProcessOfBeingLoaded.remove(helpId);
        return helpBodyContents;
    }

    public Set<String> getRuleIds() {
        return this.rulesWithResultsIds;
    }

    public String replaceReferencesToOtherHelpFiles(String contents, String fileName, String referencingHelpId) {
        Pattern matchAnchorsWithHrefPattern = Pattern.compile("<a[\\s\\S]*?href[\\s\\S]*?<\\/a>");
        Pattern matchHrefLinkPattern = Pattern.compile("(?<=href\\=\").*?(?=\")");
        Pattern matchPreviousDir = Pattern.compile("([^/]+/)(\\.\\./)");
        Matcher anchorsWithHrefMatcher = matchAnchorsWithHrefPattern.matcher(contents);
        String prefix = fileName.contains("/") ? fileName.substring(0, fileName.lastIndexOf(47) + 1) : "";
        while (anchorsWithHrefMatcher.find()) {
            String thisLink;
            String anchor = anchorsWithHrefMatcher.group();
            Matcher hrefMatcher = matchHrefLinkPattern.matcher(anchor);
            String string = thisLink = hrefMatcher.find() ? hrefMatcher.group() : "";
            if ((thisLink.startsWith("./") || thisLink.startsWith("../") || PLUGINS_ROOT_REGEX.matcher(thisLink).matches() || !thisLink.contains("/")) && thisLink.endsWith(".html")) {
                String linkWithQuotes = "\"" + thisLink + "\"";
                contents = contents.replace(linkWithQuotes, String.valueOf(linkWithQuotes) + " class=\"Rule-Help__Inner-Link\"");
                String localRef = thisLink.startsWith("./") ? thisLink.substring(2) : thisLink;
                String refFileName = String.valueOf(prefix) + localRef;
                if (PLUGINS_ROOT_REGEX.matcher(thisLink).matches()) {
                    String helpRefPrefix = thisLink.substring(thisLink.indexOf(47) + 1);
                    refFileName = helpRefPrefix.substring(helpRefPrefix.indexOf(47));
                }
                String helpId = this.getHelpId(refFileName);
                refFileName = matchPreviousDir.matcher(refFileName).replaceAll("");
                if (!this.helpInProcessOfBeingLoaded.contains(helpId) && !this.helpLoaded.contains(refFileName)) {
                    String desc = anchor.substring(anchor.indexOf(62) + 1);
                    int endIndex = desc.indexOf("</a>");
                    desc = desc.substring(0, endIndex);
                    String refHelp = this.loadRuleHelpBody(refFileName, helpId, desc);
                    this.helpLoaded.add(refFileName);
                    this.mapOfHelpContent.put(helpId, refHelp);
                }
                contents = contents.replace(thisLink, "#" + helpId);
                continue;
            }
            Matcher onClickMatcher = MATCH_ONCLICK_PATTERN.matcher(anchor);
            String onClick = onClickMatcher.find() ? onClickMatcher.group() : null;
            String string2 = contents = onClick != null ? contents.replace(onClick, "target=\"_blank\" rel=\"noopener noreferrer\"") : contents;
        }
        return contents;
    }

    public String getHelpId(String fileName) {
        if (fileName != null) {
            String helpId = fileName.contains("/") ? fileName.substring(fileName.lastIndexOf(47) + 1) : fileName;
            helpId = helpId.endsWith(".html") ? helpId.substring(0, helpId.lastIndexOf(".html")) : helpId;
            return "help" + helpId;
        }
        return null;
    }

    public SortedMap<RuleSeverity, SortedMap<String, TreeSet<AnalysisRule>>> getMapOfSeverityToAnalysisRules() {
        return this.mapOfSeverityToAnalysisRules;
    }

    public SortedMap<String, String> getMapOfHelpContent() {
        return this.mapOfHelpContent;
    }

    public Set<String> getHelpLoaded() {
        return this.helpLoaded;
    }

    public boolean includeConnectivitySummary() {
        return this.includeConnectivitySummary;
    }

    public int getAnalysisRulesRanInReport() {
        return this.totalNumberOfRulesWithResults;
    }

    public int getRecipesInReport() {
        return this.totalNumberOfRecipesWithResults;
    }

    public int getTotalNumberOfResults() {
        return this.totalNumberOfResults;
    }

    public int getTotalNumberOfRecipes() {
        return this.totalNumberOfRecipes;
    }

    public LinkedHashSet<String> getRuleRecipes(String ruleId) {
        if (this.rulesToRecipes != null) {
            return this.rulesToRecipes.get(ruleId);
        }
        return null;
    }

    public int getSeverityResultCount(RuleSeverity sev) {
        switch (sev) {
            case SEVERE: {
                return this.numSevereRuleResults;
            }
            case WARNING: {
                return this.numWarningRuleResults;
            }
            case INFO: {
                return this.numInfoRuleResults;
            }
            case NONE: {
                return this.numNoSeverityRuleResults;
            }
        }
        return 0;
    }

    public int getSeverityRecipeResultCount(RuleSeverity sev) {
        switch (sev) {
            case SEVERE: {
                return this.numSevereRecipeResults;
            }
            case WARNING: {
                return this.numWarningRecipeResults;
            }
            case INFO: {
                return this.numInfoRecipeResults;
            }
            case NONE: {
                return this.numNoSeverityRecipeResults;
            }
        }
        return 0;
    }

    public SortedMap<String, AnalysisRule> getMapOfDescToAnalysisRules() {
        return this.mapOfIdToAnalysisRules;
    }

    public int getSeverityRuleCount(RuleSeverity sev) {
        switch (sev) {
            case SEVERE: {
                return this.numSevereRules;
            }
            case WARNING: {
                return this.numWarningRules;
            }
            case INFO: {
                return this.numInfoRules;
            }
            case NONE: {
                return this.numNoSeverityRules;
            }
        }
        return 0;
    }

    public int getSeverityRecipeCount(RuleSeverity sev) {
        switch (sev) {
            case SEVERE: {
                return this.numSevereRecipes;
            }
            case WARNING: {
                return this.numWarningRecipes;
            }
            case INFO: {
                return this.numInfoRecipes;
            }
            case NONE: {
                return this.numNoSeverityRecipes;
            }
        }
        return 0;
    }

    public RewriteConfig getRewriteConfig() {
        return new RewriteConfig(this.getRewriteMavenConfig(), this.getRewriteGradleConfig());
    }

    public RewriteConfig getRewriteConfig(List<String> ruleIds) {
        HashMap<String, LinkedHashSet<String>> filteredRulesToRecipes = new HashMap<String, LinkedHashSet<String>>();
        TreeMap<String, AnalysisRule> filteredMapOfIdToAnalysisRules = new TreeMap<String, AnalysisRule>();
        for (String ruleId : ruleIds) {
            if (!this.rulesToRecipes.containsKey(ruleId)) continue;
            filteredRulesToRecipes.put(ruleId, this.rulesToRecipes.get(ruleId));
            filteredMapOfIdToAnalysisRules.put(ruleId, (AnalysisRule)this.mapOfIdToAnalysisRules.get(ruleId));
        }
        String mavenConfig = "";
        String gradleConfig = "";
        if (filteredRulesToRecipes.size() > 0) {
            mavenConfig = RewriteMavenConfigWriter.buildRewriteConfig(filteredRulesToRecipes, filteredMapOfIdToAnalysisRules, this.showAllHelp);
            gradleConfig = RewriteGradleConfigWriter.buildRewriteConfig(filteredRulesToRecipes, filteredMapOfIdToAnalysisRules, this.showAllHelp);
        }
        return new RewriteConfig(mavenConfig, gradleConfig);
    }

    public String getRewriteMavenConfig() {
        if (this.showAllHelp || this.rewriteMavenConfig == null && this.totalNumberOfResults > 0) {
            this.rewriteMavenConfig = RewriteMavenConfigWriter.buildRewriteConfig(this.rulesToRecipes, this.mapOfIdToAnalysisRules, this.showAllHelp);
        }
        return this.rewriteMavenConfig;
    }

    public String getRewriteGradleConfig() {
        if (this.showAllHelp || this.rewriteGradleConfig == null && this.totalNumberOfResults > 0) {
            this.rewriteGradleConfig = RewriteGradleConfigWriter.buildRewriteConfig(this.rulesToRecipes, this.mapOfIdToAnalysisRules, this.showAllHelp);
        }
        return this.rewriteGradleConfig;
    }

    public boolean containsAutomatedFix() {
        return this.totalNumberOfRecipes > 0 || this.showAllHelp;
    }

    public String getAnalysisResultCommandlineOutputString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.getString("ANALYSIS_OUTPUT_SUMMARY"));
        sb.append(Messages.getString(Messages.getFormattedMessage(Messages.getString("ANALYSIS_OUTPUT_CRITICAL_RESULT"), this.numSevereRules)));
        sb.append(Messages.getString(Messages.getFormattedMessage(Messages.getString("ANALYSIS_OUTPUT_WARNING_RESULT"), this.numWarningRules)));
        sb.append(Messages.getString(Messages.getFormattedMessage(Messages.getString("ANALYSIS_OUTPUT_INFORMATION_RESULT"), this.numInfoRules)));
        sb.append(Messages.getString("\n"));
        sb.append(Messages.getString(Messages.getFormattedMessage(Messages.getString("ANALYSIS_OUTPUT_AUTOMATED_CODE_RECIPES"), this.totalNumberOfRecipes)));
        sb.append(Messages.getString("\n"));
        sb.append(Messages.getString("ANALYSIS_OUTPUT_OPENREWRITE_MAVEN_CONFIGURATION"));
        sb.append(this.getRewriteMavenConfig());
        sb.append(Messages.getString("\n"));
        sb.append(Messages.getString("ANALYSIS_OUTPUT_OPENREWRITE_GRADLE_CONFIGURATION"));
        sb.append(this.getRewriteGradleConfig());
        return sb.toString();
    }

    class MyAnalysisComp
    implements Comparator<AnalysisRule> {
        MyAnalysisComp() {
        }

        @Override
        public int compare(AnalysisRule e1, AnalysisRule e2) {
            return e1.getRuleName().compareTo(e2.getRuleName());
        }
    }

    class MySeverityComp
    implements Comparator<RuleSeverity> {
        MySeverityComp() {
        }

        @Override
        public int compare(RuleSeverity e1, RuleSeverity e2) {
            return new Integer(e1.ordinal()).compareTo(new Integer(e2.ordinal()));
        }
    }
}

