/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.asm.utilities;

import java.util.List;
import java.util.Set;

public class PackageHelper {
    public static boolean matchPackageName(Set<String> packageNameCollection, String matchPackageName) {
        boolean match = false;
        if (packageNameCollection.contains(matchPackageName)) {
            match = true;
        } else if (matchPackageName.endsWith("*")) {
            boolean matchSubPackages = matchPackageName.endsWith(".*");
            String comparePackageName = matchPackageName.substring(0, matchPackageName.length() - 1);
            for (String nextPackage : packageNameCollection) {
                match = PackageHelper.matchPackageName(nextPackage, comparePackageName, matchSubPackages);
                if (match) break;
            }
        }
        return match;
    }

    public static boolean matchPackageName(String packageName, String wildcardPackageName) {
        boolean matchSubPackages = wildcardPackageName.endsWith(".*");
        String comparePackageName = wildcardPackageName.substring(0, wildcardPackageName.length() - 1);
        return PackageHelper.matchPackageName(packageName, comparePackageName, matchSubPackages);
    }

    private static boolean matchPackageName(String packageName, String comparePackageName, boolean matchSubPackages) {
        boolean match = false;
        if (matchSubPackages) {
            if (packageName.startsWith(comparePackageName)) {
                match = true;
            }
        } else if (packageName.equals(comparePackageName) || packageName.startsWith(String.valueOf(comparePackageName) + ".")) {
            match = true;
        }
        return match;
    }

    public static boolean matchPackageNames(Set<String> packageNameCollection, List<String> packages) {
        for (String pack : packages) {
            if (packageNameCollection.contains(pack)) continue;
            return false;
        }
        return true;
    }
}

